/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a single field within an Iceberg sort order specification, including the source field, transformation, sort
 * direction, and null value ordering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergSortField implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergSortField.Builder, IcebergSortField> {
    private static final SdkField<Integer> SOURCE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourceId").getter(getter(IcebergSortField::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final SdkField<String> TRANSFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Transform").getter(getter(IcebergSortField::transform)).setter(setter(Builder::transform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transform").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(IcebergSortField::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<String> NULL_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullOrder").getter(getter(IcebergSortField::nullOrderAsString)).setter(setter(Builder::nullOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD,
            TRANSFORM_FIELD, DIRECTION_FIELD, NULL_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer sourceId;

    private final String transform;

    private final String direction;

    private final String nullOrder;

    private IcebergSortField(BuilderImpl builder) {
        this.sourceId = builder.sourceId;
        this.transform = builder.transform;
        this.direction = builder.direction;
        this.nullOrder = builder.nullOrder;
    }

    /**
     * <p>
     * The identifier of the source field from the table schema that this sort field is based on.
     * </p>
     * 
     * @return The identifier of the source field from the table schema that this sort field is based on.
     */
    public final Integer sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * The transformation function applied to the source field before sorting, such as identity, bucket, or truncate.
     * </p>
     * 
     * @return The transformation function applied to the source field before sorting, such as identity, bucket, or
     *         truncate.
     */
    public final String transform() {
        return transform;
    }

    /**
     * <p>
     * The sort direction for this field, either ascending or descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link IcebergSortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #directionAsString}.
     * </p>
     * 
     * @return The sort direction for this field, either ascending or descending.
     * @see IcebergSortDirection
     */
    public final IcebergSortDirection direction() {
        return IcebergSortDirection.fromValue(direction);
    }

    /**
     * <p>
     * The sort direction for this field, either ascending or descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link IcebergSortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #directionAsString}.
     * </p>
     * 
     * @return The sort direction for this field, either ascending or descending.
     * @see IcebergSortDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * The ordering behavior for null values in this field, specifying whether nulls should appear first or last in the
     * sort order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOrder} will
     * return {@link IcebergNullOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOrderAsString}.
     * </p>
     * 
     * @return The ordering behavior for null values in this field, specifying whether nulls should appear first or last
     *         in the sort order.
     * @see IcebergNullOrder
     */
    public final IcebergNullOrder nullOrder() {
        return IcebergNullOrder.fromValue(nullOrder);
    }

    /**
     * <p>
     * The ordering behavior for null values in this field, specifying whether nulls should appear first or last in the
     * sort order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOrder} will
     * return {@link IcebergNullOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOrderAsString}.
     * </p>
     * 
     * @return The ordering behavior for null values in this field, specifying whether nulls should appear first or last
     *         in the sort order.
     * @see IcebergNullOrder
     */
    public final String nullOrderAsString() {
        return nullOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(transform());
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nullOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergSortField)) {
            return false;
        }
        IcebergSortField other = (IcebergSortField) obj;
        return Objects.equals(sourceId(), other.sourceId()) && Objects.equals(transform(), other.transform())
                && Objects.equals(directionAsString(), other.directionAsString())
                && Objects.equals(nullOrderAsString(), other.nullOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergSortField").add("SourceId", sourceId()).add("Transform", transform())
                .add("Direction", directionAsString()).add("NullOrder", nullOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "Transform":
            return Optional.ofNullable(clazz.cast(transform()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "NullOrder":
            return Optional.ofNullable(clazz.cast(nullOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceId", SOURCE_ID_FIELD);
        map.put("Transform", TRANSFORM_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("NullOrder", NULL_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergSortField, T> g) {
        return obj -> g.apply((IcebergSortField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergSortField> {
        /**
         * <p>
         * The identifier of the source field from the table schema that this sort field is based on.
         * </p>
         * 
         * @param sourceId
         *        The identifier of the source field from the table schema that this sort field is based on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(Integer sourceId);

        /**
         * <p>
         * The transformation function applied to the source field before sorting, such as identity, bucket, or
         * truncate.
         * </p>
         * 
         * @param transform
         *        The transformation function applied to the source field before sorting, such as identity, bucket, or
         *        truncate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transform(String transform);

        /**
         * <p>
         * The sort direction for this field, either ascending or descending.
         * </p>
         * 
         * @param direction
         *        The sort direction for this field, either ascending or descending.
         * @see IcebergSortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IcebergSortDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The sort direction for this field, either ascending or descending.
         * </p>
         * 
         * @param direction
         *        The sort direction for this field, either ascending or descending.
         * @see IcebergSortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IcebergSortDirection
         */
        Builder direction(IcebergSortDirection direction);

        /**
         * <p>
         * The ordering behavior for null values in this field, specifying whether nulls should appear first or last in
         * the sort order.
         * </p>
         * 
         * @param nullOrder
         *        The ordering behavior for null values in this field, specifying whether nulls should appear first or
         *        last in the sort order.
         * @see IcebergNullOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IcebergNullOrder
         */
        Builder nullOrder(String nullOrder);

        /**
         * <p>
         * The ordering behavior for null values in this field, specifying whether nulls should appear first or last in
         * the sort order.
         * </p>
         * 
         * @param nullOrder
         *        The ordering behavior for null values in this field, specifying whether nulls should appear first or
         *        last in the sort order.
         * @see IcebergNullOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IcebergNullOrder
         */
        Builder nullOrder(IcebergNullOrder nullOrder);
    }

    static final class BuilderImpl implements Builder {
        private Integer sourceId;

        private String transform;

        private String direction;

        private String nullOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergSortField model) {
            sourceId(model.sourceId);
            transform(model.transform);
            direction(model.direction);
            nullOrder(model.nullOrder);
        }

        public final Integer getSourceId() {
            return sourceId;
        }

        public final void setSourceId(Integer sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(Integer sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getTransform() {
            return transform;
        }

        public final void setTransform(String transform) {
            this.transform = transform;
        }

        @Override
        public final Builder transform(String transform) {
            this.transform = transform;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(IcebergSortDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getNullOrder() {
            return nullOrder;
        }

        public final void setNullOrder(String nullOrder) {
            this.nullOrder = nullOrder;
        }

        @Override
        public final Builder nullOrder(String nullOrder) {
            this.nullOrder = nullOrder;
            return this;
        }

        @Override
        public final Builder nullOrder(IcebergNullOrder nullOrder) {
            this.nullOrder(nullOrder == null ? null : nullOrder.toString());
            return this;
        }

        @Override
        public IcebergSortField build() {
            return new IcebergSortField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
