/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CreateCsvClassifierRequest;
import software.amazon.awssdk.services.glue.model.CreateGrokClassifierRequest;
import software.amazon.awssdk.services.glue.model.CreateJsonClassifierRequest;
import software.amazon.awssdk.services.glue.model.CreateXMLClassifierRequest;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClassifierRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateClassifierRequest> {
    private static final SdkField<CreateGrokClassifierRequest> GROK_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GrokClassifier").getter(CreateClassifierRequest.getter(CreateClassifierRequest::grokClassifier)).setter(CreateClassifierRequest.setter(Builder::grokClassifier)).constructor(CreateGrokClassifierRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokClassifier").build()}).build();
    private static final SdkField<CreateXMLClassifierRequest> XML_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XMLClassifier").getter(CreateClassifierRequest.getter(CreateClassifierRequest::xmlClassifier)).setter(CreateClassifierRequest.setter(Builder::xmlClassifier)).constructor(CreateXMLClassifierRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMLClassifier").build()}).build();
    private static final SdkField<CreateJsonClassifierRequest> JSON_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JsonClassifier").getter(CreateClassifierRequest.getter(CreateClassifierRequest::jsonClassifier)).setter(CreateClassifierRequest.setter(Builder::jsonClassifier)).constructor(CreateJsonClassifierRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonClassifier").build()}).build();
    private static final SdkField<CreateCsvClassifierRequest> CSV_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CsvClassifier").getter(CreateClassifierRequest.getter(CreateClassifierRequest::csvClassifier)).setter(CreateClassifierRequest.setter(Builder::csvClassifier)).constructor(CreateCsvClassifierRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvClassifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROK_CLASSIFIER_FIELD, XML_CLASSIFIER_FIELD, JSON_CLASSIFIER_FIELD, CSV_CLASSIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateClassifierRequest.memberNameToFieldInitializer();
    private final CreateGrokClassifierRequest grokClassifier;
    private final CreateXMLClassifierRequest xmlClassifier;
    private final CreateJsonClassifierRequest jsonClassifier;
    private final CreateCsvClassifierRequest csvClassifier;

    private CreateClassifierRequest(BuilderImpl builder) {
        super(builder);
        this.grokClassifier = builder.grokClassifier;
        this.xmlClassifier = builder.xmlClassifier;
        this.jsonClassifier = builder.jsonClassifier;
        this.csvClassifier = builder.csvClassifier;
    }

    public final CreateGrokClassifierRequest grokClassifier() {
        return this.grokClassifier;
    }

    public final CreateXMLClassifierRequest xmlClassifier() {
        return this.xmlClassifier;
    }

    public final CreateJsonClassifierRequest jsonClassifier() {
        return this.jsonClassifier;
    }

    public final CreateCsvClassifierRequest csvClassifier() {
        return this.csvClassifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.grokClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.xmlClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvClassifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClassifierRequest)) {
            return false;
        }
        CreateClassifierRequest other = (CreateClassifierRequest)((Object)obj);
        return Objects.equals(this.grokClassifier(), other.grokClassifier()) && Objects.equals(this.xmlClassifier(), other.xmlClassifier()) && Objects.equals(this.jsonClassifier(), other.jsonClassifier()) && Objects.equals(this.csvClassifier(), other.csvClassifier());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClassifierRequest").add("GrokClassifier", (Object)this.grokClassifier()).add("XMLClassifier", (Object)this.xmlClassifier()).add("JsonClassifier", (Object)this.jsonClassifier()).add("CsvClassifier", (Object)this.csvClassifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrokClassifier": {
                return Optional.ofNullable(clazz.cast(this.grokClassifier()));
            }
            case "XMLClassifier": {
                return Optional.ofNullable(clazz.cast(this.xmlClassifier()));
            }
            case "JsonClassifier": {
                return Optional.ofNullable(clazz.cast(this.jsonClassifier()));
            }
            case "CsvClassifier": {
                return Optional.ofNullable(clazz.cast(this.csvClassifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GrokClassifier", GROK_CLASSIFIER_FIELD);
        map.put("XMLClassifier", XML_CLASSIFIER_FIELD);
        map.put("JsonClassifier", JSON_CLASSIFIER_FIELD);
        map.put("CsvClassifier", CSV_CLASSIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClassifierRequest, T> g) {
        return obj -> g.apply((CreateClassifierRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private CreateGrokClassifierRequest grokClassifier;
        private CreateXMLClassifierRequest xmlClassifier;
        private CreateJsonClassifierRequest jsonClassifier;
        private CreateCsvClassifierRequest csvClassifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClassifierRequest model) {
            super(model);
            this.grokClassifier(model.grokClassifier);
            this.xmlClassifier(model.xmlClassifier);
            this.jsonClassifier(model.jsonClassifier);
            this.csvClassifier(model.csvClassifier);
        }

        public final CreateGrokClassifierRequest.Builder getGrokClassifier() {
            return this.grokClassifier != null ? this.grokClassifier.toBuilder() : null;
        }

        public final void setGrokClassifier(CreateGrokClassifierRequest.BuilderImpl grokClassifier) {
            this.grokClassifier = grokClassifier != null ? grokClassifier.build() : null;
        }

        @Override
        public final Builder grokClassifier(CreateGrokClassifierRequest grokClassifier) {
            this.grokClassifier = grokClassifier;
            return this;
        }

        public final CreateXMLClassifierRequest.Builder getXmlClassifier() {
            return this.xmlClassifier != null ? this.xmlClassifier.toBuilder() : null;
        }

        public final void setXmlClassifier(CreateXMLClassifierRequest.BuilderImpl xmlClassifier) {
            this.xmlClassifier = xmlClassifier != null ? xmlClassifier.build() : null;
        }

        @Override
        public final Builder xmlClassifier(CreateXMLClassifierRequest xmlClassifier) {
            this.xmlClassifier = xmlClassifier;
            return this;
        }

        public final CreateJsonClassifierRequest.Builder getJsonClassifier() {
            return this.jsonClassifier != null ? this.jsonClassifier.toBuilder() : null;
        }

        public final void setJsonClassifier(CreateJsonClassifierRequest.BuilderImpl jsonClassifier) {
            this.jsonClassifier = jsonClassifier != null ? jsonClassifier.build() : null;
        }

        @Override
        public final Builder jsonClassifier(CreateJsonClassifierRequest jsonClassifier) {
            this.jsonClassifier = jsonClassifier;
            return this;
        }

        public final CreateCsvClassifierRequest.Builder getCsvClassifier() {
            return this.csvClassifier != null ? this.csvClassifier.toBuilder() : null;
        }

        public final void setCsvClassifier(CreateCsvClassifierRequest.BuilderImpl csvClassifier) {
            this.csvClassifier = csvClassifier != null ? csvClassifier.build() : null;
        }

        @Override
        public final Builder csvClassifier(CreateCsvClassifierRequest csvClassifier) {
            this.csvClassifier = csvClassifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClassifierRequest build() {
            return new CreateClassifierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClassifierRequest> {
        public Builder grokClassifier(CreateGrokClassifierRequest var1);

        default public Builder grokClassifier(Consumer<CreateGrokClassifierRequest.Builder> grokClassifier) {
            return this.grokClassifier((CreateGrokClassifierRequest)((CreateGrokClassifierRequest.Builder)CreateGrokClassifierRequest.builder().applyMutation(grokClassifier)).build());
        }

        public Builder xmlClassifier(CreateXMLClassifierRequest var1);

        default public Builder xmlClassifier(Consumer<CreateXMLClassifierRequest.Builder> xmlClassifier) {
            return this.xmlClassifier((CreateXMLClassifierRequest)((CreateXMLClassifierRequest.Builder)CreateXMLClassifierRequest.builder().applyMutation(xmlClassifier)).build());
        }

        public Builder jsonClassifier(CreateJsonClassifierRequest var1);

        default public Builder jsonClassifier(Consumer<CreateJsonClassifierRequest.Builder> jsonClassifier) {
            return this.jsonClassifier((CreateJsonClassifierRequest)((CreateJsonClassifierRequest.Builder)CreateJsonClassifierRequest.builder().applyMutation(jsonClassifier)).build());
        }

        public Builder csvClassifier(CreateCsvClassifierRequest var1);

        default public Builder csvClassifier(Consumer<CreateCsvClassifierRequest.Builder> csvClassifier) {
            return this.csvClassifier((CreateCsvClassifierRequest)((CreateCsvClassifierRequest.Builder)CreateCsvClassifierRequest.builder().applyMutation(csvClassifier)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

