/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.KafkaStreamingSourceOptions;
import software.amazon.awssdk.services.glue.model.StreamingDataPreviewOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogKafkaSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogKafkaSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CatalogKafkaSource.getter(CatalogKafkaSource::name)).setter(CatalogKafkaSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> WINDOW_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WindowSize").getter(CatalogKafkaSource.getter(CatalogKafkaSource::windowSize)).setter(CatalogKafkaSource.setter(Builder::windowSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowSize").build()}).build();
    private static final SdkField<Boolean> DETECT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DetectSchema").getter(CatalogKafkaSource.getter(CatalogKafkaSource::detectSchema)).setter(CatalogKafkaSource.setter(Builder::detectSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectSchema").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(CatalogKafkaSource.getter(CatalogKafkaSource::table)).setter(CatalogKafkaSource.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(CatalogKafkaSource.getter(CatalogKafkaSource::database)).setter(CatalogKafkaSource.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<KafkaStreamingSourceOptions> STREAMING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingOptions").getter(CatalogKafkaSource.getter(CatalogKafkaSource::streamingOptions)).setter(CatalogKafkaSource.setter(Builder::streamingOptions)).constructor(KafkaStreamingSourceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingOptions").build()}).build();
    private static final SdkField<StreamingDataPreviewOptions> DATA_PREVIEW_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPreviewOptions").getter(CatalogKafkaSource.getter(CatalogKafkaSource::dataPreviewOptions)).setter(CatalogKafkaSource.setter(Builder::dataPreviewOptions)).constructor(StreamingDataPreviewOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreviewOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, WINDOW_SIZE_FIELD, DETECT_SCHEMA_FIELD, TABLE_FIELD, DATABASE_FIELD, STREAMING_OPTIONS_FIELD, DATA_PREVIEW_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CatalogKafkaSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer windowSize;
    private final Boolean detectSchema;
    private final String table;
    private final String database;
    private final KafkaStreamingSourceOptions streamingOptions;
    private final StreamingDataPreviewOptions dataPreviewOptions;

    private CatalogKafkaSource(BuilderImpl builder) {
        this.name = builder.name;
        this.windowSize = builder.windowSize;
        this.detectSchema = builder.detectSchema;
        this.table = builder.table;
        this.database = builder.database;
        this.streamingOptions = builder.streamingOptions;
        this.dataPreviewOptions = builder.dataPreviewOptions;
    }

    public final String name() {
        return this.name;
    }

    public final Integer windowSize() {
        return this.windowSize;
    }

    public final Boolean detectSchema() {
        return this.detectSchema;
    }

    public final String table() {
        return this.table;
    }

    public final String database() {
        return this.database;
    }

    public final KafkaStreamingSourceOptions streamingOptions() {
        return this.streamingOptions;
    }

    public final StreamingDataPreviewOptions dataPreviewOptions() {
        return this.dataPreviewOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPreviewOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogKafkaSource)) {
            return false;
        }
        CatalogKafkaSource other = (CatalogKafkaSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.windowSize(), other.windowSize()) && Objects.equals(this.detectSchema(), other.detectSchema()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.streamingOptions(), other.streamingOptions()) && Objects.equals(this.dataPreviewOptions(), other.dataPreviewOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogKafkaSource").add("Name", (Object)this.name()).add("WindowSize", (Object)this.windowSize()).add("DetectSchema", (Object)this.detectSchema()).add("Table", (Object)this.table()).add("Database", (Object)this.database()).add("StreamingOptions", (Object)this.streamingOptions()).add("DataPreviewOptions", (Object)this.dataPreviewOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "WindowSize": {
                return Optional.ofNullable(clazz.cast(this.windowSize()));
            }
            case "DetectSchema": {
                return Optional.ofNullable(clazz.cast(this.detectSchema()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "StreamingOptions": {
                return Optional.ofNullable(clazz.cast(this.streamingOptions()));
            }
            case "DataPreviewOptions": {
                return Optional.ofNullable(clazz.cast(this.dataPreviewOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("WindowSize", WINDOW_SIZE_FIELD);
        map.put("DetectSchema", DETECT_SCHEMA_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("StreamingOptions", STREAMING_OPTIONS_FIELD);
        map.put("DataPreviewOptions", DATA_PREVIEW_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogKafkaSource, T> g) {
        return obj -> g.apply((CatalogKafkaSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer windowSize;
        private Boolean detectSchema;
        private String table;
        private String database;
        private KafkaStreamingSourceOptions streamingOptions;
        private StreamingDataPreviewOptions dataPreviewOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogKafkaSource model) {
            this.name(model.name);
            this.windowSize(model.windowSize);
            this.detectSchema(model.detectSchema);
            this.table(model.table);
            this.database(model.database);
            this.streamingOptions(model.streamingOptions);
            this.dataPreviewOptions(model.dataPreviewOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getWindowSize() {
            return this.windowSize;
        }

        public final void setWindowSize(Integer windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public final Builder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public final Boolean getDetectSchema() {
            return this.detectSchema;
        }

        public final void setDetectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
        }

        @Override
        public final Builder detectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final KafkaStreamingSourceOptions.Builder getStreamingOptions() {
            return this.streamingOptions != null ? this.streamingOptions.toBuilder() : null;
        }

        public final void setStreamingOptions(KafkaStreamingSourceOptions.BuilderImpl streamingOptions) {
            this.streamingOptions = streamingOptions != null ? streamingOptions.build() : null;
        }

        @Override
        public final Builder streamingOptions(KafkaStreamingSourceOptions streamingOptions) {
            this.streamingOptions = streamingOptions;
            return this;
        }

        public final StreamingDataPreviewOptions.Builder getDataPreviewOptions() {
            return this.dataPreviewOptions != null ? this.dataPreviewOptions.toBuilder() : null;
        }

        public final void setDataPreviewOptions(StreamingDataPreviewOptions.BuilderImpl dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions != null ? dataPreviewOptions.build() : null;
        }

        @Override
        public final Builder dataPreviewOptions(StreamingDataPreviewOptions dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions;
            return this;
        }

        public CatalogKafkaSource build() {
            return new CatalogKafkaSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogKafkaSource> {
        public Builder name(String var1);

        public Builder windowSize(Integer var1);

        public Builder detectSchema(Boolean var1);

        public Builder table(String var1);

        public Builder database(String var1);

        public Builder streamingOptions(KafkaStreamingSourceOptions var1);

        default public Builder streamingOptions(Consumer<KafkaStreamingSourceOptions.Builder> streamingOptions) {
            return this.streamingOptions((KafkaStreamingSourceOptions)((KafkaStreamingSourceOptions.Builder)KafkaStreamingSourceOptions.builder().applyMutation(streamingOptions)).build());
        }

        public Builder dataPreviewOptions(StreamingDataPreviewOptions var1);

        default public Builder dataPreviewOptions(Consumer<StreamingDataPreviewOptions.Builder> dataPreviewOptions) {
            return this.dataPreviewOptions((StreamingDataPreviewOptions)((StreamingDataPreviewOptions.Builder)StreamingDataPreviewOptions.builder().applyMutation(dataPreviewOptions)).build());
        }
    }
}

