/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataSource;
import software.amazon.awssdk.services.glue.model.TaskStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityRulesetEvaluationRunDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityRulesetEvaluationRunDescription> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(DataQualityRulesetEvaluationRunDescription.getter(DataQualityRulesetEvaluationRunDescription::runId)).setter(DataQualityRulesetEvaluationRunDescription.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DataQualityRulesetEvaluationRunDescription.getter(DataQualityRulesetEvaluationRunDescription::statusAsString)).setter(DataQualityRulesetEvaluationRunDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(DataQualityRulesetEvaluationRunDescription.getter(DataQualityRulesetEvaluationRunDescription::startedOn)).setter(DataQualityRulesetEvaluationRunDescription.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(DataQualityRulesetEvaluationRunDescription.getter(DataQualityRulesetEvaluationRunDescription::dataSource)).setter(DataQualityRulesetEvaluationRunDescription.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD, STATUS_FIELD, STARTED_ON_FIELD, DATA_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQualityRulesetEvaluationRunDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String runId;
    private final String status;
    private final Instant startedOn;
    private final DataSource dataSource;

    private DataQualityRulesetEvaluationRunDescription(BuilderImpl builder) {
        this.runId = builder.runId;
        this.status = builder.status;
        this.startedOn = builder.startedOn;
        this.dataSource = builder.dataSource;
    }

    public final String runId() {
        return this.runId;
    }

    public final TaskStatusType status() {
        return TaskStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityRulesetEvaluationRunDescription)) {
            return false;
        }
        DataQualityRulesetEvaluationRunDescription other = (DataQualityRulesetEvaluationRunDescription)obj;
        return Objects.equals(this.runId(), other.runId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.dataSource(), other.dataSource());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityRulesetEvaluationRunDescription").add("RunId", (Object)this.runId()).add("Status", (Object)this.statusAsString()).add("StartedOn", (Object)this.startedOn()).add("DataSource", (Object)this.dataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RunId", RUN_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartedOn", STARTED_ON_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityRulesetEvaluationRunDescription, T> g) {
        return obj -> g.apply((DataQualityRulesetEvaluationRunDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String runId;
        private String status;
        private Instant startedOn;
        private DataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityRulesetEvaluationRunDescription model) {
            this.runId(model.runId);
            this.status(model.status);
            this.startedOn(model.startedOn);
            this.dataSource(model.dataSource);
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DataQualityRulesetEvaluationRunDescription build() {
            return new DataQualityRulesetEvaluationRunDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityRulesetEvaluationRunDescription> {
        public Builder runId(String var1);

        public Builder status(String var1);

        public Builder status(TaskStatusType var1);

        public Builder startedOn(Instant var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }
    }
}

