/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.FilterExpression;
import software.amazon.awssdk.services.glue.model.FilterExpressionsCopier;
import software.amazon.awssdk.services.glue.model.FilterLogicalOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupFilters> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(GroupFilters.getter(GroupFilters::groupName)).setter(GroupFilters.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<List<FilterExpression>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(GroupFilters.getter(GroupFilters::filters)).setter(GroupFilters.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOGICAL_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalOperator").getter(GroupFilters.getter(GroupFilters::logicalOperatorAsString)).setter(GroupFilters.setter(Builder::logicalOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, FILTERS_FIELD, LOGICAL_OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final List<FilterExpression> filters;
    private final String logicalOperator;

    private GroupFilters(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.filters = builder.filters;
        this.logicalOperator = builder.logicalOperator;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<FilterExpression> filters() {
        return this.filters;
    }

    public final FilterLogicalOperator logicalOperator() {
        return FilterLogicalOperator.fromValue(this.logicalOperator);
    }

    public final String logicalOperatorAsString() {
        return this.logicalOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupFilters)) {
            return false;
        }
        GroupFilters other = (GroupFilters)obj;
        return Objects.equals(this.groupName(), other.groupName()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.logicalOperatorAsString(), other.logicalOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GroupFilters").add("GroupName", (Object)this.groupName()).add("Filters", this.hasFilters() ? this.filters() : null).add("LogicalOperator", (Object)this.logicalOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "LogicalOperator": {
                return Optional.ofNullable(clazz.cast(this.logicalOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("LogicalOperator", LOGICAL_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupFilters, T> g) {
        return obj -> g.apply((GroupFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private List<FilterExpression> filters = DefaultSdkAutoConstructList.getInstance();
        private String logicalOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupFilters model) {
            this.groupName(model.groupName);
            this.filters(model.filters);
            this.logicalOperator(model.logicalOperator);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final List<FilterExpression.Builder> getFilters() {
            List<FilterExpression.Builder> result = FilterExpressionsCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<FilterExpression.BuilderImpl> filters) {
            this.filters = FilterExpressionsCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<FilterExpression> filters) {
            this.filters = FilterExpressionsCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(FilterExpression ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<FilterExpression.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (FilterExpression)((FilterExpression.Builder)FilterExpression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLogicalOperator() {
            return this.logicalOperator;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(FilterLogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator == null ? null : logicalOperator.toString());
            return this;
        }

        public GroupFilters build() {
            return new GroupFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupFilters> {
        public Builder groupName(String var1);

        public Builder filters(Collection<FilterExpression> var1);

        public Builder filters(FilterExpression ... var1);

        public Builder filters(Consumer<FilterExpression.Builder> ... var1);

        public Builder logicalOperator(String var1);

        public Builder logicalOperator(FilterLogicalOperator var1);
    }
}

