/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PiiType {
    ROW_AUDIT("RowAudit"),
    ROW_HASHING("RowHashing"),
    ROW_MASKING("RowMasking"),
    ROW_PARTIAL_MASKING("RowPartialMasking"),
    COLUMN_AUDIT("ColumnAudit"),
    COLUMN_HASHING("ColumnHashing"),
    COLUMN_MASKING("ColumnMasking"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PiiType> VALUE_MAP;
    private final String value;

    private PiiType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PiiType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PiiType> knownValues() {
        EnumSet<PiiType> knownValues = EnumSet.allOf(PiiType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PiiType.class, PiiType::toString);
    }
}

