/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DDBELTCatalogAdditionalOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamoDBCatalogSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamoDBCatalogSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DynamoDBCatalogSource.getter(DynamoDBCatalogSource::name)).setter(DynamoDBCatalogSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(DynamoDBCatalogSource.getter(DynamoDBCatalogSource::database)).setter(DynamoDBCatalogSource.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(DynamoDBCatalogSource.getter(DynamoDBCatalogSource::table)).setter(DynamoDBCatalogSource.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<Boolean> PITR_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PitrEnabled").getter(DynamoDBCatalogSource.getter(DynamoDBCatalogSource::pitrEnabled)).setter(DynamoDBCatalogSource.setter(Builder::pitrEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PitrEnabled").build()}).build();
    private static final SdkField<DDBELTCatalogAdditionalOptions> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalOptions").getter(DynamoDBCatalogSource.getter(DynamoDBCatalogSource::additionalOptions)).setter(DynamoDBCatalogSource.setter(Builder::additionalOptions)).constructor(DDBELTCatalogAdditionalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATABASE_FIELD, TABLE_FIELD, PITR_ENABLED_FIELD, ADDITIONAL_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DynamoDBCatalogSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String database;
    private final String table;
    private final Boolean pitrEnabled;
    private final DDBELTCatalogAdditionalOptions additionalOptions;

    private DynamoDBCatalogSource(BuilderImpl builder) {
        this.name = builder.name;
        this.database = builder.database;
        this.table = builder.table;
        this.pitrEnabled = builder.pitrEnabled;
        this.additionalOptions = builder.additionalOptions;
    }

    public final String name() {
        return this.name;
    }

    public final String database() {
        return this.database;
    }

    public final String table() {
        return this.table;
    }

    public final Boolean pitrEnabled() {
        return this.pitrEnabled;
    }

    public final DDBELTCatalogAdditionalOptions additionalOptions() {
        return this.additionalOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.pitrEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBCatalogSource)) {
            return false;
        }
        DynamoDBCatalogSource other = (DynamoDBCatalogSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.pitrEnabled(), other.pitrEnabled()) && Objects.equals(this.additionalOptions(), other.additionalOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DynamoDBCatalogSource").add("Name", (Object)this.name()).add("Database", (Object)this.database()).add("Table", (Object)this.table()).add("PitrEnabled", (Object)this.pitrEnabled()).add("AdditionalOptions", (Object)this.additionalOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "PitrEnabled": {
                return Optional.ofNullable(clazz.cast(this.pitrEnabled()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("PitrEnabled", PITR_ENABLED_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamoDBCatalogSource, T> g) {
        return obj -> g.apply((DynamoDBCatalogSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String database;
        private String table;
        private Boolean pitrEnabled;
        private DDBELTCatalogAdditionalOptions additionalOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBCatalogSource model) {
            this.name(model.name);
            this.database(model.database);
            this.table(model.table);
            this.pitrEnabled(model.pitrEnabled);
            this.additionalOptions(model.additionalOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final Boolean getPitrEnabled() {
            return this.pitrEnabled;
        }

        public final void setPitrEnabled(Boolean pitrEnabled) {
            this.pitrEnabled = pitrEnabled;
        }

        @Override
        public final Builder pitrEnabled(Boolean pitrEnabled) {
            this.pitrEnabled = pitrEnabled;
            return this;
        }

        public final DDBELTCatalogAdditionalOptions.Builder getAdditionalOptions() {
            return this.additionalOptions != null ? this.additionalOptions.toBuilder() : null;
        }

        public final void setAdditionalOptions(DDBELTCatalogAdditionalOptions.BuilderImpl additionalOptions) {
            this.additionalOptions = additionalOptions != null ? additionalOptions.build() : null;
        }

        @Override
        public final Builder additionalOptions(DDBELTCatalogAdditionalOptions additionalOptions) {
            this.additionalOptions = additionalOptions;
            return this;
        }

        public DynamoDBCatalogSource build() {
            return new DynamoDBCatalogSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamoDBCatalogSource> {
        public Builder name(String var1);

        public Builder database(String var1);

        public Builder table(String var1);

        public Builder pitrEnabled(Boolean var1);

        public Builder additionalOptions(DDBELTCatalogAdditionalOptions var1);

        default public Builder additionalOptions(Consumer<DDBELTCatalogAdditionalOptions.Builder> additionalOptions) {
            return this.additionalOptions((DDBELTCatalogAdditionalOptions)((DDBELTCatalogAdditionalOptions.Builder)DDBELTCatalogAdditionalOptions.builder().applyMutation(additionalOptions)).build());
        }
    }
}

