/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A failed annotation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnnotationError implements SdkPojo, Serializable, ToCopyableBuilder<AnnotationError.Builder, AnnotationError> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(AnnotationError::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatisticId").getter(getter(AnnotationError::statisticId)).setter(setter(Builder::statisticId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(AnnotationError::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD,
            STATISTIC_ID_FIELD, FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String profileId;

    private final String statisticId;

    private final String failureReason;

    private AnnotationError(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.statisticId = builder.statisticId;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The Profile ID for the failed annotation.
     * </p>
     * 
     * @return The Profile ID for the failed annotation.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The Statistic ID for the failed annotation.
     * </p>
     * 
     * @return The Statistic ID for the failed annotation.
     */
    public final String statisticId() {
        return statisticId;
    }

    /**
     * <p>
     * The reason why the annotation failed.
     * </p>
     * 
     * @return The reason why the annotation failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationError)) {
            return false;
        }
        AnnotationError other = (AnnotationError) obj;
        return Objects.equals(profileId(), other.profileId()) && Objects.equals(statisticId(), other.statisticId())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnnotationError").add("ProfileId", profileId()).add("StatisticId", statisticId())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "StatisticId":
            return Optional.ofNullable(clazz.cast(statisticId()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("StatisticId", STATISTIC_ID_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnnotationError, T> g) {
        return obj -> g.apply((AnnotationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnnotationError> {
        /**
         * <p>
         * The Profile ID for the failed annotation.
         * </p>
         * 
         * @param profileId
         *        The Profile ID for the failed annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The Statistic ID for the failed annotation.
         * </p>
         * 
         * @param statisticId
         *        The Statistic ID for the failed annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticId(String statisticId);

        /**
         * <p>
         * The reason why the annotation failed.
         * </p>
         * 
         * @param failureReason
         *        The reason why the annotation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String profileId;

        private String statisticId;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationError model) {
            profileId(model.profileId);
            statisticId(model.statisticId);
            failureReason(model.failureReason);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getStatisticId() {
            return statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public AnnotationError build() {
            return new AnnotationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
