/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration options for automatic data quality evaluation in Glue jobs. This structure enables automated
 * data quality checks and monitoring during ETL operations, helping to ensure data integrity and reliability without
 * manual intervention.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoDataQuality implements SdkPojo, Serializable, ToCopyableBuilder<AutoDataQuality.Builder, AutoDataQuality> {
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEnabled").getter(getter(AutoDataQuality::isEnabled)).setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled").build()).build();

    private static final SdkField<String> EVALUATION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationContext").getter(getter(AutoDataQuality::evaluationContext))
            .setter(setter(Builder::evaluationContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ENABLED_FIELD,
            EVALUATION_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isEnabled;

    private final String evaluationContext;

    private AutoDataQuality(BuilderImpl builder) {
        this.isEnabled = builder.isEnabled;
        this.evaluationContext = builder.evaluationContext;
    }

    /**
     * <p>
     * Specifies whether automatic data quality evaluation is enabled. When set to <code>true</code>, data quality
     * checks are performed automatically.
     * </p>
     * 
     * @return Specifies whether automatic data quality evaluation is enabled. When set to <code>true</code>, data
     *         quality checks are performed automatically.
     */
    public final Boolean isEnabled() {
        return isEnabled;
    }

    /**
     * <p>
     * The evaluation context for the automatic data quality checks. This defines the scope and parameters for the data
     * quality evaluation.
     * </p>
     * 
     * @return The evaluation context for the automatic data quality checks. This defines the scope and parameters for
     *         the data quality evaluation.
     */
    public final String evaluationContext() {
        return evaluationContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoDataQuality)) {
            return false;
        }
        AutoDataQuality other = (AutoDataQuality) obj;
        return Objects.equals(isEnabled(), other.isEnabled()) && Objects.equals(evaluationContext(), other.evaluationContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoDataQuality").add("IsEnabled", isEnabled()).add("EvaluationContext", evaluationContext())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        case "EvaluationContext":
            return Optional.ofNullable(clazz.cast(evaluationContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IsEnabled", IS_ENABLED_FIELD);
        map.put("EvaluationContext", EVALUATION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoDataQuality, T> g) {
        return obj -> g.apply((AutoDataQuality) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoDataQuality> {
        /**
         * <p>
         * Specifies whether automatic data quality evaluation is enabled. When set to <code>true</code>, data quality
         * checks are performed automatically.
         * </p>
         * 
         * @param isEnabled
         *        Specifies whether automatic data quality evaluation is enabled. When set to <code>true</code>, data
         *        quality checks are performed automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);

        /**
         * <p>
         * The evaluation context for the automatic data quality checks. This defines the scope and parameters for the
         * data quality evaluation.
         * </p>
         * 
         * @param evaluationContext
         *        The evaluation context for the automatic data quality checks. This defines the scope and parameters
         *        for the data quality evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContext(String evaluationContext);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isEnabled;

        private String evaluationContext;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoDataQuality model) {
            isEnabled(model.isEnabled);
            evaluationContext(model.evaluationContext);
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final String getEvaluationContext() {
            return evaluationContext;
        }

        public final void setEvaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public final Builder evaluationContext(String evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        @Override
        public AutoDataQuality build() {
            return new AutoDataQuality(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
