/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that merges a <code>DynamicFrame</code> with a staging <code>DynamicFrame</code> based on the
 * specified primary keys to identify records. Duplicate records (records with the same primary keys) are not
 * de-duplicated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Merge implements SdkPojo, Serializable, ToCopyableBuilder<Merge.Builder, Merge> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Merge::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(Merge::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(Merge::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<List<String>>> PRIMARY_KEYS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("PrimaryKeys")
            .getter(getter(Merge::primaryKeys))
            .setter(setter(Builder::primaryKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            SOURCE_FIELD, PRIMARY_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String source;

    private final List<List<String>> primaryKeys;

    private Merge(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.source = builder.source;
        this.primaryKeys = builder.primaryKeys;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * The source <code>DynamicFrame</code> that will be merged with a staging <code>DynamicFrame</code>.
     * </p>
     * 
     * @return The source <code>DynamicFrame</code> that will be merged with a staging <code>DynamicFrame</code>.
     */
    public final String source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryKeys() {
        return primaryKeys != null && !(primaryKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of primary key fields to match records from the source and staging dynamic frames.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryKeys} method.
     * </p>
     * 
     * @return The list of primary key fields to match records from the source and staging dynamic frames.
     */
    public final List<List<String>> primaryKeys() {
        return primaryKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryKeys() ? primaryKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Merge)) {
            return false;
        }
        Merge other = (Merge) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(source(), other.source())
                && hasPrimaryKeys() == other.hasPrimaryKeys() && Objects.equals(primaryKeys(), other.primaryKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Merge").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null).add("Source", source())
                .add("PrimaryKeys", hasPrimaryKeys() ? primaryKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "PrimaryKeys":
            return Optional.ofNullable(clazz.cast(primaryKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("PrimaryKeys", PRIMARY_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Merge, T> g) {
        return obj -> g.apply((Merge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Merge> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * The source <code>DynamicFrame</code> that will be merged with a staging <code>DynamicFrame</code>.
         * </p>
         * 
         * @param source
         *        The source <code>DynamicFrame</code> that will be merged with a staging <code>DynamicFrame</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The list of primary key fields to match records from the source and staging dynamic frames.
         * </p>
         * 
         * @param primaryKeys
         *        The list of primary key fields to match records from the source and staging dynamic frames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKeys(Collection<? extends Collection<String>> primaryKeys);

        /**
         * <p>
         * The list of primary key fields to match records from the source and staging dynamic frames.
         * </p>
         * 
         * @param primaryKeys
         *        The list of primary key fields to match records from the source and staging dynamic frames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKeys(Collection<String>... primaryKeys);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String source;

        private List<List<String>> primaryKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Merge model) {
            name(model.name);
            inputs(model.inputs);
            source(model.source);
            primaryKeys(model.primaryKeys);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = TwoInputsCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = TwoInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Collection<? extends Collection<String>> getPrimaryKeys() {
            if (primaryKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return primaryKeys;
        }

        public final void setPrimaryKeys(Collection<? extends Collection<String>> primaryKeys) {
            this.primaryKeys = GlueStudioPathListCopier.copy(primaryKeys);
        }

        @Override
        public final Builder primaryKeys(Collection<? extends Collection<String>> primaryKeys) {
            this.primaryKeys = GlueStudioPathListCopier.copy(primaryKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryKeys(Collection<String>... primaryKeys) {
            primaryKeys(Arrays.asList(primaryKeys));
            return this;
        }

        @Override
        public Merge build() {
            return new Merge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
