/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.IntegrationResourceProperty;
import software.amazon.awssdk.services.glue.model.IntegrationResourcePropertyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIntegrationResourcePropertiesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListIntegrationResourcePropertiesResponse> {
    private static final SdkField<List<IntegrationResourceProperty>> INTEGRATION_RESOURCE_PROPERTY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegrationResourcePropertyList").getter(ListIntegrationResourcePropertiesResponse.getter(ListIntegrationResourcePropertiesResponse::integrationResourcePropertyList)).setter(ListIntegrationResourcePropertiesResponse.setter(Builder::integrationResourcePropertyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationResourcePropertyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegrationResourceProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListIntegrationResourcePropertiesResponse.getter(ListIntegrationResourcePropertiesResponse::marker)).setter(ListIntegrationResourcePropertiesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_RESOURCE_PROPERTY_LIST_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIntegrationResourcePropertiesResponse.memberNameToFieldInitializer();
    private final List<IntegrationResourceProperty> integrationResourcePropertyList;
    private final String marker;

    private ListIntegrationResourcePropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.integrationResourcePropertyList = builder.integrationResourcePropertyList;
        this.marker = builder.marker;
    }

    public final boolean hasIntegrationResourcePropertyList() {
        return this.integrationResourcePropertyList != null && !(this.integrationResourcePropertyList instanceof SdkAutoConstructList);
    }

    public final List<IntegrationResourceProperty> integrationResourcePropertyList() {
        return this.integrationResourcePropertyList;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrationResourcePropertyList() ? this.integrationResourcePropertyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntegrationResourcePropertiesResponse)) {
            return false;
        }
        ListIntegrationResourcePropertiesResponse other = (ListIntegrationResourcePropertiesResponse)((Object)obj);
        return this.hasIntegrationResourcePropertyList() == other.hasIntegrationResourcePropertyList() && Objects.equals(this.integrationResourcePropertyList(), other.integrationResourcePropertyList()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListIntegrationResourcePropertiesResponse").add("IntegrationResourcePropertyList", this.hasIntegrationResourcePropertyList() ? this.integrationResourcePropertyList() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationResourcePropertyList": {
                return Optional.ofNullable(clazz.cast(this.integrationResourcePropertyList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IntegrationResourcePropertyList", INTEGRATION_RESOURCE_PROPERTY_LIST_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIntegrationResourcePropertiesResponse, T> g) {
        return obj -> g.apply((ListIntegrationResourcePropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<IntegrationResourceProperty> integrationResourcePropertyList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntegrationResourcePropertiesResponse model) {
            super(model);
            this.integrationResourcePropertyList(model.integrationResourcePropertyList);
            this.marker(model.marker);
        }

        public final List<IntegrationResourceProperty.Builder> getIntegrationResourcePropertyList() {
            List<IntegrationResourceProperty.Builder> result = IntegrationResourcePropertyListCopier.copyToBuilder(this.integrationResourcePropertyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrationResourcePropertyList(Collection<IntegrationResourceProperty.BuilderImpl> integrationResourcePropertyList) {
            this.integrationResourcePropertyList = IntegrationResourcePropertyListCopier.copyFromBuilder(integrationResourcePropertyList);
        }

        @Override
        public final Builder integrationResourcePropertyList(Collection<IntegrationResourceProperty> integrationResourcePropertyList) {
            this.integrationResourcePropertyList = IntegrationResourcePropertyListCopier.copy(integrationResourcePropertyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationResourcePropertyList(IntegrationResourceProperty ... integrationResourcePropertyList) {
            this.integrationResourcePropertyList(Arrays.asList(integrationResourcePropertyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationResourcePropertyList(Consumer<IntegrationResourceProperty.Builder> ... integrationResourcePropertyList) {
            this.integrationResourcePropertyList(Stream.of(integrationResourcePropertyList).map(c -> (IntegrationResourceProperty)((IntegrationResourceProperty.Builder)IntegrationResourceProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListIntegrationResourcePropertiesResponse build() {
            return new ListIntegrationResourcePropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIntegrationResourcePropertiesResponse> {
        public Builder integrationResourcePropertyList(Collection<IntegrationResourceProperty> var1);

        public Builder integrationResourcePropertyList(IntegrationResourceProperty ... var1);

        public Builder integrationResourcePropertyList(Consumer<IntegrationResourceProperty.Builder> ... var1);

        public Builder marker(String var1);
    }
}

