/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.grafana.model.AccessDeniedException;
import software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest;
import software.amazon.awssdk.services.grafana.model.AssociateLicenseResponse;
import software.amazon.awssdk.services.grafana.model.ConflictException;
import software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse;
import software.amazon.awssdk.services.grafana.model.DisassociateLicenseRequest;
import software.amazon.awssdk.services.grafana.model.DisassociateLicenseResponse;
import software.amazon.awssdk.services.grafana.model.GrafanaException;
import software.amazon.awssdk.services.grafana.model.InternalServerException;
import software.amazon.awssdk.services.grafana.model.ListPermissionsRequest;
import software.amazon.awssdk.services.grafana.model.ListPermissionsResponse;
import software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.grafana.model.ResourceNotFoundException;
import software.amazon.awssdk.services.grafana.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.grafana.model.ThrottlingException;
import software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest;
import software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse;
import software.amazon.awssdk.services.grafana.model.ValidationException;
import software.amazon.awssdk.services.grafana.paginators.ListPermissionsIterable;
import software.amazon.awssdk.services.grafana.paginators.ListWorkspacesIterable;

/**
 * Service client for accessing Amazon Managed Grafana. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Managed Grafana is a fully managed and secure data visualization service that you can use to instantly query,
 * correlate, and visualize operational metrics, logs, and traces from multiple sources. Amazon Managed Grafana makes it
 * easy to deploy, operate, and scale Grafana, a widely deployed data visualization tool that is popular for its
 * extensible data support.
 * </p>
 * <p>
 * With Amazon Managed Grafana, you create logically isolated Grafana servers called <i>workspaces</i>. In a workspace,
 * you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces without having to
 * build, package, or deploy any hardware to run Grafana servers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GrafanaClient extends SdkClient {
    String SERVICE_NAME = "grafana";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "grafana";

    /**
     * Create a {@link GrafanaClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GrafanaClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GrafanaClient}.
     */
    static GrafanaClientBuilder builder() {
        return new DefaultGrafanaClientBuilder();
    }

    /**
     * <p>
     * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html">Upgrade a
     * workspace to Grafana Enterprise</a>.
     * </p>
     *
     * @param associateLicenseRequest
     * @return Result of the AssociateLicense operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.AssociateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/AssociateLicense" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateLicenseResponse associateLicense(AssociateLicenseRequest associateLicenseRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html">Upgrade a
     * workspace to Grafana Enterprise</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLicenseRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateLicenseRequest#builder()}
     * </p>
     *
     * @param associateLicenseRequest
     *        A {@link Consumer} that will call methods on {@link AssociateLicenseRequest.Builder} to create a request.
     * @return Result of the AssociateLicense operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.AssociateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/AssociateLicense" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateLicenseResponse associateLicense(Consumer<AssociateLicenseRequest.Builder> associateLicenseRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return associateLicense(AssociateLicenseRequest.builder().applyMutation(associateLicenseRequest).build());
    }

    /**
     * <p>
     * Creates a <i>workspace</i>. In a workspace, you can create Grafana dashboards and visualizations to analyze your
     * metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
     * </p>
     * <p>
     * Don't use <code>CreateWorkspace</code> to modify an existing workspace. Instead, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html">UpdateWorkspace</a>.
     * </p>
     *
     * @param createWorkspaceRequest
     * @return Result of the CreateWorkspace operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkspaceResponse createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) throws ThrottlingException,
            ConflictException, ValidationException, AccessDeniedException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <i>workspace</i>. In a workspace, you can create Grafana dashboards and visualizations to analyze your
     * metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
     * </p>
     * <p>
     * Don't use <code>CreateWorkspace</code> to modify an existing workspace. Instead, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html">UpdateWorkspace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspaceRequest#builder()}
     * </p>
     *
     * @param createWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkspaceRequest.Builder} to create a request.
     * @return Result of the CreateWorkspace operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkspaceResponse createWorkspace(Consumer<CreateWorkspaceRequest.Builder> createWorkspaceRequest)
            throws ThrottlingException, ConflictException, ValidationException, AccessDeniedException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, GrafanaException {
        return createWorkspace(CreateWorkspaceRequest.builder().applyMutation(createWorkspaceRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Managed Grafana workspace.
     * </p>
     *
     * @param deleteWorkspaceRequest
     * @return Result of the DeleteWorkspace operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkspaceResponse deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest)
            throws ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Managed Grafana workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkspaceRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkspaceRequest.Builder} to create a request.
     * @return Result of the DeleteWorkspace operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkspaceResponse deleteWorkspace(Consumer<DeleteWorkspaceRequest.Builder> deleteWorkspaceRequest)
            throws ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return deleteWorkspace(DeleteWorkspaceRequest.builder().applyMutation(deleteWorkspaceRequest).build());
    }

    /**
     * <p>
     * Displays information about one Amazon Managed Grafana workspace.
     * </p>
     *
     * @param describeWorkspaceRequest
     * @return Result of the DescribeWorkspace operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.DescribeWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeWorkspaceResponse describeWorkspace(DescribeWorkspaceRequest describeWorkspaceRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays information about one Amazon Managed Grafana workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkspaceRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceRequest.Builder} to create a request.
     * @return Result of the DescribeWorkspace operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.DescribeWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeWorkspaceResponse describeWorkspace(Consumer<DescribeWorkspaceRequest.Builder> describeWorkspaceRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return describeWorkspace(DescribeWorkspaceRequest.builder().applyMutation(describeWorkspaceRequest).build());
    }

    /**
     * <p>
     * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
     * </p>
     *
     * @param describeWorkspaceAuthenticationRequest
     * @return Result of the DescribeWorkspaceAuthentication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.DescribeWorkspaceAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceAuthenticationResponse describeWorkspaceAuthentication(
            DescribeWorkspaceAuthenticationRequest describeWorkspaceAuthenticationRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceAuthenticationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceAuthenticationRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceAuthenticationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkspaceAuthenticationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeWorkspaceAuthentication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.DescribeWorkspaceAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkspaceAuthenticationResponse describeWorkspaceAuthentication(
            Consumer<DescribeWorkspaceAuthenticationRequest.Builder> describeWorkspaceAuthenticationRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return describeWorkspaceAuthentication(DescribeWorkspaceAuthenticationRequest.builder()
                .applyMutation(describeWorkspaceAuthenticationRequest).build());
    }

    /**
     * <p>
     * Removes the Grafana Enterprise license from a workspace.
     * </p>
     *
     * @param disassociateLicenseRequest
     * @return Result of the DisassociateLicense operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.DisassociateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DisassociateLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateLicenseResponse disassociateLicense(DisassociateLicenseRequest disassociateLicenseRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the Grafana Enterprise license from a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLicenseRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateLicenseRequest#builder()}
     * </p>
     *
     * @param disassociateLicenseRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateLicenseRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateLicense operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.DisassociateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DisassociateLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateLicenseResponse disassociateLicense(
            Consumer<DisassociateLicenseRequest.Builder> disassociateLicenseRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, GrafanaException {
        return disassociateLicense(DisassociateLicenseRequest.builder().applyMutation(disassociateLicenseRequest).build());
    }

    /**
     * <p>
     * Lists the users and groups who have the Grafana <code>Admin</code> and <code>Editor</code> roles in this
     * workspace. If you use this operation without specifying <code>userId</code> or <code>groupId</code>, the
     * operation returns the roles of all users and groups. If you specify a <code>userId</code> or a
     * <code>groupId</code>, only the roles for that user or group are returned. If you do this, you can specify only
     * one <code>userId</code> or one <code>groupId</code>.
     * </p>
     *
     * @param listPermissionsRequest
     * @return Result of the ListPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users and groups who have the Grafana <code>Admin</code> and <code>Editor</code> roles in this
     * workspace. If you use this operation without specifying <code>userId</code> or <code>groupId</code>, the
     * operation returns the roles of all users and groups. If you specify a <code>userId</code> or a
     * <code>groupId</code>, only the roles for that user or group are returned. If you do this, you can specify only
     * one <code>userId</code> or one <code>groupId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return Result of the ListPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsResponse listPermissions(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return listPermissions(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the users and groups who have the Grafana <code>Admin</code> and <code>Editor</code> roles in this
     * workspace. If you use this operation without specifying <code>userId</code> or <code>groupId</code>, the
     * operation returns the roles of all users and groups. If you specify a <code>userId</code> or a
     * <code>groupId</code>, only the roles for that user or group are returned. If you do this, you can specify only
     * one <code>userId</code> or one <code>groupId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.grafana.model.ListPermissionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.grafana.paginators.ListPermissionsIterable responses = client
     *             .listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.grafana.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.grafana.model.ListPermissionsRequest)} operation.</b>
     * </p>
     *
     * @param listPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users and groups who have the Grafana <code>Admin</code> and <code>Editor</code> roles in this
     * workspace. If you use this operation without specifying <code>userId</code> or <code>groupId</code>, the
     * operation returns the roles of all users and groups. If you specify a <code>userId</code> or a
     * <code>groupId</code>, only the roles for that user or group are returned. If you do this, you can specify only
     * one <code>userId</code> or one <code>groupId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.grafana.model.ListPermissionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.grafana.paginators.ListPermissionsIterable responses = client
     *             .listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.grafana.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.grafana.model.ListPermissionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return listPermissionsPaginator(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace.
     * For more complete information about one workspace, use <a
     * href="https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html">DescribeWorkspace</a>.
     * </p>
     *
     * @param listWorkspacesRequest
     * @return Result of the ListWorkspaces operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkspacesResponse listWorkspaces(ListWorkspacesRequest listWorkspacesRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace.
     * For more complete information about one workspace, use <a
     * href="https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html">DescribeWorkspace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkspacesRequest.Builder} to create a request.
     * @return Result of the ListWorkspaces operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkspacesResponse listWorkspaces(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            GrafanaException {
        return listWorkspaces(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace.
     * For more complete information about one workspace, use <a
     * href="https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html">DescribeWorkspace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkspaces(software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.grafana.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     *
     * @param listWorkspacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkspacesIterable listWorkspacesPaginator(ListWorkspacesRequest listWorkspacesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace.
     * For more complete information about one workspace, use <a
     * href="https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html">DescribeWorkspace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkspaces(software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.grafana.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListWorkspacesIterable responses = client.listWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkspacesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkspacesIterable listWorkspacesPaginator(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            GrafanaException {
        return listWorkspacesPaginator(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * Updates which users in a workspace have the Grafana <code>Admin</code> or <code>Editor</code> roles.
     * </p>
     *
     * @param updatePermissionsRequest
     * @return Result of the UpdatePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.UpdatePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdatePermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePermissionsResponse updatePermissions(UpdatePermissionsRequest updatePermissionsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates which users in a workspace have the Grafana <code>Admin</code> or <code>Editor</code> roles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePermissionsRequest#builder()}
     * </p>
     *
     * @param updatePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePermissionsRequest.Builder} to create a request.
     * @return Result of the UpdatePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.UpdatePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdatePermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePermissionsResponse updatePermissions(Consumer<UpdatePermissionsRequest.Builder> updatePermissionsRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return updatePermissions(UpdatePermissionsRequest.builder().applyMutation(updatePermissionsRequest).build());
    }

    /**
     * <p>
     * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional
     * parameters, the existing values of those parameters are not changed.
     * </p>
     * <p>
     * To modify the user authentication methods that the workspace uses, such as SAML or Amazon Web Services SSO, use
     * <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html">
     * UpdateWorkspaceAuthentication</a>.
     * </p>
     * <p>
     * To modify which users in the workspace have the <code>Admin</code> and <code>Editor</code> Grafana roles, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a>.
     * </p>
     *
     * @param updateWorkspaceRequest
     * @return Result of the UpdateWorkspace operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWorkspaceResponse updateWorkspace(UpdateWorkspaceRequest updateWorkspaceRequest)
            throws ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional
     * parameters, the existing values of those parameters are not changed.
     * </p>
     * <p>
     * To modify the user authentication methods that the workspace uses, such as SAML or Amazon Web Services SSO, use
     * <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html">
     * UpdateWorkspaceAuthentication</a>.
     * </p>
     * <p>
     * To modify which users in the workspace have the <code>Admin</code> and <code>Editor</code> Grafana roles, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkspaceRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkspaceRequest.Builder} to create a request.
     * @return Result of the UpdateWorkspace operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWorkspaceResponse updateWorkspace(Consumer<UpdateWorkspaceRequest.Builder> updateWorkspaceRequest)
            throws ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return updateWorkspace(UpdateWorkspaceRequest.builder().applyMutation(updateWorkspaceRequest).build());
    }

    /**
     * <p>
     * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using
     * SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the
     * assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
     * </p>
     *
     * @param updateWorkspaceAuthenticationRequest
     * @return Result of the UpdateWorkspaceAuthentication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.UpdateWorkspaceAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkspaceAuthenticationResponse updateWorkspaceAuthentication(
            UpdateWorkspaceAuthenticationRequest updateWorkspaceAuthenticationRequest) throws ResourceNotFoundException,
            ThrottlingException, ConflictException, ValidationException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, GrafanaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using
     * SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the
     * assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceAuthenticationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateWorkspaceAuthenticationRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceAuthenticationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkspaceAuthenticationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateWorkspaceAuthentication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ThrottlingException
     *         The request was denied because of request throttling. Retry the request.
     * @throws ConflictException
     *         A resource was in an inconsistent state during an update or a deletion.
     * @throws ValidationException
     *         The value of a parameter in the request caused an error.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServerException
     *         Unexpected error while processing the request. Retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GrafanaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GrafanaClient.UpdateWorkspaceAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkspaceAuthenticationResponse updateWorkspaceAuthentication(
            Consumer<UpdateWorkspaceAuthenticationRequest.Builder> updateWorkspaceAuthenticationRequest)
            throws ResourceNotFoundException, ThrottlingException, ConflictException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, GrafanaException {
        return updateWorkspaceAuthentication(UpdateWorkspaceAuthenticationRequest.builder()
                .applyMutation(updateWorkspaceAuthenticationRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
