/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user
 * authentication, and whether that authentication is fully configured.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationSummary.Builder, AuthenticationSummary> {
    private static final SdkField<List<String>> PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("providers")
            .getter(getter(AuthenticationSummary::providersAsStrings))
            .setter(setter(Builder::providersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SAML_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("samlConfigurationStatus").getter(getter(AuthenticationSummary::samlConfigurationStatusAsString))
            .setter(setter(Builder::samlConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlConfigurationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDERS_FIELD,
            SAML_CONFIGURATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> providers;

    private final String samlConfigurationStatus;

    private AuthenticationSummary(BuilderImpl builder) {
        this.providers = builder.providers;
        this.samlConfigurationStatus = builder.samlConfigurationStatus;
    }

    /**
     * <p>
     * Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviders} method.
     * </p>
     * 
     * @return Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user
     *         authentication.
     */
    public final List<AuthenticationProviderTypes> providers() {
        return AuthenticationProvidersCopier.copyStringToEnum(providers);
    }

    /**
     * For responses, this returns true if the service returned a value for the Providers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProviders() {
        return providers != null && !(providers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviders} method.
     * </p>
     * 
     * @return Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user
     *         authentication.
     */
    public final List<String> providersAsStrings() {
        return providers;
    }

    /**
     * <p>
     * Specifies whether the workplace's user authentication method is fully configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samlConfigurationStatus} will return {@link SamlConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #samlConfigurationStatusAsString}.
     * </p>
     * 
     * @return Specifies whether the workplace's user authentication method is fully configured.
     * @see SamlConfigurationStatus
     */
    public final SamlConfigurationStatus samlConfigurationStatus() {
        return SamlConfigurationStatus.fromValue(samlConfigurationStatus);
    }

    /**
     * <p>
     * Specifies whether the workplace's user authentication method is fully configured.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samlConfigurationStatus} will return {@link SamlConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #samlConfigurationStatusAsString}.
     * </p>
     * 
     * @return Specifies whether the workplace's user authentication method is fully configured.
     * @see SamlConfigurationStatus
     */
    public final String samlConfigurationStatusAsString() {
        return samlConfigurationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProviders() ? providersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(samlConfigurationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationSummary)) {
            return false;
        }
        AuthenticationSummary other = (AuthenticationSummary) obj;
        return hasProviders() == other.hasProviders() && Objects.equals(providersAsStrings(), other.providersAsStrings())
                && Objects.equals(samlConfigurationStatusAsString(), other.samlConfigurationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationSummary").add("Providers", hasProviders() ? providersAsStrings() : null)
                .add("SamlConfigurationStatus", samlConfigurationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "providers":
            return Optional.ofNullable(clazz.cast(providersAsStrings()));
        case "samlConfigurationStatus":
            return Optional.ofNullable(clazz.cast(samlConfigurationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationSummary, T> g) {
        return obj -> g.apply((AuthenticationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationSummary> {
        /**
         * <p>
         * Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.
         * </p>
         * 
         * @param providers
         *        Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providersWithStrings(Collection<String> providers);

        /**
         * <p>
         * Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.
         * </p>
         * 
         * @param providers
         *        Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providersWithStrings(String... providers);

        /**
         * <p>
         * Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.
         * </p>
         * 
         * @param providers
         *        Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providers(Collection<AuthenticationProviderTypes> providers);

        /**
         * <p>
         * Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.
         * </p>
         * 
         * @param providers
         *        Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providers(AuthenticationProviderTypes... providers);

        /**
         * <p>
         * Specifies whether the workplace's user authentication method is fully configured.
         * </p>
         * 
         * @param samlConfigurationStatus
         *        Specifies whether the workplace's user authentication method is fully configured.
         * @see SamlConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SamlConfigurationStatus
         */
        Builder samlConfigurationStatus(String samlConfigurationStatus);

        /**
         * <p>
         * Specifies whether the workplace's user authentication method is fully configured.
         * </p>
         * 
         * @param samlConfigurationStatus
         *        Specifies whether the workplace's user authentication method is fully configured.
         * @see SamlConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SamlConfigurationStatus
         */
        Builder samlConfigurationStatus(SamlConfigurationStatus samlConfigurationStatus);
    }

    static final class BuilderImpl implements Builder {
        private List<String> providers = DefaultSdkAutoConstructList.getInstance();

        private String samlConfigurationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationSummary model) {
            providersWithStrings(model.providers);
            samlConfigurationStatus(model.samlConfigurationStatus);
        }

        public final Collection<String> getProviders() {
            if (providers instanceof SdkAutoConstructList) {
                return null;
            }
            return providers;
        }

        public final void setProviders(Collection<String> providers) {
            this.providers = AuthenticationProvidersCopier.copy(providers);
        }

        @Override
        @Transient
        public final Builder providersWithStrings(Collection<String> providers) {
            this.providers = AuthenticationProvidersCopier.copy(providers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder providersWithStrings(String... providers) {
            providersWithStrings(Arrays.asList(providers));
            return this;
        }

        @Override
        @Transient
        public final Builder providers(Collection<AuthenticationProviderTypes> providers) {
            this.providers = AuthenticationProvidersCopier.copyEnumToString(providers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder providers(AuthenticationProviderTypes... providers) {
            providers(Arrays.asList(providers));
            return this;
        }

        public final String getSamlConfigurationStatus() {
            return samlConfigurationStatus;
        }

        public final void setSamlConfigurationStatus(String samlConfigurationStatus) {
            this.samlConfigurationStatus = samlConfigurationStatus;
        }

        @Override
        @Transient
        public final Builder samlConfigurationStatus(String samlConfigurationStatus) {
            this.samlConfigurationStatus = samlConfigurationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder samlConfigurationStatus(SamlConfigurationStatus samlConfigurationStatus) {
            this.samlConfigurationStatus(samlConfigurationStatus == null ? null : samlConfigurationStatus.toString());
            return this;
        }

        @Override
        public AuthenticationSummary build() {
            return new AuthenticationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
