/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionsRequest extends GrafanaRequest implements
        ToCopyableBuilder<ListPermissionsRequest.Builder, ListPermissionsRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupId").getter(getter(ListPermissionsRequest::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("groupId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListPermissionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPermissionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(ListPermissionsRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()).build();

    private static final SdkField<String> USER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userType").getter(getter(ListPermissionsRequest::userTypeAsString)).setter(setter(Builder::userType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userType").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(ListPermissionsRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, USER_ID_FIELD, USER_TYPE_FIELD, WORKSPACE_ID_FIELD));

    private final String groupId;

    private final Integer maxResults;

    private final String nextToken;

    private final String userId;

    private final String userType;

    private final String workspaceId;

    private ListPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.userId = builder.userId;
        this.userType = builder.userType;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * (Optional) Limits the results to only the group that matches this ID.
     * </p>
     * 
     * @return (Optional) Limits the results to only the group that matches this ID.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The maximum number of results to include in the response.
     * </p>
     * 
     * @return The maximum number of results to include in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use when requesting the next set of results. You received this token from a previous
     * <code>ListPermissions</code> operation.
     * </p>
     * 
     * @return The token to use when requesting the next set of results. You received this token from a previous
     *         <code>ListPermissions</code> operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * (Optional) Limits the results to only the user that matches this ID.
     * </p>
     * 
     * @return (Optional) Limits the results to only the user that matches this ID.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * (Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users are
     * returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups are
     * returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userTypeAsString}.
     * </p>
     * 
     * @return (Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO
     *         users are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services
     *         SSO groups are returned.
     * @see UserType
     */
    public final UserType userType() {
        return UserType.fromValue(userType);
    }

    /**
     * <p>
     * (Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users are
     * returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups are
     * returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userTypeAsString}.
     * </p>
     * 
     * @return (Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO
     *         users are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services
     *         SSO groups are returned.
     * @see UserType
     */
    public final String userTypeAsString() {
        return userType;
    }

    /**
     * <p>
     * The ID of the workspace to list permissions for. This parameter is required.
     * </p>
     * 
     * @return The ID of the workspace to list permissions for. This parameter is required.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionsRequest)) {
            return false;
        }
        ListPermissionsRequest other = (ListPermissionsRequest) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(userId(), other.userId())
                && Objects.equals(userTypeAsString(), other.userTypeAsString())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPermissionsRequest").add("GroupId", groupId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("UserId", userId()).add("UserType", userTypeAsString())
                .add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "userType":
            return Optional.ofNullable(clazz.cast(userTypeAsString()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionsRequest, T> g) {
        return obj -> g.apply((ListPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPermissionsRequest> {
        /**
         * <p>
         * (Optional) Limits the results to only the group that matches this ID.
         * </p>
         * 
         * @param groupId
         *        (Optional) Limits the results to only the group that matches this ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The maximum number of results to include in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use when requesting the next set of results. You received this token from a previous
         * <code>ListPermissions</code> operation.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of results. You received this token from a previous
         *        <code>ListPermissions</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * (Optional) Limits the results to only the user that matches this ID.
         * </p>
         * 
         * @param userId
         *        (Optional) Limits the results to only the user that matches this ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * (Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users
         * are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups
         * are returned.
         * </p>
         * 
         * @param userType
         *        (Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO
         *        users are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services
         *        SSO groups are returned.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder userType(String userType);

        /**
         * <p>
         * (Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users
         * are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups
         * are returned.
         * </p>
         * 
         * @param userType
         *        (Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO
         *        users are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services
         *        SSO groups are returned.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder userType(UserType userType);

        /**
         * <p>
         * The ID of the workspace to list permissions for. This parameter is required.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace to list permissions for. This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private String groupId;

        private Integer maxResults;

        private String nextToken;

        private String userId;

        private String userType;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionsRequest model) {
            super(model);
            groupId(model.groupId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            userId(model.userId);
            userType(model.userType);
            workspaceId(model.workspaceId);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        @Transient
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserType() {
            return userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        @Transient
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        @Transient
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        @Transient
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPermissionsRequest build() {
            return new ListPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
