/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines which groups defined in the SAML assertion attribute are to be mapped to the Grafana
 * <code>Admin</code> and <code>Editor</code> roles in the workspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoleValues implements SdkPojo, Serializable, ToCopyableBuilder<RoleValues.Builder, RoleValues> {
    private static final SdkField<List<String>> ADMIN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("admin")
            .getter(getter(RoleValues::admin))
            .setter(setter(Builder::admin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("admin").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EDITOR_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("editor")
            .getter(getter(RoleValues::editor))
            .setter(setter(Builder::editor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("editor").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_FIELD, EDITOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> admin;

    private final List<String> editor;

    private RoleValues(BuilderImpl builder) {
        this.admin = builder.admin;
        this.editor = builder.editor;
    }

    /**
     * For responses, this returns true if the service returned a value for the Admin property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAdmin() {
        return admin != null && !(admin instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdmin} method.
     * </p>
     * 
     * @return A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.
     */
    public final List<String> admin() {
        return admin;
    }

    /**
     * For responses, this returns true if the service returned a value for the Editor property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEditor() {
        return editor != null && !(editor instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEditor} method.
     * </p>
     * 
     * @return A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.
     */
    public final List<String> editor() {
        return editor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdmin() ? admin() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEditor() ? editor() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleValues)) {
            return false;
        }
        RoleValues other = (RoleValues) obj;
        return hasAdmin() == other.hasAdmin() && Objects.equals(admin(), other.admin()) && hasEditor() == other.hasEditor()
                && Objects.equals(editor(), other.editor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoleValues").add("Admin", hasAdmin() ? admin() : null)
                .add("Editor", hasEditor() ? editor() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "admin":
            return Optional.ofNullable(clazz.cast(admin()));
        case "editor":
            return Optional.ofNullable(clazz.cast(editor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoleValues, T> g) {
        return obj -> g.apply((RoleValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoleValues> {
        /**
         * <p>
         * A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.
         * </p>
         * 
         * @param admin
         *        A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder admin(Collection<String> admin);

        /**
         * <p>
         * A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.
         * </p>
         * 
         * @param admin
         *        A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder admin(String... admin);

        /**
         * <p>
         * A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.
         * </p>
         * 
         * @param editor
         *        A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder editor(Collection<String> editor);

        /**
         * <p>
         * A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.
         * </p>
         * 
         * @param editor
         *        A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder editor(String... editor);
    }

    static final class BuilderImpl implements Builder {
        private List<String> admin = DefaultSdkAutoConstructList.getInstance();

        private List<String> editor = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoleValues model) {
            admin(model.admin);
            editor(model.editor);
        }

        public final Collection<String> getAdmin() {
            if (admin instanceof SdkAutoConstructList) {
                return null;
            }
            return admin;
        }

        public final void setAdmin(Collection<String> admin) {
            this.admin = RoleValueListCopier.copy(admin);
        }

        @Override
        @Transient
        public final Builder admin(Collection<String> admin) {
            this.admin = RoleValueListCopier.copy(admin);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder admin(String... admin) {
            admin(Arrays.asList(admin));
            return this;
        }

        public final Collection<String> getEditor() {
            if (editor instanceof SdkAutoConstructList) {
                return null;
            }
            return editor;
        }

        public final void setEditor(Collection<String> editor) {
            this.editor = RoleValueListCopier.copy(editor);
        }

        @Override
        @Transient
        public final Builder editor(Collection<String> editor) {
            this.editor = RoleValueListCopier.copy(editor);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder editor(String... editor) {
            editor(Arrays.asList(editor));
            return this;
        }

        @Override
        public RoleValues build() {
            return new RoleValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
