/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspaceRequest extends GrafanaRequest implements
        ToCopyableBuilder<UpdateWorkspaceRequest.Builder, UpdateWorkspaceRequest> {
    private static final SdkField<String> ACCOUNT_ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountAccessType").getter(getter(UpdateWorkspaceRequest::accountAccessTypeAsString))
            .setter(setter(Builder::accountAccessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAccessType").build()).build();

    private static final SdkField<String> ORGANIZATION_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationRoleName").getter(getter(UpdateWorkspaceRequest::organizationRoleName))
            .setter(setter(Builder::organizationRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRoleName").build())
            .build();

    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionType").getter(getter(UpdateWorkspaceRequest::permissionTypeAsString))
            .setter(setter(Builder::permissionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionType").build()).build();

    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackSetName").getter(getter(UpdateWorkspaceRequest::stackSetName))
            .setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackSetName").build()).build();

    private static final SdkField<List<String>> WORKSPACE_DATA_SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("workspaceDataSources")
            .getter(getter(UpdateWorkspaceRequest::workspaceDataSourcesAsStrings))
            .setter(setter(Builder::workspaceDataSourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceDataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceDescription").getter(getter(UpdateWorkspaceRequest::workspaceDescription))
            .setter(setter(Builder::workspaceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceDescription").build())
            .build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdateWorkspaceRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<String> WORKSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceName").getter(getter(UpdateWorkspaceRequest::workspaceName))
            .setter(setter(Builder::workspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceName").build()).build();

    private static final SdkField<List<String>> WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("workspaceNotificationDestinations")
            .getter(getter(UpdateWorkspaceRequest::workspaceNotificationDestinationsAsStrings))
            .setter(setter(Builder::workspaceNotificationDestinationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceNotificationDestinations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WORKSPACE_ORGANIZATIONAL_UNITS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("workspaceOrganizationalUnits")
            .getter(getter(UpdateWorkspaceRequest::workspaceOrganizationalUnits))
            .setter(setter(Builder::workspaceOrganizationalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceOrganizationalUnits")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceRoleArn").getter(getter(UpdateWorkspaceRequest::workspaceRoleArn))
            .setter(setter(Builder::workspaceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ACCESS_TYPE_FIELD,
            ORGANIZATION_ROLE_NAME_FIELD, PERMISSION_TYPE_FIELD, STACK_SET_NAME_FIELD, WORKSPACE_DATA_SOURCES_FIELD,
            WORKSPACE_DESCRIPTION_FIELD, WORKSPACE_ID_FIELD, WORKSPACE_NAME_FIELD, WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD,
            WORKSPACE_ORGANIZATIONAL_UNITS_FIELD, WORKSPACE_ROLE_ARN_FIELD));

    private final String accountAccessType;

    private final String organizationRoleName;

    private final String permissionType;

    private final String stackSetName;

    private final List<String> workspaceDataSources;

    private final String workspaceDescription;

    private final String workspaceId;

    private final String workspaceName;

    private final List<String> workspaceNotificationDestinations;

    private final List<String> workspaceOrganizationalUnits;

    private final String workspaceRoleArn;

    private UpdateWorkspaceRequest(BuilderImpl builder) {
        super(builder);
        this.accountAccessType = builder.accountAccessType;
        this.organizationRoleName = builder.organizationRoleName;
        this.permissionType = builder.permissionType;
        this.stackSetName = builder.stackSetName;
        this.workspaceDataSources = builder.workspaceDataSources;
        this.workspaceDescription = builder.workspaceDescription;
        this.workspaceId = builder.workspaceId;
        this.workspaceName = builder.workspaceName;
        this.workspaceNotificationDestinations = builder.workspaceNotificationDestinations;
        this.workspaceOrganizationalUnits = builder.workspaceOrganizationalUnits;
        this.workspaceRoleArn = builder.workspaceRoleArn;
    }

    /**
     * <p>
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account
     * only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If
     * you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in
     * the <code>workspaceOrganizationalUnits</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountAccessType}
     * will return {@link AccountAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services
     *         account only, or whether it can also access Amazon Web Services resources in other accounts in the same
     *         organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the
     *         workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.
     * @see AccountAccessType
     */
    public final AccountAccessType accountAccessType() {
        return AccountAccessType.fromValue(accountAccessType);
    }

    /**
     * <p>
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account
     * only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If
     * you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in
     * the <code>workspaceOrganizationalUnits</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountAccessType}
     * will return {@link AccountAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services
     *         account only, or whether it can also access Amazon Web Services resources in other accounts in the same
     *         organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the
     *         workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.
     * @see AccountAccessType
     */
    public final String accountAccessTypeAsString() {
        return accountAccessType;
    }

    /**
     * <p>
     * The name of an IAM role that already exists to use to access resources through Organizations.
     * </p>
     * 
     * @return The name of an IAM role that already exists to use to access resources through Organizations.
     */
    public final String organizationRoleName() {
        return organizationRoleName;
    }

    /**
     * <p>
     * If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and
     * provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification
     * channels.
     * </p>
     * <p>
     * If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you are
     * creating this workspace in a member account of an organization and that account is not a delegated administrator
     * account, and you want the workspace to access data sources in other Amazon Web Services accounts in the
     * organization, you must choose <code>CUSTOMER_MANAGED</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana
     * permissions and policies for Amazon Web Services data sources and notification channels</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles
     *         and provisions the permissions that the workspace needs to use Amazon Web Services data sources and
     *         notification channels.</p>
     *         <p>
     *         If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If
     *         you are creating this workspace in a member account of an organization and that account is not a
     *         delegated administrator account, and you want the workspace to access data sources in other Amazon Web
     *         Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
     *         Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>
     * @see PermissionType
     */
    public final PermissionType permissionType() {
        return PermissionType.fromValue(permissionType);
    }

    /**
     * <p>
     * If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and
     * provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification
     * channels.
     * </p>
     * <p>
     * If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you are
     * creating this workspace in a member account of an organization and that account is not a delegated administrator
     * account, and you want the workspace to access data sources in other Amazon Web Services accounts in the
     * organization, you must choose <code>CUSTOMER_MANAGED</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana
     * permissions and policies for Amazon Web Services data sources and notification channels</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles
     *         and provisions the permissions that the workspace needs to use Amazon Web Services data sources and
     *         notification channels.</p>
     *         <p>
     *         If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If
     *         you are creating this workspace in a member account of an organization and that account is not a
     *         delegated administrator account, and you want the workspace to access data sources in other Amazon Web
     *         Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
     *         Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>
     * @see PermissionType
     */
    public final String permissionTypeAsString() {
        return permissionType;
    }

    /**
     * <p>
     * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
     * </p>
     * 
     * @return The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
     */
    public final String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data
     * sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana
     * to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.
     * </p>
     * <p>
     * If you don't specify a data source here, you can still add it as a data source later in the workspace console.
     * However, you will then have to manually configure permissions for it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceDataSources} method.
     * </p>
     * 
     * @return Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying
     *         these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
     *         Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the
     *         Grafana console in the workspace.</p>
     *         <p>
     *         If you don't specify a data source here, you can still add it as a data source later in the workspace
     *         console. However, you will then have to manually configure permissions for it.
     */
    public final List<DataSourceType> workspaceDataSources() {
        return DataSourceTypesListCopier.copyStringToEnum(workspaceDataSources);
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceDataSources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkspaceDataSources() {
        return workspaceDataSources != null && !(workspaceDataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data
     * sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana
     * to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.
     * </p>
     * <p>
     * If you don't specify a data source here, you can still add it as a data source later in the workspace console.
     * However, you will then have to manually configure permissions for it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceDataSources} method.
     * </p>
     * 
     * @return Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying
     *         these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
     *         Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the
     *         Grafana console in the workspace.</p>
     *         <p>
     *         If you don't specify a data source here, you can still add it as a data source later in the workspace
     *         console. However, you will then have to manually configure permissions for it.
     */
    public final List<String> workspaceDataSourcesAsStrings() {
        return workspaceDataSources;
    }

    /**
     * <p>
     * A description for the workspace. This is used only to help you identify this workspace.
     * </p>
     * 
     * @return A description for the workspace. This is used only to help you identify this workspace.
     */
    public final String workspaceDescription() {
        return workspaceDescription;
    }

    /**
     * <p>
     * The ID of the workspace to update.
     * </p>
     * 
     * @return The ID of the workspace to update.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * A new name for the workspace to update.
     * </p>
     * 
     * @return A new name for the workspace to update.
     */
    public final String workspaceName() {
        return workspaceName;
    }

    /**
     * <p>
     * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
     * data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed
     * Grafana to use these channels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceNotificationDestinations}
     * method.
     * </p>
     * 
     * @return Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
     *         these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
     *         Amazon Managed Grafana to use these channels.
     */
    public final List<NotificationDestinationType> workspaceNotificationDestinations() {
        return NotificationDestinationsListCopier.copyStringToEnum(workspaceNotificationDestinations);
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceNotificationDestinations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasWorkspaceNotificationDestinations() {
        return workspaceNotificationDestinations != null && !(workspaceNotificationDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
     * data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed
     * Grafana to use these channels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceNotificationDestinations}
     * method.
     * </p>
     * 
     * @return Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
     *         these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
     *         Amazon Managed Grafana to use these channels.
     */
    public final List<String> workspaceNotificationDestinationsAsStrings() {
        return workspaceNotificationDestinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceOrganizationalUnits property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkspaceOrganizationalUnits() {
        return workspaceOrganizationalUnits != null && !(workspaceOrganizationalUnits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is
     * in an account that is part of an organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceOrganizationalUnits} method.
     * </p>
     * 
     * @return Specifies the organizational units that this workspace is allowed to use data sources from, if this
     *         workspace is in an account that is part of an organization.
     */
    public final List<String> workspaceOrganizationalUnits() {
        return workspaceOrganizationalUnits;
    }

    /**
     * <p>
     * The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace
     * will view data from. If you already have a role that you want to use, specify it here. If you omit this field and
     * you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
     * <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is automatically
     * created.
     * </p>
     * 
     * @return The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
     *         workspace will view data from. If you already have a role that you want to use, specify it here. If you
     *         omit this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code>
     *         or <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
     *         automatically created.
     */
    public final String workspaceRoleArn() {
        return workspaceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(organizationRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceDataSources() ? workspaceDataSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasWorkspaceNotificationDestinations() ? workspaceNotificationDestinationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceOrganizationalUnits() ? workspaceOrganizationalUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceRequest)) {
            return false;
        }
        UpdateWorkspaceRequest other = (UpdateWorkspaceRequest) obj;
        return Objects.equals(accountAccessTypeAsString(), other.accountAccessTypeAsString())
                && Objects.equals(organizationRoleName(), other.organizationRoleName())
                && Objects.equals(permissionTypeAsString(), other.permissionTypeAsString())
                && Objects.equals(stackSetName(), other.stackSetName())
                && hasWorkspaceDataSources() == other.hasWorkspaceDataSources()
                && Objects.equals(workspaceDataSourcesAsStrings(), other.workspaceDataSourcesAsStrings())
                && Objects.equals(workspaceDescription(), other.workspaceDescription())
                && Objects.equals(workspaceId(), other.workspaceId())
                && Objects.equals(workspaceName(), other.workspaceName())
                && hasWorkspaceNotificationDestinations() == other.hasWorkspaceNotificationDestinations()
                && Objects.equals(workspaceNotificationDestinationsAsStrings(),
                        other.workspaceNotificationDestinationsAsStrings())
                && hasWorkspaceOrganizationalUnits() == other.hasWorkspaceOrganizationalUnits()
                && Objects.equals(workspaceOrganizationalUnits(), other.workspaceOrganizationalUnits())
                && Objects.equals(workspaceRoleArn(), other.workspaceRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateWorkspaceRequest")
                .add("AccountAccessType", accountAccessTypeAsString())
                .add("OrganizationRoleName", organizationRoleName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PermissionType", permissionTypeAsString())
                .add("StackSetName", stackSetName())
                .add("WorkspaceDataSources", hasWorkspaceDataSources() ? workspaceDataSourcesAsStrings() : null)
                .add("WorkspaceDescription", workspaceDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WorkspaceId", workspaceId())
                .add("WorkspaceName", workspaceName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WorkspaceNotificationDestinations",
                        hasWorkspaceNotificationDestinations() ? workspaceNotificationDestinationsAsStrings() : null)
                .add("WorkspaceOrganizationalUnits",
                        workspaceOrganizationalUnits() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WorkspaceRoleArn", workspaceRoleArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountAccessType":
            return Optional.ofNullable(clazz.cast(accountAccessTypeAsString()));
        case "organizationRoleName":
            return Optional.ofNullable(clazz.cast(organizationRoleName()));
        case "permissionType":
            return Optional.ofNullable(clazz.cast(permissionTypeAsString()));
        case "stackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "workspaceDataSources":
            return Optional.ofNullable(clazz.cast(workspaceDataSourcesAsStrings()));
        case "workspaceDescription":
            return Optional.ofNullable(clazz.cast(workspaceDescription()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "workspaceName":
            return Optional.ofNullable(clazz.cast(workspaceName()));
        case "workspaceNotificationDestinations":
            return Optional.ofNullable(clazz.cast(workspaceNotificationDestinationsAsStrings()));
        case "workspaceOrganizationalUnits":
            return Optional.ofNullable(clazz.cast(workspaceOrganizationalUnits()));
        case "workspaceRoleArn":
            return Optional.ofNullable(clazz.cast(workspaceRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkspaceRequest> {
        /**
         * <p>
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account
         * only, or whether it can also access Amazon Web Services resources in other accounts in the same organization.
         * If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can
         * access in the <code>workspaceOrganizationalUnits</code> parameter.
         * </p>
         * 
         * @param accountAccessType
         *        Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services
         *        account only, or whether it can also access Amazon Web Services resources in other accounts in the
         *        same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational
         *        units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.
         * @see AccountAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountAccessType
         */
        Builder accountAccessType(String accountAccessType);

        /**
         * <p>
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account
         * only, or whether it can also access Amazon Web Services resources in other accounts in the same organization.
         * If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can
         * access in the <code>workspaceOrganizationalUnits</code> parameter.
         * </p>
         * 
         * @param accountAccessType
         *        Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services
         *        account only, or whether it can also access Amazon Web Services resources in other accounts in the
         *        same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational
         *        units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.
         * @see AccountAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountAccessType
         */
        Builder accountAccessType(AccountAccessType accountAccessType);

        /**
         * <p>
         * The name of an IAM role that already exists to use to access resources through Organizations.
         * </p>
         * 
         * @param organizationRoleName
         *        The name of an IAM role that already exists to use to access resources through Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationRoleName(String organizationRoleName);

        /**
         * <p>
         * If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and
         * provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification
         * channels.
         * </p>
         * <p>
         * If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you
         * are creating this workspace in a member account of an organization and that account is not a delegated
         * administrator account, and you want the workspace to access data sources in other Amazon Web Services
         * accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
         * Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>
         * </p>
         * 
         * @param permissionType
         *        If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM
         *        roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources
         *        and notification channels.</p>
         *        <p>
         *        If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If
         *        you are creating this workspace in a member account of an organization and that account is not a
         *        delegated administrator account, and you want the workspace to access data sources in other Amazon Web
         *        Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
         *        Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * <p>
         * If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and
         * provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification
         * channels.
         * </p>
         * <p>
         * If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you
         * are creating this workspace in a member account of an organization and that account is not a delegated
         * administrator account, and you want the workspace to access data sources in other Amazon Web Services
         * accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
         * Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>
         * </p>
         * 
         * @param permissionType
         *        If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM
         *        roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources
         *        and notification channels.</p>
         *        <p>
         *        If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If
         *        you are creating this workspace in a member account of an organization and that account is not a
         *        delegated administrator account, and you want the workspace to access data sources in other Amazon Web
         *        Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
         *        Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(PermissionType permissionType);

        /**
         * <p>
         * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
         * </p>
         * 
         * @param stackSetName
         *        The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these
         * data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana
         * console in the workspace.
         * </p>
         * <p>
         * If you don't specify a data source here, you can still add it as a data source later in the workspace
         * console. However, you will then have to manually configure permissions for it.
         * </p>
         * 
         * @param workspaceDataSources
         *        Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying
         *        these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
         *        Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the
         *        Grafana console in the workspace.</p>
         *        <p>
         *        If you don't specify a data source here, you can still add it as a data source later in the workspace
         *        console. However, you will then have to manually configure permissions for it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDataSourcesWithStrings(Collection<String> workspaceDataSources);

        /**
         * <p>
         * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these
         * data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana
         * console in the workspace.
         * </p>
         * <p>
         * If you don't specify a data source here, you can still add it as a data source later in the workspace
         * console. However, you will then have to manually configure permissions for it.
         * </p>
         * 
         * @param workspaceDataSources
         *        Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying
         *        these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
         *        Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the
         *        Grafana console in the workspace.</p>
         *        <p>
         *        If you don't specify a data source here, you can still add it as a data source later in the workspace
         *        console. However, you will then have to manually configure permissions for it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDataSourcesWithStrings(String... workspaceDataSources);

        /**
         * <p>
         * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these
         * data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana
         * console in the workspace.
         * </p>
         * <p>
         * If you don't specify a data source here, you can still add it as a data source later in the workspace
         * console. However, you will then have to manually configure permissions for it.
         * </p>
         * 
         * @param workspaceDataSources
         *        Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying
         *        these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
         *        Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the
         *        Grafana console in the workspace.</p>
         *        <p>
         *        If you don't specify a data source here, you can still add it as a data source later in the workspace
         *        console. However, you will then have to manually configure permissions for it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDataSources(Collection<DataSourceType> workspaceDataSources);

        /**
         * <p>
         * Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these
         * data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana
         * console in the workspace.
         * </p>
         * <p>
         * If you don't specify a data source here, you can still add it as a data source later in the workspace
         * console. However, you will then have to manually configure permissions for it.
         * </p>
         * 
         * @param workspaceDataSources
         *        Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying
         *        these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
         *        Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the
         *        Grafana console in the workspace.</p>
         *        <p>
         *        If you don't specify a data source here, you can still add it as a data source later in the workspace
         *        console. However, you will then have to manually configure permissions for it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDataSources(DataSourceType... workspaceDataSources);

        /**
         * <p>
         * A description for the workspace. This is used only to help you identify this workspace.
         * </p>
         * 
         * @param workspaceDescription
         *        A description for the workspace. This is used only to help you identify this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDescription(String workspaceDescription);

        /**
         * <p>
         * The ID of the workspace to update.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * A new name for the workspace to update.
         * </p>
         * 
         * @param workspaceName
         *        A new name for the workspace to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceName(String workspaceName);

        /**
         * <p>
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
         * these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to use these channels.
         * </p>
         * 
         * @param workspaceNotificationDestinations
         *        Specify the Amazon Web Services notification channels that you plan to use in this workspace.
         *        Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions
         *        that allow Amazon Managed Grafana to use these channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceNotificationDestinationsWithStrings(Collection<String> workspaceNotificationDestinations);

        /**
         * <p>
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
         * these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to use these channels.
         * </p>
         * 
         * @param workspaceNotificationDestinations
         *        Specify the Amazon Web Services notification channels that you plan to use in this workspace.
         *        Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions
         *        that allow Amazon Managed Grafana to use these channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceNotificationDestinationsWithStrings(String... workspaceNotificationDestinations);

        /**
         * <p>
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
         * these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to use these channels.
         * </p>
         * 
         * @param workspaceNotificationDestinations
         *        Specify the Amazon Web Services notification channels that you plan to use in this workspace.
         *        Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions
         *        that allow Amazon Managed Grafana to use these channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceNotificationDestinations(Collection<NotificationDestinationType> workspaceNotificationDestinations);

        /**
         * <p>
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
         * these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to use these channels.
         * </p>
         * 
         * @param workspaceNotificationDestinations
         *        Specify the Amazon Web Services notification channels that you plan to use in this workspace.
         *        Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions
         *        that allow Amazon Managed Grafana to use these channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceNotificationDestinations(NotificationDestinationType... workspaceNotificationDestinations);

        /**
         * <p>
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace
         * is in an account that is part of an organization.
         * </p>
         * 
         * @param workspaceOrganizationalUnits
         *        Specifies the organizational units that this workspace is allowed to use data sources from, if this
         *        workspace is in an account that is part of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits);

        /**
         * <p>
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace
         * is in an account that is part of an organization.
         * </p>
         * 
         * @param workspaceOrganizationalUnits
         *        Specifies the organizational units that this workspace is allowed to use data sources from, if this
         *        workspace is in an account that is part of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceOrganizationalUnits(String... workspaceOrganizationalUnits);

        /**
         * <p>
         * The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
         * workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
         * this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
         * <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
         * automatically created.
         * </p>
         * 
         * @param workspaceRoleArn
         *        The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
         *        workspace will view data from. If you already have a role that you want to use, specify it here. If
         *        you omit this field and you specify some Amazon Web Services resources in
         *        <code>workspaceDataSources</code> or <code>workspaceNotificationDestinations</code>, a new IAM role
         *        with the necessary permissions is automatically created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceRoleArn(String workspaceRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private String accountAccessType;

        private String organizationRoleName;

        private String permissionType;

        private String stackSetName;

        private List<String> workspaceDataSources = DefaultSdkAutoConstructList.getInstance();

        private String workspaceDescription;

        private String workspaceId;

        private String workspaceName;

        private List<String> workspaceNotificationDestinations = DefaultSdkAutoConstructList.getInstance();

        private List<String> workspaceOrganizationalUnits = DefaultSdkAutoConstructList.getInstance();

        private String workspaceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceRequest model) {
            super(model);
            accountAccessType(model.accountAccessType);
            organizationRoleName(model.organizationRoleName);
            permissionType(model.permissionType);
            stackSetName(model.stackSetName);
            workspaceDataSourcesWithStrings(model.workspaceDataSources);
            workspaceDescription(model.workspaceDescription);
            workspaceId(model.workspaceId);
            workspaceName(model.workspaceName);
            workspaceNotificationDestinationsWithStrings(model.workspaceNotificationDestinations);
            workspaceOrganizationalUnits(model.workspaceOrganizationalUnits);
            workspaceRoleArn(model.workspaceRoleArn);
        }

        public final String getAccountAccessType() {
            return accountAccessType;
        }

        public final void setAccountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
        }

        @Override
        public final Builder accountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
            return this;
        }

        @Override
        public final Builder accountAccessType(AccountAccessType accountAccessType) {
            this.accountAccessType(accountAccessType == null ? null : accountAccessType.toString());
            return this;
        }

        public final String getOrganizationRoleName() {
            return organizationRoleName;
        }

        public final void setOrganizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
        }

        @Override
        public final Builder organizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
            return this;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final Collection<String> getWorkspaceDataSources() {
            if (workspaceDataSources instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceDataSources;
        }

        public final void setWorkspaceDataSources(Collection<String> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copy(workspaceDataSources);
        }

        @Override
        public final Builder workspaceDataSourcesWithStrings(Collection<String> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copy(workspaceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDataSourcesWithStrings(String... workspaceDataSources) {
            workspaceDataSourcesWithStrings(Arrays.asList(workspaceDataSources));
            return this;
        }

        @Override
        public final Builder workspaceDataSources(Collection<DataSourceType> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copyEnumToString(workspaceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDataSources(DataSourceType... workspaceDataSources) {
            workspaceDataSources(Arrays.asList(workspaceDataSources));
            return this;
        }

        public final String getWorkspaceDescription() {
            return workspaceDescription;
        }

        public final void setWorkspaceDescription(String workspaceDescription) {
            this.workspaceDescription = workspaceDescription;
        }

        @Override
        public final Builder workspaceDescription(String workspaceDescription) {
            this.workspaceDescription = workspaceDescription;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getWorkspaceName() {
            return workspaceName;
        }

        public final void setWorkspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        @Override
        public final Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        public final Collection<String> getWorkspaceNotificationDestinations() {
            if (workspaceNotificationDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceNotificationDestinations;
        }

        public final void setWorkspaceNotificationDestinations(Collection<String> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copy(workspaceNotificationDestinations);
        }

        @Override
        public final Builder workspaceNotificationDestinationsWithStrings(Collection<String> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copy(workspaceNotificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceNotificationDestinationsWithStrings(String... workspaceNotificationDestinations) {
            workspaceNotificationDestinationsWithStrings(Arrays.asList(workspaceNotificationDestinations));
            return this;
        }

        @Override
        public final Builder workspaceNotificationDestinations(
                Collection<NotificationDestinationType> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier
                    .copyEnumToString(workspaceNotificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceNotificationDestinations(NotificationDestinationType... workspaceNotificationDestinations) {
            workspaceNotificationDestinations(Arrays.asList(workspaceNotificationDestinations));
            return this;
        }

        public final Collection<String> getWorkspaceOrganizationalUnits() {
            if (workspaceOrganizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceOrganizationalUnits;
        }

        public final void setWorkspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits = OrganizationalUnitListCopier.copy(workspaceOrganizationalUnits);
        }

        @Override
        public final Builder workspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits = OrganizationalUnitListCopier.copy(workspaceOrganizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceOrganizationalUnits(String... workspaceOrganizationalUnits) {
            workspaceOrganizationalUnits(Arrays.asList(workspaceOrganizationalUnits));
            return this;
        }

        public final String getWorkspaceRoleArn() {
            return workspaceRoleArn;
        }

        public final void setWorkspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
        }

        @Override
        public final Builder workspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceRequest build() {
            return new UpdateWorkspaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
