/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing information about how this workspace works with Amazon Web Services SSO.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSsoAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSsoAuthentication.Builder, AwsSsoAuthentication> {
    private static final SdkField<String> SSO_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssoClientId").getter(getter(AwsSsoAuthentication::ssoClientId)).setter(setter(Builder::ssoClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssoClientId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSO_CLIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ssoClientId;

    private AwsSsoAuthentication(BuilderImpl builder) {
        this.ssoClientId = builder.ssoClientId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services SSO-managed application that is created by Amazon Managed Grafana.
     * </p>
     * 
     * @return The ID of the Amazon Web Services SSO-managed application that is created by Amazon Managed Grafana.
     */
    public final String ssoClientId() {
        return ssoClientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ssoClientId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSsoAuthentication)) {
            return false;
        }
        AwsSsoAuthentication other = (AwsSsoAuthentication) obj;
        return Objects.equals(ssoClientId(), other.ssoClientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSsoAuthentication").add("SsoClientId", ssoClientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ssoClientId":
            return Optional.ofNullable(clazz.cast(ssoClientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSsoAuthentication, T> g) {
        return obj -> g.apply((AwsSsoAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSsoAuthentication> {
        /**
         * <p>
         * The ID of the Amazon Web Services SSO-managed application that is created by Amazon Managed Grafana.
         * </p>
         * 
         * @param ssoClientId
         *        The ID of the Amazon Web Services SSO-managed application that is created by Amazon Managed Grafana.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssoClientId(String ssoClientId);
    }

    static final class BuilderImpl implements Builder {
        private String ssoClientId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSsoAuthentication model) {
            ssoClientId(model.ssoClientId);
        }

        public final String getSsoClientId() {
            return ssoClientId;
        }

        public final void setSsoClientId(String ssoClientId) {
            this.ssoClientId = ssoClientId;
        }

        @Override
        @Transient
        public final Builder ssoClientId(String ssoClientId) {
            this.ssoClientId = ssoClientId;
            return this;
        }

        @Override
        public AwsSsoAuthentication build() {
            return new AwsSsoAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
