/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this
 * workspace. You can specify the metadata either by providing a URL to its location in the <code>url</code> parameter,
 * or by specifying the full metadata in XML format in the <code>xml</code> parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdpMetadata implements SdkPojo, Serializable, ToCopyableBuilder<IdpMetadata.Builder, IdpMetadata> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(IdpMetadata::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> XML_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("xml")
            .getter(getter(IdpMetadata::xml)).setter(setter(Builder::xml))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xml").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, XML_FIELD));

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String xml;

    private IdpMetadata(BuilderImpl builder) {
        this.url = builder.url;
        this.xml = builder.xml;
    }

    /**
     * <p>
     * The URL of the location containing the metadata.
     * </p>
     * 
     * @return The URL of the location containing the metadata.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The actual full metadata file, in XML format.
     * </p>
     * 
     * @return The actual full metadata file, in XML format.
     */
    public final String xml() {
        return xml;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(xml());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdpMetadata)) {
            return false;
        }
        IdpMetadata other = (IdpMetadata) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(xml(), other.xml());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdpMetadata").add("Url", url()).add("Xml", xml()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "xml":
            return Optional.ofNullable(clazz.cast(xml()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdpMetadata, T> g) {
        return obj -> g.apply((IdpMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdpMetadata> {
        /**
         * <p>
         * The URL of the location containing the metadata.
         * </p>
         * 
         * @param url
         *        The URL of the location containing the metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The actual full metadata file, in XML format.
         * </p>
         * 
         * @param xml
         *        The actual full metadata file, in XML format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xml(String xml);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String xml;

        private BuilderImpl() {
        }

        private BuilderImpl(IdpMetadata model) {
            url(model.url);
            xml(model.xml);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        @Transient
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getXml() {
            return xml;
        }

        public final void setXml(String xml) {
            this.xml = xml;
        }

        @Override
        @Transient
        public final Builder xml(String xml) {
            this.xml = xml;
            return this;
        }

        @Override
        public IdpMetadata build() {
            return new IdpMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
