/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class UpdateErrorListCopier {
    static List<UpdateError> copy(Collection<? extends UpdateError> updateErrorListParam) {
        List<UpdateError> list;
        if (updateErrorListParam == null || updateErrorListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UpdateError> modifiableList = new ArrayList<>();
            updateErrorListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<UpdateError> copyFromBuilder(Collection<? extends UpdateError.Builder> updateErrorListParam) {
        List<UpdateError> list;
        if (updateErrorListParam == null || updateErrorListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UpdateError> modifiableList = new ArrayList<>();
            updateErrorListParam.forEach(entry -> {
                UpdateError member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<UpdateError.Builder> copyToBuilder(Collection<? extends UpdateError> updateErrorListParam) {
        List<UpdateError.Builder> list;
        if (updateErrorListParam == null || updateErrorListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UpdateError.Builder> modifiableList = new ArrayList<>();
            updateErrorListParam.forEach(entry -> {
                UpdateError.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
