/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkspaceConfigurationRequest
extends GrafanaRequest
implements ToCopyableBuilder<Builder, UpdateWorkspaceConfigurationRequest> {
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuration").getter(UpdateWorkspaceConfigurationRequest.getter(UpdateWorkspaceConfigurationRequest::configuration)).setter(UpdateWorkspaceConfigurationRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> GRAFANA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grafanaVersion").getter(UpdateWorkspaceConfigurationRequest.getter(UpdateWorkspaceConfigurationRequest::grafanaVersion)).setter(UpdateWorkspaceConfigurationRequest.setter(Builder::grafanaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaVersion").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdateWorkspaceConfigurationRequest.getter(UpdateWorkspaceConfigurationRequest::workspaceId)).setter(UpdateWorkspaceConfigurationRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, GRAFANA_VERSION_FIELD, WORKSPACE_ID_FIELD));
    private final String configuration;
    private final String grafanaVersion;
    private final String workspaceId;

    private UpdateWorkspaceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.grafanaVersion = builder.grafanaVersion;
        this.workspaceId = builder.workspaceId;
    }

    public final String configuration() {
        return this.configuration;
    }

    public final String grafanaVersion() {
        return this.grafanaVersion;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.grafanaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceConfigurationRequest)) {
            return false;
        }
        UpdateWorkspaceConfigurationRequest other = (UpdateWorkspaceConfigurationRequest)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.grafanaVersion(), other.grafanaVersion()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkspaceConfigurationRequest").add("Configuration", (Object)this.configuration()).add("GrafanaVersion", (Object)this.grafanaVersion()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "grafanaVersion": {
                return Optional.ofNullable(clazz.cast(this.grafanaVersion()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaRequest.BuilderImpl
    implements Builder {
        private String configuration;
        private String grafanaVersion;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceConfigurationRequest model) {
            super(model);
            this.configuration(model.configuration);
            this.grafanaVersion(model.grafanaVersion);
            this.workspaceId(model.workspaceId);
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getGrafanaVersion() {
            return this.grafanaVersion;
        }

        public final void setGrafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
        }

        @Override
        public final Builder grafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceConfigurationRequest build() {
            return new UpdateWorkspaceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GrafanaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkspaceConfigurationRequest> {
        public Builder configuration(String var1);

        public Builder grafanaVersion(String var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

