/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest;
import software.amazon.awssdk.services.grafana.model.AssociateLicenseResponse;
import software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyRequest;
import software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyResponse;
import software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyRequest;
import software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyResponse;
import software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationRequest;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationResponse;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest;
import software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse;
import software.amazon.awssdk.services.grafana.model.DisassociateLicenseRequest;
import software.amazon.awssdk.services.grafana.model.DisassociateLicenseResponse;
import software.amazon.awssdk.services.grafana.model.ListPermissionsRequest;
import software.amazon.awssdk.services.grafana.model.ListPermissionsResponse;
import software.amazon.awssdk.services.grafana.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.grafana.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.grafana.model.ListVersionsRequest;
import software.amazon.awssdk.services.grafana.model.ListVersionsResponse;
import software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.grafana.model.TagResourceRequest;
import software.amazon.awssdk.services.grafana.model.TagResourceResponse;
import software.amazon.awssdk.services.grafana.model.UntagResourceRequest;
import software.amazon.awssdk.services.grafana.model.UntagResourceResponse;
import software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest;
import software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationResponse;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest;
import software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse;
import software.amazon.awssdk.services.grafana.paginators.ListPermissionsPublisher;
import software.amazon.awssdk.services.grafana.paginators.ListVersionsPublisher;
import software.amazon.awssdk.services.grafana.paginators.ListWorkspacesPublisher;

/**
 * Service client for accessing Amazon Managed Grafana asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Managed Grafana is a fully managed and secure data visualization service that you can use to instantly query,
 * correlate, and visualize operational metrics, logs, and traces from multiple sources. Amazon Managed Grafana makes it
 * easy to deploy, operate, and scale Grafana, a widely deployed data visualization tool that is popular for its
 * extensible data support.
 * </p>
 * <p>
 * With Amazon Managed Grafana, you create logically isolated Grafana servers called <i>workspaces</i>. In a workspace,
 * you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces without having to
 * build, package, or deploy any hardware to run Grafana servers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GrafanaAsyncClient extends AwsClient {
    String SERVICE_NAME = "grafana";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "grafana";

    /**
     * <p>
     * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html">Upgrade a
     * workspace to Grafana Enterprise</a>.
     * </p>
     *
     * @param associateLicenseRequest
     * @return A Java Future containing the result of the AssociateLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.AssociateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/AssociateLicense" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateLicenseResponse> associateLicense(AssociateLicenseRequest associateLicenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html">Upgrade a
     * workspace to Grafana Enterprise</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLicenseRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateLicenseRequest#builder()}
     * </p>
     *
     * @param associateLicenseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.AssociateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/AssociateLicense" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateLicenseResponse> associateLicense(
            Consumer<AssociateLicenseRequest.Builder> associateLicenseRequest) {
        return associateLicense(AssociateLicenseRequest.builder().applyMutation(associateLicenseRequest).build());
    }

    /**
     * <p>
     * Creates a <i>workspace</i>. In a workspace, you can create Grafana dashboards and visualizations to analyze your
     * metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
     * </p>
     * <p>
     * Don't use <code>CreateWorkspace</code> to modify an existing workspace. Instead, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html">UpdateWorkspace</a>.
     * </p>
     *
     * @param createWorkspaceRequest
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceResponse> createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <i>workspace</i>. In a workspace, you can create Grafana dashboards and visualizations to analyze your
     * metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
     * </p>
     * <p>
     * Don't use <code>CreateWorkspace</code> to modify an existing workspace. Instead, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html">UpdateWorkspace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkspaceRequest#builder()}
     * </p>
     *
     * @param createWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceResponse> createWorkspace(
            Consumer<CreateWorkspaceRequest.Builder> createWorkspaceRequest) {
        return createWorkspace(CreateWorkspaceRequest.builder().applyMutation(createWorkspaceRequest).build());
    }

    /**
     * <p>
     * Creates a Grafana API key for the workspace. This key can be used to authenticate requests sent to the
     * workspace's HTTP API. See <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html">https
     * ://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html</a> for available APIs and example
     * requests.
     * </p>
     *
     * @param createWorkspaceApiKeyRequest
     * @return A Java Future containing the result of the CreateWorkspaceApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.CreateWorkspaceApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspaceApiKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceApiKeyResponse> createWorkspaceApiKey(
            CreateWorkspaceApiKeyRequest createWorkspaceApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Grafana API key for the workspace. This key can be used to authenticate requests sent to the
     * workspace's HTTP API. See <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html">https
     * ://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html</a> for available APIs and example
     * requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceApiKeyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkspaceApiKeyRequest#builder()}
     * </p>
     *
     * @param createWorkspaceApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.CreateWorkspaceApiKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkspaceApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.CreateWorkspaceApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspaceApiKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceApiKeyResponse> createWorkspaceApiKey(
            Consumer<CreateWorkspaceApiKeyRequest.Builder> createWorkspaceApiKeyRequest) {
        return createWorkspaceApiKey(CreateWorkspaceApiKeyRequest.builder().applyMutation(createWorkspaceApiKeyRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Managed Grafana workspace.
     * </p>
     *
     * @param deleteWorkspaceRequest
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Managed Grafana workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkspaceRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceResponse> deleteWorkspace(
            Consumer<DeleteWorkspaceRequest.Builder> deleteWorkspaceRequest) {
        return deleteWorkspace(DeleteWorkspaceRequest.builder().applyMutation(deleteWorkspaceRequest).build());
    }

    /**
     * <p>
     * Deletes a Grafana API key for the workspace.
     * </p>
     *
     * @param deleteWorkspaceApiKeyRequest
     * @return A Java Future containing the result of the DeleteWorkspaceApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DeleteWorkspaceApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspaceApiKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceApiKeyResponse> deleteWorkspaceApiKey(
            DeleteWorkspaceApiKeyRequest deleteWorkspaceApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Grafana API key for the workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceApiKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkspaceApiKeyRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.DeleteWorkspaceApiKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkspaceApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DeleteWorkspaceApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspaceApiKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceApiKeyResponse> deleteWorkspaceApiKey(
            Consumer<DeleteWorkspaceApiKeyRequest.Builder> deleteWorkspaceApiKeyRequest) {
        return deleteWorkspaceApiKey(DeleteWorkspaceApiKeyRequest.builder().applyMutation(deleteWorkspaceApiKeyRequest).build());
    }

    /**
     * <p>
     * Displays information about one Amazon Managed Grafana workspace.
     * </p>
     *
     * @param describeWorkspaceRequest
     * @return A Java Future containing the result of the DescribeWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DescribeWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceResponse> describeWorkspace(DescribeWorkspaceRequest describeWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays information about one Amazon Managed Grafana workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkspaceRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DescribeWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceResponse> describeWorkspace(
            Consumer<DescribeWorkspaceRequest.Builder> describeWorkspaceRequest) {
        return describeWorkspace(DescribeWorkspaceRequest.builder().applyMutation(describeWorkspaceRequest).build());
    }

    /**
     * <p>
     * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
     * </p>
     *
     * @param describeWorkspaceAuthenticationRequest
     * @return A Java Future containing the result of the DescribeWorkspaceAuthentication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DescribeWorkspaceAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceAuthenticationResponse> describeWorkspaceAuthentication(
            DescribeWorkspaceAuthenticationRequest describeWorkspaceAuthenticationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceAuthenticationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceAuthenticationRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceAuthenticationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeWorkspaceAuthentication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DescribeWorkspaceAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceAuthenticationResponse> describeWorkspaceAuthentication(
            Consumer<DescribeWorkspaceAuthenticationRequest.Builder> describeWorkspaceAuthenticationRequest) {
        return describeWorkspaceAuthentication(DescribeWorkspaceAuthenticationRequest.builder()
                .applyMutation(describeWorkspaceAuthenticationRequest).build());
    }

    /**
     * <p>
     * Gets the current configuration string for the given workspace.
     * </p>
     *
     * @param describeWorkspaceConfigurationRequest
     * @return A Java Future containing the result of the DescribeWorkspaceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DescribeWorkspaceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceConfigurationResponse> describeWorkspaceConfiguration(
            DescribeWorkspaceConfigurationRequest describeWorkspaceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current configuration string for the given workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkspaceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkspaceConfigurationRequest#builder()}
     * </p>
     *
     * @param describeWorkspaceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.DescribeWorkspaceConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeWorkspaceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DescribeWorkspaceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkspaceConfigurationResponse> describeWorkspaceConfiguration(
            Consumer<DescribeWorkspaceConfigurationRequest.Builder> describeWorkspaceConfigurationRequest) {
        return describeWorkspaceConfiguration(DescribeWorkspaceConfigurationRequest.builder()
                .applyMutation(describeWorkspaceConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes the Grafana Enterprise license from a workspace.
     * </p>
     *
     * @param disassociateLicenseRequest
     * @return A Java Future containing the result of the DisassociateLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DisassociateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DisassociateLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateLicenseResponse> disassociateLicense(
            DisassociateLicenseRequest disassociateLicenseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the Grafana Enterprise license from a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLicenseRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateLicenseRequest#builder()}
     * </p>
     *
     * @param disassociateLicenseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.DisassociateLicenseRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateLicense operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.DisassociateLicense
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DisassociateLicense" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateLicenseResponse> disassociateLicense(
            Consumer<DisassociateLicenseRequest.Builder> disassociateLicenseRequest) {
        return disassociateLicense(DisassociateLicenseRequest.builder().applyMutation(disassociateLicenseRequest).build());
    }

    /**
     * <p>
     * Lists the users and groups who have the Grafana <code>Admin</code> and <code>Editor</code> roles in this
     * workspace. If you use this operation without specifying <code>userId</code> or <code>groupId</code>, the
     * operation returns the roles of all users and groups. If you specify a <code>userId</code> or a
     * <code>groupId</code>, only the roles for that user or group are returned. If you do this, you can specify only
     * one <code>userId</code> or one <code>groupId</code>.
     * </p>
     *
     * @param listPermissionsRequest
     * @return A Java Future containing the result of the ListPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPermissionsResponse> listPermissions(ListPermissionsRequest listPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users and groups who have the Grafana <code>Admin</code> and <code>Editor</code> roles in this
     * workspace. If you use this operation without specifying <code>userId</code> or <code>groupId</code>, the
     * operation returns the roles of all users and groups. If you specify a <code>userId</code> or a
     * <code>groupId</code>, only the roles for that user or group are returned. If you do this, you can specify only
     * one <code>userId</code> or one <code>groupId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.ListPermissionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPermissionsResponse> listPermissions(
            Consumer<ListPermissionsRequest.Builder> listPermissionsRequest) {
        return listPermissions(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.grafana.model.ListPermissionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListPermissionsPublisher publisher = client.listPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListPermissionsPublisher publisher = client.listPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.grafana.model.ListPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.grafana.model.ListPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.grafana.model.ListPermissionsRequest)} operation.</b>
     * </p>
     *
     * @param listPermissionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsPublisher listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest) {
        return new ListPermissionsPublisher(this, listPermissionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.grafana.model.ListPermissionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListPermissionsPublisher publisher = client.listPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListPermissionsPublisher publisher = client.listPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.grafana.model.ListPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.grafana.model.ListPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.grafana.model.ListPermissionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.ListPermissionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPermissionsPublisher listPermissionsPaginator(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest) {
        return listPermissionsPaginator(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * The <code>ListTagsForResource</code> operation returns the tags that are associated with the Amazon Managed
     * Service for Grafana resource specified by the <code>resourceArn</code>. Currently, the only resource that can be
     * tagged is a workspace.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>ListTagsForResource</code> operation returns the tags that are associated with the Amazon Managed
     * Service for Grafana resource specified by the <code>resourceArn</code>. Currently, the only resource that can be
     * tagged is a workspace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists available versions of Grafana. These are available when calling <code>CreateWorkspace</code>. Optionally,
     * include a workspace to list the versions to which it can be upgraded.
     * </p>
     *
     * @param listVersionsRequest
     * @return A Java Future containing the result of the ListVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVersionsResponse> listVersions(ListVersionsRequest listVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available versions of Grafana. These are available when calling <code>CreateWorkspace</code>. Optionally,
     * include a workspace to list the versions to which it can be upgraded.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVersionsRequest#builder()}
     * </p>
     *
     * @param listVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.ListVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVersionsResponse> listVersions(Consumer<ListVersionsRequest.Builder> listVersionsRequest) {
        return listVersions(ListVersionsRequest.builder().applyMutation(listVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listVersions(software.amazon.awssdk.services.grafana.model.ListVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.grafana.model.ListVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.grafana.model.ListVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersions(software.amazon.awssdk.services.grafana.model.ListVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVersionsPublisher listVersionsPaginator(ListVersionsRequest listVersionsRequest) {
        return new ListVersionsPublisher(this, listVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listVersions(software.amazon.awssdk.services.grafana.model.ListVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.grafana.model.ListVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.grafana.model.ListVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersions(software.amazon.awssdk.services.grafana.model.ListVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVersionsRequest#builder()}
     * </p>
     *
     * @param listVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.ListVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVersionsPublisher listVersionsPaginator(Consumer<ListVersionsRequest.Builder> listVersionsRequest) {
        return listVersionsPaginator(ListVersionsRequest.builder().applyMutation(listVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace.
     * For more complete information about one workspace, use <a
     * href="https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html">DescribeWorkspace</a>.
     * </p>
     *
     * @param listWorkspacesRequest
     * @return A Java Future containing the result of the ListWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkspacesResponse> listWorkspaces(ListWorkspacesRequest listWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace.
     * For more complete information about one workspace, use <a
     * href="https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html">DescribeWorkspace</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkspacesResponse> listWorkspaces(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest) {
        return listWorkspaces(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkspaces(software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     *
     * @param listWorkspacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkspacesPublisher listWorkspacesPaginator(ListWorkspacesRequest listWorkspacesRequest) {
        return new ListWorkspacesPublisher(this, listWorkspacesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkspaces(software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.grafana.paginators.ListWorkspacesPublisher publisher = client.listWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaces(software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkspacesRequest#builder()}
     * </p>
     *
     * @param listWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkspacesPublisher listWorkspacesPaginator(Consumer<ListWorkspacesRequest.Builder> listWorkspacesRequest) {
        return listWorkspacesPaginator(ListWorkspacesRequest.builder().applyMutation(listWorkspacesRequest).build());
    }

    /**
     * <p>
     * The <code>TagResource</code> operation associates tags with an Amazon Managed Grafana resource. Currently, the
     * only resource that can be tagged is workspaces.
     * </p>
     * <p>
     * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the
     * resource. If you specify a tag key that is already associated with the resource, the new tag value that you
     * specify replaces the previous value for that tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>TagResource</code> operation associates tags with an Amazon Managed Grafana resource. Currently, the
     * only resource that can be tagged is workspaces.
     * </p>
     * <p>
     * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the
     * resource. If you specify a tag key that is already associated with the resource, the new tag value that you
     * specify replaces the previous value for that tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * The <code>UntagResource</code> operation removes the association of the tag with the Amazon Managed Grafana
     * resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>UntagResource</code> operation removes the association of the tag with the Amazon Managed Grafana
     * resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates which users in a workspace have the Grafana <code>Admin</code> or <code>Editor</code> roles.
     * </p>
     *
     * @param updatePermissionsRequest
     * @return A Java Future containing the result of the UpdatePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UpdatePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdatePermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePermissionsResponse> updatePermissions(UpdatePermissionsRequest updatePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates which users in a workspace have the Grafana <code>Admin</code> or <code>Editor</code> roles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePermissionsRequest#builder()}
     * </p>
     *
     * @param updatePermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UpdatePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdatePermissions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePermissionsResponse> updatePermissions(
            Consumer<UpdatePermissionsRequest.Builder> updatePermissionsRequest) {
        return updatePermissions(UpdatePermissionsRequest.builder().applyMutation(updatePermissionsRequest).build());
    }

    /**
     * <p>
     * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional
     * parameters, the existing values of those parameters are not changed.
     * </p>
     * <p>
     * To modify the user authentication methods that the workspace uses, such as SAML or IAM Identity Center, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html">
     * UpdateWorkspaceAuthentication</a>.
     * </p>
     * <p>
     * To modify which users in the workspace have the <code>Admin</code> and <code>Editor</code> Grafana roles, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a>.
     * </p>
     *
     * @param updateWorkspaceRequest
     * @return A Java Future containing the result of the UpdateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceResponse> updateWorkspace(UpdateWorkspaceRequest updateWorkspaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional
     * parameters, the existing values of those parameters are not changed.
     * </p>
     * <p>
     * To modify the user authentication methods that the workspace uses, such as SAML or IAM Identity Center, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html">
     * UpdateWorkspaceAuthentication</a>.
     * </p>
     * <p>
     * To modify which users in the workspace have the <code>Admin</code> and <code>Editor</code> Grafana roles, use <a
     * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkspaceRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWorkspace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceResponse> updateWorkspace(
            Consumer<UpdateWorkspaceRequest.Builder> updateWorkspaceRequest) {
        return updateWorkspace(UpdateWorkspaceRequest.builder().applyMutation(updateWorkspaceRequest).build());
    }

    /**
     * <p>
     * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using
     * SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the
     * assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
     * </p>
     * <note>
     * <p>
     * Changes to the authentication method for a workspace may take a few minutes to take effect.
     * </p>
     * </note>
     *
     * @param updateWorkspaceAuthenticationRequest
     * @return A Java Future containing the result of the UpdateWorkspaceAuthentication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UpdateWorkspaceAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceAuthenticationResponse> updateWorkspaceAuthentication(
            UpdateWorkspaceAuthenticationRequest updateWorkspaceAuthenticationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using
     * SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the
     * assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
     * </p>
     * <note>
     * <p>
     * Changes to the authentication method for a workspace may take a few minutes to take effect.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceAuthenticationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateWorkspaceAuthenticationRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceAuthenticationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateWorkspaceAuthentication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UpdateWorkspaceAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceAuthenticationResponse> updateWorkspaceAuthentication(
            Consumer<UpdateWorkspaceAuthenticationRequest.Builder> updateWorkspaceAuthenticationRequest) {
        return updateWorkspaceAuthentication(UpdateWorkspaceAuthenticationRequest.builder()
                .applyMutation(updateWorkspaceAuthenticationRequest).build());
    }

    /**
     * <p>
     * Updates the configuration string for the given workspace
     * </p>
     *
     * @param updateWorkspaceConfigurationRequest
     * @return A Java Future containing the result of the UpdateWorkspaceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UpdateWorkspaceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceConfigurationResponse> updateWorkspaceConfiguration(
            UpdateWorkspaceConfigurationRequest updateWorkspaceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration string for the given workspace
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkspaceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateWorkspaceConfigurationRequest#builder()}
     * </p>
     *
     * @param updateWorkspaceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.grafana.model.UpdateWorkspaceConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateWorkspaceConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ThrottlingException The request was denied because of request throttling. Retry the request.</li>
     *         <li>ConflictException A resource was in an inconsistent state during an update or a deletion.</li>
     *         <li>ValidationException The value of a parameter in the request caused an error.</li>
     *         <li>AccessDeniedException You do not have sufficient permissions to perform this action.</li>
     *         <li>InternalServerException Unexpected error while processing the request. Retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GrafanaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GrafanaAsyncClient.UpdateWorkspaceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkspaceConfigurationResponse> updateWorkspaceConfiguration(
            Consumer<UpdateWorkspaceConfigurationRequest.Builder> updateWorkspaceConfigurationRequest) {
        return updateWorkspaceConfiguration(UpdateWorkspaceConfigurationRequest.builder()
                .applyMutation(updateWorkspaceConfigurationRequest).build());
    }

    @Override
    default GrafanaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GrafanaAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GrafanaAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GrafanaAsyncClient}.
     */
    static GrafanaAsyncClientBuilder builder() {
        return new DefaultGrafanaAsyncClientBuilder();
    }
}
