/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateLicenseRequest extends GrafanaRequest implements
        ToCopyableBuilder<AssociateLicenseRequest.Builder, AssociateLicenseRequest> {
    private static final SdkField<String> GRAFANA_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("grafanaToken").getter(getter(AssociateLicenseRequest::grafanaToken))
            .setter(setter(Builder::grafanaToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Grafana-Token").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseType").getter(getter(AssociateLicenseRequest::licenseTypeAsString))
            .setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("licenseType").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(AssociateLicenseRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAFANA_TOKEN_FIELD,
            LICENSE_TYPE_FIELD, WORKSPACE_ID_FIELD));

    private final String grafanaToken;

    private final String licenseType;

    private final String workspaceId;

    private AssociateLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.grafanaToken = builder.grafanaToken;
        this.licenseType = builder.licenseType;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * A token from Grafana Labs that ties your Amazon Web Services account with a Grafana Labs account. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise"
     * >Register with Grafana Labs</a>.
     * </p>
     * 
     * @return A token from Grafana Labs that ties your Amazon Web Services account with a Grafana Labs account. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise"
     *         >Register with Grafana Labs</a>.
     */
    public final String grafanaToken() {
        return grafanaToken;
    }

    /**
     * <p>
     * The type of license to associate with the workspace.
     * </p>
     * <note>
     * <p>
     * Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link LicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The type of license to associate with the workspace.</p> <note>
     *         <p>
     *         Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
     *         </p>
     * @see LicenseType
     */
    public final LicenseType licenseType() {
        return LicenseType.fromValue(licenseType);
    }

    /**
     * <p>
     * The type of license to associate with the workspace.
     * </p>
     * <note>
     * <p>
     * Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link LicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The type of license to associate with the workspace.</p> <note>
     *         <p>
     *         Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
     *         </p>
     * @see LicenseType
     */
    public final String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * The ID of the workspace to associate the license with.
     * </p>
     * 
     * @return The ID of the workspace to associate the license with.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(grafanaToken());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateLicenseRequest)) {
            return false;
        }
        AssociateLicenseRequest other = (AssociateLicenseRequest) obj;
        return Objects.equals(grafanaToken(), other.grafanaToken())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateLicenseRequest").add("GrafanaToken", grafanaToken())
                .add("LicenseType", licenseTypeAsString()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grafanaToken":
            return Optional.ofNullable(clazz.cast(grafanaToken()));
        case "licenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateLicenseRequest, T> g) {
        return obj -> g.apply((AssociateLicenseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateLicenseRequest> {
        /**
         * <p>
         * A token from Grafana Labs that ties your Amazon Web Services account with a Grafana Labs account. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise"
         * >Register with Grafana Labs</a>.
         * </p>
         * 
         * @param grafanaToken
         *        A token from Grafana Labs that ties your Amazon Web Services account with a Grafana Labs account. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise"
         *        >Register with Grafana Labs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grafanaToken(String grafanaToken);

        /**
         * <p>
         * The type of license to associate with the workspace.
         * </p>
         * <note>
         * <p>
         * Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
         * </p>
         * </note>
         * 
         * @param licenseType
         *        The type of license to associate with the workspace.</p> <note>
         *        <p>
         *        Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
         *        </p>
         * @see LicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseType
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The type of license to associate with the workspace.
         * </p>
         * <note>
         * <p>
         * Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
         * </p>
         * </note>
         * 
         * @param licenseType
         *        The type of license to associate with the workspace.</p> <note>
         *        <p>
         *        Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
         *        </p>
         * @see LicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseType
         */
        Builder licenseType(LicenseType licenseType);

        /**
         * <p>
         * The ID of the workspace to associate the license with.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace to associate the license with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private String grafanaToken;

        private String licenseType;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateLicenseRequest model) {
            super(model);
            grafanaToken(model.grafanaToken);
            licenseType(model.licenseType);
            workspaceId(model.workspaceId);
        }

        public final String getGrafanaToken() {
            return grafanaToken;
        }

        public final void setGrafanaToken(String grafanaToken) {
            this.grafanaToken = grafanaToken;
        }

        @Override
        public final Builder grafanaToken(String grafanaToken) {
            this.grafanaToken = grafanaToken;
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateLicenseRequest build() {
            return new AssociateLicenseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
