/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceRequest extends GrafanaRequest implements
        ToCopyableBuilder<CreateWorkspaceRequest.Builder, CreateWorkspaceRequest> {
    private static final SdkField<String> ACCOUNT_ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountAccessType").getter(getter(CreateWorkspaceRequest::accountAccessTypeAsString))
            .setter(setter(Builder::accountAccessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAccessType").build()).build();

    private static final SdkField<List<String>> AUTHENTICATION_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("authenticationProviders")
            .getter(getter(CreateWorkspaceRequest::authenticationProvidersAsStrings))
            .setter(setter(Builder::authenticationProvidersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateWorkspaceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONFIGURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuration")
            .getter(getter(CreateWorkspaceRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> GRAFANA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("grafanaVersion").getter(getter(CreateWorkspaceRequest::grafanaVersion))
            .setter(setter(Builder::grafanaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaVersion").build()).build();

    private static final SdkField<NetworkAccessConfiguration> NETWORK_ACCESS_CONTROL_FIELD = SdkField
            .<NetworkAccessConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkAccessControl")
            .getter(getter(CreateWorkspaceRequest::networkAccessControl)).setter(setter(Builder::networkAccessControl))
            .constructor(NetworkAccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkAccessControl").build())
            .build();

    private static final SdkField<String> ORGANIZATION_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationRoleName").getter(getter(CreateWorkspaceRequest::organizationRoleName))
            .setter(setter(Builder::organizationRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRoleName").build())
            .build();

    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionType").getter(getter(CreateWorkspaceRequest::permissionTypeAsString))
            .setter(setter(Builder::permissionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionType").build()).build();

    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackSetName").getter(getter(CreateWorkspaceRequest::stackSetName))
            .setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackSetName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateWorkspaceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(CreateWorkspaceRequest::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final SdkField<List<String>> WORKSPACE_DATA_SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("workspaceDataSources")
            .getter(getter(CreateWorkspaceRequest::workspaceDataSourcesAsStrings))
            .setter(setter(Builder::workspaceDataSourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceDataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceDescription").getter(getter(CreateWorkspaceRequest::workspaceDescription))
            .setter(setter(Builder::workspaceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceDescription").build())
            .build();

    private static final SdkField<String> WORKSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceName").getter(getter(CreateWorkspaceRequest::workspaceName))
            .setter(setter(Builder::workspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceName").build()).build();

    private static final SdkField<List<String>> WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("workspaceNotificationDestinations")
            .getter(getter(CreateWorkspaceRequest::workspaceNotificationDestinationsAsStrings))
            .setter(setter(Builder::workspaceNotificationDestinationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceNotificationDestinations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WORKSPACE_ORGANIZATIONAL_UNITS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("workspaceOrganizationalUnits")
            .getter(getter(CreateWorkspaceRequest::workspaceOrganizationalUnits))
            .setter(setter(Builder::workspaceOrganizationalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceOrganizationalUnits")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceRoleArn").getter(getter(CreateWorkspaceRequest::workspaceRoleArn))
            .setter(setter(Builder::workspaceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ACCESS_TYPE_FIELD,
            AUTHENTICATION_PROVIDERS_FIELD, CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, GRAFANA_VERSION_FIELD,
            NETWORK_ACCESS_CONTROL_FIELD, ORGANIZATION_ROLE_NAME_FIELD, PERMISSION_TYPE_FIELD, STACK_SET_NAME_FIELD, TAGS_FIELD,
            VPC_CONFIGURATION_FIELD, WORKSPACE_DATA_SOURCES_FIELD, WORKSPACE_DESCRIPTION_FIELD, WORKSPACE_NAME_FIELD,
            WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD, WORKSPACE_ORGANIZATIONAL_UNITS_FIELD, WORKSPACE_ROLE_ARN_FIELD));

    private final String accountAccessType;

    private final List<String> authenticationProviders;

    private final String clientToken;

    private final String configuration;

    private final String grafanaVersion;

    private final NetworkAccessConfiguration networkAccessControl;

    private final String organizationRoleName;

    private final String permissionType;

    private final String stackSetName;

    private final Map<String, String> tags;

    private final VpcConfiguration vpcConfiguration;

    private final List<String> workspaceDataSources;

    private final String workspaceDescription;

    private final String workspaceName;

    private final List<String> workspaceNotificationDestinations;

    private final List<String> workspaceOrganizationalUnits;

    private final String workspaceRoleArn;

    private CreateWorkspaceRequest(BuilderImpl builder) {
        super(builder);
        this.accountAccessType = builder.accountAccessType;
        this.authenticationProviders = builder.authenticationProviders;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.grafanaVersion = builder.grafanaVersion;
        this.networkAccessControl = builder.networkAccessControl;
        this.organizationRoleName = builder.organizationRoleName;
        this.permissionType = builder.permissionType;
        this.stackSetName = builder.stackSetName;
        this.tags = builder.tags;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.workspaceDataSources = builder.workspaceDataSources;
        this.workspaceDescription = builder.workspaceDescription;
        this.workspaceName = builder.workspaceName;
        this.workspaceNotificationDestinations = builder.workspaceNotificationDestinations;
        this.workspaceOrganizationalUnits = builder.workspaceOrganizationalUnits;
        this.workspaceRoleArn = builder.workspaceRoleArn;
    }

    /**
     * <p>
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account
     * only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If
     * you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in
     * the <code>workspaceOrganizationalUnits</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountAccessType}
     * will return {@link AccountAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services
     *         account only, or whether it can also access Amazon Web Services resources in other accounts in the same
     *         organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the
     *         workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.
     * @see AccountAccessType
     */
    public final AccountAccessType accountAccessType() {
        return AccountAccessType.fromValue(accountAccessType);
    }

    /**
     * <p>
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account
     * only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If
     * you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in
     * the <code>workspaceOrganizationalUnits</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountAccessType}
     * will return {@link AccountAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accountAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services
     *         account only, or whether it can also access Amazon Web Services resources in other accounts in the same
     *         organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the
     *         workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.
     * @see AccountAccessType
     */
    public final String accountAccessTypeAsString() {
        return accountAccessType;
    }

    /**
     * <p>
     * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using the
     * Grafana console within a workspace. For more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
     * Amazon Managed Grafana</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationProviders} method.
     * </p>
     * 
     * @return Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
     *         using the Grafana console within a workspace. For more information, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
     *         authentication in Amazon Managed Grafana</a>.
     */
    public final List<AuthenticationProviderTypes> authenticationProviders() {
        return AuthenticationProvidersCopier.copyStringToEnum(authenticationProviders);
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthenticationProviders property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthenticationProviders() {
        return authenticationProviders != null && !(authenticationProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using the
     * Grafana console within a workspace. For more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
     * Amazon Managed Grafana</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationProviders} method.
     * </p>
     * 
     * @return Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
     *         using the Grafana console within a workspace. For more information, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
     *         authentication in Amazon Managed Grafana</a>.
     */
    public final List<String> authenticationProvidersAsStrings() {
        return authenticationProviders;
    }

    /**
     * <p>
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration string for the workspace that you create. For more information about the format and
     * configuration options available, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html">Working in your Grafana
     * workspace</a>.
     * </p>
     * 
     * @return The configuration string for the workspace that you create. For more information about the format and
     *         configuration options available, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html">Working in your
     *         Grafana workspace</a>.
     */
    public final String configuration() {
        return configuration;
    }

    /**
     * <p>
     * Specifies the version of Grafana to support in the new workspace. If not specified, defaults to the latest
     * version (for example, 9.4).
     * </p>
     * <p>
     * To get a list of supported versions, use the <code>ListVersions</code> operation.
     * </p>
     * 
     * @return Specifies the version of Grafana to support in the new workspace. If not specified, defaults to the
     *         latest version (for example, 9.4).</p>
     *         <p>
     *         To get a list of supported versions, use the <code>ListVersions</code> operation.
     */
    public final String grafanaVersion() {
        return grafanaVersion;
    }

    /**
     * <p>
     * Configuration for network access to your workspace.
     * </p>
     * <p>
     * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace.
     * Standard Grafana authentication and authorization will still be required.
     * </p>
     * <p>
     * If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard
     * Grafana authentication and authorization will still be required.
     * </p>
     * 
     * @return Configuration for network access to your workspace.</p>
     *         <p>
     *         When this is configured, only listed IP addresses and VPC endpoints will be able to access your
     *         workspace. Standard Grafana authentication and authorization will still be required.
     *         </p>
     *         <p>
     *         If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed.
     *         Standard Grafana authentication and authorization will still be required.
     */
    public final NetworkAccessConfiguration networkAccessControl() {
        return networkAccessControl;
    }

    /**
     * <p>
     * The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources
     * and notification channels in other accounts in an organization.
     * </p>
     * 
     * @return The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data
     *         sources and notification channels in other accounts in an organization.
     */
    public final String organizationRoleName() {
        return organizationRoleName;
    }

    /**
     * <p>
     * When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation, you
     * must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web Services data
     * sources and notification channels.
     * </p>
     * <p>
     * You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the workspace to use
     * when accessing those datasources and notification channels.
     * </p>
     * <p>
     * The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported only in
     * the Amazon Managed Grafana console, where this value may be set to <code>SERVICE_MANAGED</code>.
     * </p>
     * <note>
     * <p>
     * Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI or Amazon
     * Web Services CloudFormation.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana
     * permissions and policies for Amazon Web Services data sources and notification channels</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation,
     *         you must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web
     *         Services data sources and notification channels.</p>
     *         <p>
     *         You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the workspace
     *         to use when accessing those datasources and notification channels.
     *         </p>
     *         <p>
     *         The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported
     *         only in the Amazon Managed Grafana console, where this value may be set to <code>SERVICE_MANAGED</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI or
     *         Amazon Web Services CloudFormation.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
     *         Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>.
     * @see PermissionType
     */
    public final PermissionType permissionType() {
        return PermissionType.fromValue(permissionType);
    }

    /**
     * <p>
     * When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation, you
     * must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web Services data
     * sources and notification channels.
     * </p>
     * <p>
     * You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the workspace to use
     * when accessing those datasources and notification channels.
     * </p>
     * <p>
     * The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported only in
     * the Amazon Managed Grafana console, where this value may be set to <code>SERVICE_MANAGED</code>.
     * </p>
     * <note>
     * <p>
     * Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI or Amazon
     * Web Services CloudFormation.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana
     * permissions and policies for Amazon Web Services data sources and notification channels</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation,
     *         you must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web
     *         Services data sources and notification channels.</p>
     *         <p>
     *         You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the workspace
     *         to use when accessing those datasources and notification channels.
     *         </p>
     *         <p>
     *         The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported
     *         only in the Amazon Managed Grafana console, where this value may be set to <code>SERVICE_MANAGED</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI or
     *         Amazon Web Services CloudFormation.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
     *         Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>.
     * @see PermissionType
     */
    public final String permissionTypeAsString() {
        return permissionType;
    }

    /**
     * <p>
     * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
     * </p>
     * 
     * @return The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
     */
    public final String stackSetName() {
        return stackSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tags associated with the workspace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags associated with the workspace.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
     * </p>
     * <note>
     * <p>
     * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
     * </p>
     * </note>
     * 
     * @return The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to
     *         connect to.</p> <note>
     *         <p>
     *         Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
     *         </p>
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * This parameter is for internal use only, and should not be used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceDataSources} method.
     * </p>
     * 
     * @return This parameter is for internal use only, and should not be used.
     */
    public final List<DataSourceType> workspaceDataSources() {
        return DataSourceTypesListCopier.copyStringToEnum(workspaceDataSources);
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceDataSources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkspaceDataSources() {
        return workspaceDataSources != null && !(workspaceDataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter is for internal use only, and should not be used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceDataSources} method.
     * </p>
     * 
     * @return This parameter is for internal use only, and should not be used.
     */
    public final List<String> workspaceDataSourcesAsStrings() {
        return workspaceDataSources;
    }

    /**
     * <p>
     * A description for the workspace. This is used only to help you identify this workspace.
     * </p>
     * <p>
     * Pattern: <code>^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$</code>
     * </p>
     * 
     * @return A description for the workspace. This is used only to help you identify this workspace.</p>
     *         <p>
     *         Pattern: <code>^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$</code>
     */
    public final String workspaceDescription() {
        return workspaceDescription;
    }

    /**
     * <p>
     * The name for the workspace. It does not have to be unique.
     * </p>
     * 
     * @return The name for the workspace. It does not have to be unique.
     */
    public final String workspaceName() {
        return workspaceName;
    }

    /**
     * <p>
     * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
     * data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed
     * Grafana to use these channels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceNotificationDestinations}
     * method.
     * </p>
     * 
     * @return Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
     *         these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
     *         Amazon Managed Grafana to use these channels.
     */
    public final List<NotificationDestinationType> workspaceNotificationDestinations() {
        return NotificationDestinationsListCopier.copyStringToEnum(workspaceNotificationDestinations);
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceNotificationDestinations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasWorkspaceNotificationDestinations() {
        return workspaceNotificationDestinations != null && !(workspaceNotificationDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
     * data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed
     * Grafana to use these channels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceNotificationDestinations}
     * method.
     * </p>
     * 
     * @return Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
     *         these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
     *         Amazon Managed Grafana to use these channels.
     */
    public final List<String> workspaceNotificationDestinationsAsStrings() {
        return workspaceNotificationDestinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceOrganizationalUnits property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkspaceOrganizationalUnits() {
        return workspaceOrganizationalUnits != null && !(workspaceOrganizationalUnits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is
     * in an account that is part of an organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceOrganizationalUnits} method.
     * </p>
     * 
     * @return Specifies the organizational units that this workspace is allowed to use data sources from, if this
     *         workspace is in an account that is part of an organization.
     */
    public final List<String> workspaceOrganizationalUnits() {
        return workspaceOrganizationalUnits;
    }

    /**
     * <p>
     * Specified the IAM role that grants permissions to the Amazon Web Services resources that the workspace will view
     * data from, including both data sources and notification channels. You are responsible for managing the
     * permissions for this role as new data sources or notification channels are added.
     * </p>
     * 
     * @return Specified the IAM role that grants permissions to the Amazon Web Services resources that the workspace
     *         will view data from, including both data sources and notification channels. You are responsible for
     *         managing the permissions for this role as new data sources or notification channels are added.
     */
    public final String workspaceRoleArn() {
        return workspaceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthenticationProviders() ? authenticationProvidersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(grafanaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(networkAccessControl());
        hashCode = 31 * hashCode + Objects.hashCode(organizationRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceDataSources() ? workspaceDataSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasWorkspaceNotificationDestinations() ? workspaceNotificationDestinationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceOrganizationalUnits() ? workspaceOrganizationalUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceRequest)) {
            return false;
        }
        CreateWorkspaceRequest other = (CreateWorkspaceRequest) obj;
        return Objects.equals(accountAccessTypeAsString(), other.accountAccessTypeAsString())
                && hasAuthenticationProviders() == other.hasAuthenticationProviders()
                && Objects.equals(authenticationProvidersAsStrings(), other.authenticationProvidersAsStrings())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(grafanaVersion(), other.grafanaVersion())
                && Objects.equals(networkAccessControl(), other.networkAccessControl())
                && Objects.equals(organizationRoleName(), other.organizationRoleName())
                && Objects.equals(permissionTypeAsString(), other.permissionTypeAsString())
                && Objects.equals(stackSetName(), other.stackSetName())
                && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && hasWorkspaceDataSources() == other.hasWorkspaceDataSources()
                && Objects.equals(workspaceDataSourcesAsStrings(), other.workspaceDataSourcesAsStrings())
                && Objects.equals(workspaceDescription(), other.workspaceDescription())
                && Objects.equals(workspaceName(), other.workspaceName())
                && hasWorkspaceNotificationDestinations() == other.hasWorkspaceNotificationDestinations()
                && Objects.equals(workspaceNotificationDestinationsAsStrings(),
                        other.workspaceNotificationDestinationsAsStrings())
                && hasWorkspaceOrganizationalUnits() == other.hasWorkspaceOrganizationalUnits()
                && Objects.equals(workspaceOrganizationalUnits(), other.workspaceOrganizationalUnits())
                && Objects.equals(workspaceRoleArn(), other.workspaceRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateWorkspaceRequest")
                .add("AccountAccessType", accountAccessTypeAsString())
                .add("AuthenticationProviders", hasAuthenticationProviders() ? authenticationProvidersAsStrings() : null)
                .add("ClientToken", clientToken())
                .add("Configuration", configuration())
                .add("GrafanaVersion", grafanaVersion())
                .add("NetworkAccessControl", networkAccessControl())
                .add("OrganizationRoleName", organizationRoleName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PermissionType", permissionTypeAsString())
                .add("StackSetName", stackSetName())
                .add("Tags", hasTags() ? tags() : null)
                .add("VpcConfiguration", vpcConfiguration())
                .add("WorkspaceDataSources", hasWorkspaceDataSources() ? workspaceDataSourcesAsStrings() : null)
                .add("WorkspaceDescription", workspaceDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WorkspaceName", workspaceName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WorkspaceNotificationDestinations",
                        hasWorkspaceNotificationDestinations() ? workspaceNotificationDestinationsAsStrings() : null)
                .add("WorkspaceOrganizationalUnits",
                        workspaceOrganizationalUnits() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WorkspaceRoleArn", workspaceRoleArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountAccessType":
            return Optional.ofNullable(clazz.cast(accountAccessTypeAsString()));
        case "authenticationProviders":
            return Optional.ofNullable(clazz.cast(authenticationProvidersAsStrings()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "grafanaVersion":
            return Optional.ofNullable(clazz.cast(grafanaVersion()));
        case "networkAccessControl":
            return Optional.ofNullable(clazz.cast(networkAccessControl()));
        case "organizationRoleName":
            return Optional.ofNullable(clazz.cast(organizationRoleName()));
        case "permissionType":
            return Optional.ofNullable(clazz.cast(permissionTypeAsString()));
        case "stackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "workspaceDataSources":
            return Optional.ofNullable(clazz.cast(workspaceDataSourcesAsStrings()));
        case "workspaceDescription":
            return Optional.ofNullable(clazz.cast(workspaceDescription()));
        case "workspaceName":
            return Optional.ofNullable(clazz.cast(workspaceName()));
        case "workspaceNotificationDestinations":
            return Optional.ofNullable(clazz.cast(workspaceNotificationDestinationsAsStrings()));
        case "workspaceOrganizationalUnits":
            return Optional.ofNullable(clazz.cast(workspaceOrganizationalUnits()));
        case "workspaceRoleArn":
            return Optional.ofNullable(clazz.cast(workspaceRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspaceRequest> {
        /**
         * <p>
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account
         * only, or whether it can also access Amazon Web Services resources in other accounts in the same organization.
         * If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can
         * access in the <code>workspaceOrganizationalUnits</code> parameter.
         * </p>
         * 
         * @param accountAccessType
         *        Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services
         *        account only, or whether it can also access Amazon Web Services resources in other accounts in the
         *        same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational
         *        units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.
         * @see AccountAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountAccessType
         */
        Builder accountAccessType(String accountAccessType);

        /**
         * <p>
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account
         * only, or whether it can also access Amazon Web Services resources in other accounts in the same organization.
         * If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can
         * access in the <code>workspaceOrganizationalUnits</code> parameter.
         * </p>
         * 
         * @param accountAccessType
         *        Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services
         *        account only, or whether it can also access Amazon Web Services resources in other accounts in the
         *        same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational
         *        units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.
         * @see AccountAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountAccessType
         */
        Builder accountAccessType(AccountAccessType accountAccessType);

        /**
         * <p>
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using
         * the Grafana console within a workspace. For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
         * Amazon Managed Grafana</a>.
         * </p>
         * 
         * @param authenticationProviders
         *        Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
         *        using the Grafana console within a workspace. For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
         *        authentication in Amazon Managed Grafana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProvidersWithStrings(Collection<String> authenticationProviders);

        /**
         * <p>
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using
         * the Grafana console within a workspace. For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
         * Amazon Managed Grafana</a>.
         * </p>
         * 
         * @param authenticationProviders
         *        Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
         *        using the Grafana console within a workspace. For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
         *        authentication in Amazon Managed Grafana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProvidersWithStrings(String... authenticationProviders);

        /**
         * <p>
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using
         * the Grafana console within a workspace. For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
         * Amazon Managed Grafana</a>.
         * </p>
         * 
         * @param authenticationProviders
         *        Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
         *        using the Grafana console within a workspace. For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
         *        authentication in Amazon Managed Grafana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProviders(Collection<AuthenticationProviderTypes> authenticationProviders);

        /**
         * <p>
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using
         * the Grafana console within a workspace. For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
         * Amazon Managed Grafana</a>.
         * </p>
         * 
         * @param authenticationProviders
         *        Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
         *        using the Grafana console within a workspace. For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
         *        authentication in Amazon Managed Grafana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProviders(AuthenticationProviderTypes... authenticationProviders);

        /**
         * <p>
         * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration string for the workspace that you create. For more information about the format and
         * configuration options available, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html">Working in your
         * Grafana workspace</a>.
         * </p>
         * 
         * @param configuration
         *        The configuration string for the workspace that you create. For more information about the format and
         *        configuration options available, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html">Working in
         *        your Grafana workspace</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(String configuration);

        /**
         * <p>
         * Specifies the version of Grafana to support in the new workspace. If not specified, defaults to the latest
         * version (for example, 9.4).
         * </p>
         * <p>
         * To get a list of supported versions, use the <code>ListVersions</code> operation.
         * </p>
         * 
         * @param grafanaVersion
         *        Specifies the version of Grafana to support in the new workspace. If not specified, defaults to the
         *        latest version (for example, 9.4).</p>
         *        <p>
         *        To get a list of supported versions, use the <code>ListVersions</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grafanaVersion(String grafanaVersion);

        /**
         * <p>
         * Configuration for network access to your workspace.
         * </p>
         * <p>
         * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace.
         * Standard Grafana authentication and authorization will still be required.
         * </p>
         * <p>
         * If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard
         * Grafana authentication and authorization will still be required.
         * </p>
         * 
         * @param networkAccessControl
         *        Configuration for network access to your workspace.</p>
         *        <p>
         *        When this is configured, only listed IP addresses and VPC endpoints will be able to access your
         *        workspace. Standard Grafana authentication and authorization will still be required.
         *        </p>
         *        <p>
         *        If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed.
         *        Standard Grafana authentication and authorization will still be required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAccessControl(NetworkAccessConfiguration networkAccessControl);

        /**
         * <p>
         * Configuration for network access to your workspace.
         * </p>
         * <p>
         * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace.
         * Standard Grafana authentication and authorization will still be required.
         * </p>
         * <p>
         * If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard
         * Grafana authentication and authorization will still be required.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkAccessConfiguration.Builder}
         * avoiding the need to create one manually via {@link NetworkAccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkAccessConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #networkAccessControl(NetworkAccessConfiguration)}.
         * 
         * @param networkAccessControl
         *        a consumer that will call methods on {@link NetworkAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAccessControl(NetworkAccessConfiguration)
         */
        default Builder networkAccessControl(Consumer<NetworkAccessConfiguration.Builder> networkAccessControl) {
            return networkAccessControl(NetworkAccessConfiguration.builder().applyMutation(networkAccessControl).build());
        }

        /**
         * <p>
         * The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data
         * sources and notification channels in other accounts in an organization.
         * </p>
         * 
         * @param organizationRoleName
         *        The name of an IAM role that already exists to use with Organizations to access Amazon Web Services
         *        data sources and notification channels in other accounts in an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationRoleName(String organizationRoleName);

        /**
         * <p>
         * When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation, you
         * must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web Services data
         * sources and notification channels.
         * </p>
         * <p>
         * You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the workspace to
         * use when accessing those datasources and notification channels.
         * </p>
         * <p>
         * The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported only
         * in the Amazon Managed Grafana console, where this value may be set to <code>SERVICE_MANAGED</code>.
         * </p>
         * <note>
         * <p>
         * Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI or
         * Amazon Web Services CloudFormation.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
         * Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>.
         * </p>
         * 
         * @param permissionType
         *        When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services
         *        CloudFormation, you must manage IAM roles and provision the permissions that the workspace needs to
         *        use Amazon Web Services data sources and notification channels.</p>
         *        <p>
         *        You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the
         *        workspace to use when accessing those datasources and notification channels.
         *        </p>
         *        <p>
         *        The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is
         *        supported only in the Amazon Managed Grafana console, where this value may be set to
         *        <code>SERVICE_MANAGED</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI
         *        or Amazon Web Services CloudFormation.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
         *        Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>.
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * <p>
         * When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation, you
         * must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web Services data
         * sources and notification channels.
         * </p>
         * <p>
         * You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the workspace to
         * use when accessing those datasources and notification channels.
         * </p>
         * <p>
         * The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported only
         * in the Amazon Managed Grafana console, where this value may be set to <code>SERVICE_MANAGED</code>.
         * </p>
         * <note>
         * <p>
         * Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI or
         * Amazon Web Services CloudFormation.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
         * Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>.
         * </p>
         * 
         * @param permissionType
         *        When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services
         *        CloudFormation, you must manage IAM roles and provision the permissions that the workspace needs to
         *        use Amazon Web Services data sources and notification channels.</p>
         *        <p>
         *        You must also specify a <code>workspaceRoleArn</code> for a role that you will manage for the
         *        workspace to use when accessing those datasources and notification channels.
         *        </p>
         *        <p>
         *        The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is
         *        supported only in the Amazon Managed Grafana console, where this value may be set to
         *        <code>SERVICE_MANAGED</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Use only the <code>CUSTOMER_MANAGED</code> permission type when creating a workspace with the API, CLI
         *        or Amazon Web Services CloudFormation.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed
         *        Grafana permissions and policies for Amazon Web Services data sources and notification channels</a>.
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(PermissionType permissionType);

        /**
         * <p>
         * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
         * </p>
         * 
         * @param stackSetName
         *        The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * The list of tags associated with the workspace.
         * </p>
         * 
         * @param tags
         *        The list of tags associated with the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect
         * to.
         * </p>
         * <note>
         * <p>
         * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
         * </p>
         * </note>
         * 
         * @param vpcConfiguration
         *        The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to
         *        connect to.</p> <note>
         *        <p>
         *        Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect
         * to.
         * </p>
         * <note>
         * <p>
         * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * This parameter is for internal use only, and should not be used.
         * </p>
         * 
         * @param workspaceDataSources
         *        This parameter is for internal use only, and should not be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDataSourcesWithStrings(Collection<String> workspaceDataSources);

        /**
         * <p>
         * This parameter is for internal use only, and should not be used.
         * </p>
         * 
         * @param workspaceDataSources
         *        This parameter is for internal use only, and should not be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDataSourcesWithStrings(String... workspaceDataSources);

        /**
         * <p>
         * This parameter is for internal use only, and should not be used.
         * </p>
         * 
         * @param workspaceDataSources
         *        This parameter is for internal use only, and should not be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDataSources(Collection<DataSourceType> workspaceDataSources);

        /**
         * <p>
         * This parameter is for internal use only, and should not be used.
         * </p>
         * 
         * @param workspaceDataSources
         *        This parameter is for internal use only, and should not be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDataSources(DataSourceType... workspaceDataSources);

        /**
         * <p>
         * A description for the workspace. This is used only to help you identify this workspace.
         * </p>
         * <p>
         * Pattern: <code>^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$</code>
         * </p>
         * 
         * @param workspaceDescription
         *        A description for the workspace. This is used only to help you identify this workspace.</p>
         *        <p>
         *        Pattern: <code>^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceDescription(String workspaceDescription);

        /**
         * <p>
         * The name for the workspace. It does not have to be unique.
         * </p>
         * 
         * @param workspaceName
         *        The name for the workspace. It does not have to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceName(String workspaceName);

        /**
         * <p>
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
         * these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to use these channels.
         * </p>
         * 
         * @param workspaceNotificationDestinations
         *        Specify the Amazon Web Services notification channels that you plan to use in this workspace.
         *        Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions
         *        that allow Amazon Managed Grafana to use these channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceNotificationDestinationsWithStrings(Collection<String> workspaceNotificationDestinations);

        /**
         * <p>
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
         * these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to use these channels.
         * </p>
         * 
         * @param workspaceNotificationDestinations
         *        Specify the Amazon Web Services notification channels that you plan to use in this workspace.
         *        Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions
         *        that allow Amazon Managed Grafana to use these channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceNotificationDestinationsWithStrings(String... workspaceNotificationDestinations);

        /**
         * <p>
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
         * these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to use these channels.
         * </p>
         * 
         * @param workspaceNotificationDestinations
         *        Specify the Amazon Web Services notification channels that you plan to use in this workspace.
         *        Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions
         *        that allow Amazon Managed Grafana to use these channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceNotificationDestinations(Collection<NotificationDestinationType> workspaceNotificationDestinations);

        /**
         * <p>
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying
         * these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon
         * Managed Grafana to use these channels.
         * </p>
         * 
         * @param workspaceNotificationDestinations
         *        Specify the Amazon Web Services notification channels that you plan to use in this workspace.
         *        Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions
         *        that allow Amazon Managed Grafana to use these channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceNotificationDestinations(NotificationDestinationType... workspaceNotificationDestinations);

        /**
         * <p>
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace
         * is in an account that is part of an organization.
         * </p>
         * 
         * @param workspaceOrganizationalUnits
         *        Specifies the organizational units that this workspace is allowed to use data sources from, if this
         *        workspace is in an account that is part of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits);

        /**
         * <p>
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace
         * is in an account that is part of an organization.
         * </p>
         * 
         * @param workspaceOrganizationalUnits
         *        Specifies the organizational units that this workspace is allowed to use data sources from, if this
         *        workspace is in an account that is part of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceOrganizationalUnits(String... workspaceOrganizationalUnits);

        /**
         * <p>
         * Specified the IAM role that grants permissions to the Amazon Web Services resources that the workspace will
         * view data from, including both data sources and notification channels. You are responsible for managing the
         * permissions for this role as new data sources or notification channels are added.
         * </p>
         * 
         * @param workspaceRoleArn
         *        Specified the IAM role that grants permissions to the Amazon Web Services resources that the workspace
         *        will view data from, including both data sources and notification channels. You are responsible for
         *        managing the permissions for this role as new data sources or notification channels are added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceRoleArn(String workspaceRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private String accountAccessType;

        private List<String> authenticationProviders = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private String configuration;

        private String grafanaVersion;

        private NetworkAccessConfiguration networkAccessControl;

        private String organizationRoleName;

        private String permissionType;

        private String stackSetName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private VpcConfiguration vpcConfiguration;

        private List<String> workspaceDataSources = DefaultSdkAutoConstructList.getInstance();

        private String workspaceDescription;

        private String workspaceName;

        private List<String> workspaceNotificationDestinations = DefaultSdkAutoConstructList.getInstance();

        private List<String> workspaceOrganizationalUnits = DefaultSdkAutoConstructList.getInstance();

        private String workspaceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceRequest model) {
            super(model);
            accountAccessType(model.accountAccessType);
            authenticationProvidersWithStrings(model.authenticationProviders);
            clientToken(model.clientToken);
            configuration(model.configuration);
            grafanaVersion(model.grafanaVersion);
            networkAccessControl(model.networkAccessControl);
            organizationRoleName(model.organizationRoleName);
            permissionType(model.permissionType);
            stackSetName(model.stackSetName);
            tags(model.tags);
            vpcConfiguration(model.vpcConfiguration);
            workspaceDataSourcesWithStrings(model.workspaceDataSources);
            workspaceDescription(model.workspaceDescription);
            workspaceName(model.workspaceName);
            workspaceNotificationDestinationsWithStrings(model.workspaceNotificationDestinations);
            workspaceOrganizationalUnits(model.workspaceOrganizationalUnits);
            workspaceRoleArn(model.workspaceRoleArn);
        }

        public final String getAccountAccessType() {
            return accountAccessType;
        }

        public final void setAccountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
        }

        @Override
        public final Builder accountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
            return this;
        }

        @Override
        public final Builder accountAccessType(AccountAccessType accountAccessType) {
            this.accountAccessType(accountAccessType == null ? null : accountAccessType.toString());
            return this;
        }

        public final Collection<String> getAuthenticationProviders() {
            if (authenticationProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return authenticationProviders;
        }

        public final void setAuthenticationProviders(Collection<String> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copy(authenticationProviders);
        }

        @Override
        public final Builder authenticationProvidersWithStrings(Collection<String> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copy(authenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProvidersWithStrings(String... authenticationProviders) {
            authenticationProvidersWithStrings(Arrays.asList(authenticationProviders));
            return this;
        }

        @Override
        public final Builder authenticationProviders(Collection<AuthenticationProviderTypes> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copyEnumToString(authenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProviders(AuthenticationProviderTypes... authenticationProviders) {
            authenticationProviders(Arrays.asList(authenticationProviders));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getGrafanaVersion() {
            return grafanaVersion;
        }

        public final void setGrafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
        }

        @Override
        public final Builder grafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
            return this;
        }

        public final NetworkAccessConfiguration.Builder getNetworkAccessControl() {
            return networkAccessControl != null ? networkAccessControl.toBuilder() : null;
        }

        public final void setNetworkAccessControl(NetworkAccessConfiguration.BuilderImpl networkAccessControl) {
            this.networkAccessControl = networkAccessControl != null ? networkAccessControl.build() : null;
        }

        @Override
        public final Builder networkAccessControl(NetworkAccessConfiguration networkAccessControl) {
            this.networkAccessControl = networkAccessControl;
            return this;
        }

        public final String getOrganizationRoleName() {
            return organizationRoleName;
        }

        public final void setOrganizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
        }

        @Override
        public final Builder organizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
            return this;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final Collection<String> getWorkspaceDataSources() {
            if (workspaceDataSources instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceDataSources;
        }

        public final void setWorkspaceDataSources(Collection<String> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copy(workspaceDataSources);
        }

        @Override
        public final Builder workspaceDataSourcesWithStrings(Collection<String> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copy(workspaceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDataSourcesWithStrings(String... workspaceDataSources) {
            workspaceDataSourcesWithStrings(Arrays.asList(workspaceDataSources));
            return this;
        }

        @Override
        public final Builder workspaceDataSources(Collection<DataSourceType> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copyEnumToString(workspaceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDataSources(DataSourceType... workspaceDataSources) {
            workspaceDataSources(Arrays.asList(workspaceDataSources));
            return this;
        }

        public final String getWorkspaceDescription() {
            return workspaceDescription;
        }

        public final void setWorkspaceDescription(String workspaceDescription) {
            this.workspaceDescription = workspaceDescription;
        }

        @Override
        public final Builder workspaceDescription(String workspaceDescription) {
            this.workspaceDescription = workspaceDescription;
            return this;
        }

        public final String getWorkspaceName() {
            return workspaceName;
        }

        public final void setWorkspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        @Override
        public final Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        public final Collection<String> getWorkspaceNotificationDestinations() {
            if (workspaceNotificationDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceNotificationDestinations;
        }

        public final void setWorkspaceNotificationDestinations(Collection<String> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copy(workspaceNotificationDestinations);
        }

        @Override
        public final Builder workspaceNotificationDestinationsWithStrings(Collection<String> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copy(workspaceNotificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceNotificationDestinationsWithStrings(String... workspaceNotificationDestinations) {
            workspaceNotificationDestinationsWithStrings(Arrays.asList(workspaceNotificationDestinations));
            return this;
        }

        @Override
        public final Builder workspaceNotificationDestinations(
                Collection<NotificationDestinationType> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier
                    .copyEnumToString(workspaceNotificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceNotificationDestinations(NotificationDestinationType... workspaceNotificationDestinations) {
            workspaceNotificationDestinations(Arrays.asList(workspaceNotificationDestinations));
            return this;
        }

        public final Collection<String> getWorkspaceOrganizationalUnits() {
            if (workspaceOrganizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return workspaceOrganizationalUnits;
        }

        public final void setWorkspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits = OrganizationalUnitListCopier.copy(workspaceOrganizationalUnits);
        }

        @Override
        public final Builder workspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits = OrganizationalUnitListCopier.copy(workspaceOrganizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceOrganizationalUnits(String... workspaceOrganizationalUnits) {
            workspaceOrganizationalUnits(Arrays.asList(workspaceOrganizationalUnits));
            return this;
        }

        public final String getWorkspaceRoleArn() {
            return workspaceRoleArn;
        }

        public final void setWorkspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
        }

        @Override
        public final Builder workspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceRequest build() {
            return new CreateWorkspaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
