/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspaceAuthenticationRequest extends GrafanaRequest implements
        ToCopyableBuilder<UpdateWorkspaceAuthenticationRequest.Builder, UpdateWorkspaceAuthenticationRequest> {
    private static final SdkField<List<String>> AUTHENTICATION_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("authenticationProviders")
            .getter(getter(UpdateWorkspaceAuthenticationRequest::authenticationProvidersAsStrings))
            .setter(setter(Builder::authenticationProvidersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SamlConfiguration> SAML_CONFIGURATION_FIELD = SdkField
            .<SamlConfiguration> builder(MarshallingType.SDK_POJO).memberName("samlConfiguration")
            .getter(getter(UpdateWorkspaceAuthenticationRequest::samlConfiguration)).setter(setter(Builder::samlConfiguration))
            .constructor(SamlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlConfiguration").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdateWorkspaceAuthenticationRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHENTICATION_PROVIDERS_FIELD, SAML_CONFIGURATION_FIELD, WORKSPACE_ID_FIELD));

    private final List<String> authenticationProviders;

    private final SamlConfiguration samlConfiguration;

    private final String workspaceId;

    private UpdateWorkspaceAuthenticationRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationProviders = builder.authenticationProviders;
        this.samlConfiguration = builder.samlConfiguration;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using the
     * Grafana console within a workspace. For more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
     * Amazon Managed Grafana</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationProviders} method.
     * </p>
     * 
     * @return Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
     *         using the Grafana console within a workspace. For more information, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
     *         authentication in Amazon Managed Grafana</a>.
     */
    public final List<AuthenticationProviderTypes> authenticationProviders() {
        return AuthenticationProvidersCopier.copyStringToEnum(authenticationProviders);
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthenticationProviders property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthenticationProviders() {
        return authenticationProviders != null && !(authenticationProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using the
     * Grafana console within a workspace. For more information, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
     * Amazon Managed Grafana</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationProviders} method.
     * </p>
     * 
     * @return Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
     *         using the Grafana console within a workspace. For more information, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
     *         authentication in Amazon Managed Grafana</a>.
     */
    public final List<String> authenticationProvidersAsStrings() {
        return authenticationProviders;
    }

    /**
     * <p>
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and
     * define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles
     * in the workspace.
     * </p>
     * 
     * @return If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user
     *         information and define which groups in the assertion attribute are to have the <code>Admin</code> and
     *         <code>Editor</code> roles in the workspace.
     */
    public final SamlConfiguration samlConfiguration() {
        return samlConfiguration;
    }

    /**
     * <p>
     * The ID of the workspace to update the authentication for.
     * </p>
     * 
     * @return The ID of the workspace to update the authentication for.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthenticationProviders() ? authenticationProvidersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(samlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceAuthenticationRequest)) {
            return false;
        }
        UpdateWorkspaceAuthenticationRequest other = (UpdateWorkspaceAuthenticationRequest) obj;
        return hasAuthenticationProviders() == other.hasAuthenticationProviders()
                && Objects.equals(authenticationProvidersAsStrings(), other.authenticationProvidersAsStrings())
                && Objects.equals(samlConfiguration(), other.samlConfiguration())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspaceAuthenticationRequest")
                .add("AuthenticationProviders", hasAuthenticationProviders() ? authenticationProvidersAsStrings() : null)
                .add("SamlConfiguration", samlConfiguration()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationProviders":
            return Optional.ofNullable(clazz.cast(authenticationProvidersAsStrings()));
        case "samlConfiguration":
            return Optional.ofNullable(clazz.cast(samlConfiguration()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceAuthenticationRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceAuthenticationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWorkspaceAuthenticationRequest> {
        /**
         * <p>
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using
         * the Grafana console within a workspace. For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
         * Amazon Managed Grafana</a>.
         * </p>
         * 
         * @param authenticationProviders
         *        Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
         *        using the Grafana console within a workspace. For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
         *        authentication in Amazon Managed Grafana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProvidersWithStrings(Collection<String> authenticationProviders);

        /**
         * <p>
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using
         * the Grafana console within a workspace. For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
         * Amazon Managed Grafana</a>.
         * </p>
         * 
         * @param authenticationProviders
         *        Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
         *        using the Grafana console within a workspace. For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
         *        authentication in Amazon Managed Grafana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProvidersWithStrings(String... authenticationProviders);

        /**
         * <p>
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using
         * the Grafana console within a workspace. For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
         * Amazon Managed Grafana</a>.
         * </p>
         * 
         * @param authenticationProviders
         *        Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
         *        using the Grafana console within a workspace. For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
         *        authentication in Amazon Managed Grafana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProviders(Collection<AuthenticationProviderTypes> authenticationProviders);

        /**
         * <p>
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using
         * the Grafana console within a workspace. For more information, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
         * Amazon Managed Grafana</a>.
         * </p>
         * 
         * @param authenticationProviders
         *        Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for
         *        using the Grafana console within a workspace. For more information, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User
         *        authentication in Amazon Managed Grafana</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProviders(AuthenticationProviderTypes... authenticationProviders);

        /**
         * <p>
         * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information
         * and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code>
         * roles in the workspace.
         * </p>
         * 
         * @param samlConfiguration
         *        If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user
         *        information and define which groups in the assertion attribute are to have the <code>Admin</code> and
         *        <code>Editor</code> roles in the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlConfiguration(SamlConfiguration samlConfiguration);

        /**
         * <p>
         * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information
         * and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code>
         * roles in the workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link SamlConfiguration.Builder} avoiding the
         * need to create one manually via {@link SamlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #samlConfiguration(SamlConfiguration)}.
         * 
         * @param samlConfiguration
         *        a consumer that will call methods on {@link SamlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlConfiguration(SamlConfiguration)
         */
        default Builder samlConfiguration(Consumer<SamlConfiguration.Builder> samlConfiguration) {
            return samlConfiguration(SamlConfiguration.builder().applyMutation(samlConfiguration).build());
        }

        /**
         * <p>
         * The ID of the workspace to update the authentication for.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace to update the authentication for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private List<String> authenticationProviders = DefaultSdkAutoConstructList.getInstance();

        private SamlConfiguration samlConfiguration;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceAuthenticationRequest model) {
            super(model);
            authenticationProvidersWithStrings(model.authenticationProviders);
            samlConfiguration(model.samlConfiguration);
            workspaceId(model.workspaceId);
        }

        public final Collection<String> getAuthenticationProviders() {
            if (authenticationProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return authenticationProviders;
        }

        public final void setAuthenticationProviders(Collection<String> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copy(authenticationProviders);
        }

        @Override
        public final Builder authenticationProvidersWithStrings(Collection<String> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copy(authenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProvidersWithStrings(String... authenticationProviders) {
            authenticationProvidersWithStrings(Arrays.asList(authenticationProviders));
            return this;
        }

        @Override
        public final Builder authenticationProviders(Collection<AuthenticationProviderTypes> authenticationProviders) {
            this.authenticationProviders = AuthenticationProvidersCopier.copyEnumToString(authenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProviders(AuthenticationProviderTypes... authenticationProviders) {
            authenticationProviders(Arrays.asList(authenticationProviders));
            return this;
        }

        public final SamlConfiguration.Builder getSamlConfiguration() {
            return samlConfiguration != null ? samlConfiguration.toBuilder() : null;
        }

        public final void setSamlConfiguration(SamlConfiguration.BuilderImpl samlConfiguration) {
            this.samlConfiguration = samlConfiguration != null ? samlConfiguration.build() : null;
        }

        @Override
        public final Builder samlConfiguration(SamlConfiguration samlConfiguration) {
            this.samlConfiguration = samlConfiguration;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceAuthenticationRequest build() {
            return new UpdateWorkspaceAuthenticationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
