/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkspaceServiceAccountsResponse extends GrafanaResponse implements
        ToCopyableBuilder<ListWorkspaceServiceAccountsResponse.Builder, ListWorkspaceServiceAccountsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkspaceServiceAccountsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ServiceAccountSummary>> SERVICE_ACCOUNTS_FIELD = SdkField
            .<List<ServiceAccountSummary>> builder(MarshallingType.LIST)
            .memberName("serviceAccounts")
            .getter(getter(ListWorkspaceServiceAccountsResponse::serviceAccounts))
            .setter(setter(Builder::serviceAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceAccountSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceAccountSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(ListWorkspaceServiceAccountsResponse::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVICE_ACCOUNTS_FIELD, WORKSPACE_ID_FIELD));

    private final String nextToken;

    private final List<ServiceAccountSummary> serviceAccounts;

    private final String workspaceId;

    private ListWorkspaceServiceAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceAccounts = builder.serviceAccounts;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The token to use when requesting the next set of service accounts.
     * </p>
     * 
     * @return The token to use when requesting the next set of service accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceAccounts() {
        return serviceAccounts != null && !(serviceAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures containing information about the service accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceAccounts} method.
     * </p>
     * 
     * @return An array of structures containing information about the service accounts.
     */
    public final List<ServiceAccountSummary> serviceAccounts() {
        return serviceAccounts;
    }

    /**
     * <p>
     * The workspace to which the service accounts are associated.
     * </p>
     * 
     * @return The workspace to which the service accounts are associated.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceAccounts() ? serviceAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspaceServiceAccountsResponse)) {
            return false;
        }
        ListWorkspaceServiceAccountsResponse other = (ListWorkspaceServiceAccountsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasServiceAccounts() == other.hasServiceAccounts()
                && Objects.equals(serviceAccounts(), other.serviceAccounts())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkspaceServiceAccountsResponse").add("NextToken", nextToken())
                .add("ServiceAccounts", hasServiceAccounts() ? serviceAccounts() : null).add("WorkspaceId", workspaceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serviceAccounts":
            return Optional.ofNullable(clazz.cast(serviceAccounts()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspaceServiceAccountsResponse, T> g) {
        return obj -> g.apply((ListWorkspaceServiceAccountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkspaceServiceAccountsResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of service accounts.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of service accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of structures containing information about the service accounts.
         * </p>
         * 
         * @param serviceAccounts
         *        An array of structures containing information about the service accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccounts(Collection<ServiceAccountSummary> serviceAccounts);

        /**
         * <p>
         * An array of structures containing information about the service accounts.
         * </p>
         * 
         * @param serviceAccounts
         *        An array of structures containing information about the service accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccounts(ServiceAccountSummary... serviceAccounts);

        /**
         * <p>
         * An array of structures containing information about the service accounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.grafana.model.ServiceAccountSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.grafana.model.ServiceAccountSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.grafana.model.ServiceAccountSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceAccounts(List<ServiceAccountSummary>)}.
         * 
         * @param serviceAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.grafana.model.ServiceAccountSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAccounts(java.util.Collection<ServiceAccountSummary>)
         */
        Builder serviceAccounts(Consumer<ServiceAccountSummary.Builder>... serviceAccounts);

        /**
         * <p>
         * The workspace to which the service accounts are associated.
         * </p>
         * 
         * @param workspaceId
         *        The workspace to which the service accounts are associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl extends GrafanaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ServiceAccountSummary> serviceAccounts = DefaultSdkAutoConstructList.getInstance();

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspaceServiceAccountsResponse model) {
            super(model);
            nextToken(model.nextToken);
            serviceAccounts(model.serviceAccounts);
            workspaceId(model.workspaceId);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceAccountSummary.Builder> getServiceAccounts() {
            List<ServiceAccountSummary.Builder> result = ServiceAccountListCopier.copyToBuilder(this.serviceAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceAccounts(Collection<ServiceAccountSummary.BuilderImpl> serviceAccounts) {
            this.serviceAccounts = ServiceAccountListCopier.copyFromBuilder(serviceAccounts);
        }

        @Override
        public final Builder serviceAccounts(Collection<ServiceAccountSummary> serviceAccounts) {
            this.serviceAccounts = ServiceAccountListCopier.copy(serviceAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceAccounts(ServiceAccountSummary... serviceAccounts) {
            serviceAccounts(Arrays.asList(serviceAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceAccounts(Consumer<ServiceAccountSummary.Builder>... serviceAccounts) {
            serviceAccounts(Stream.of(serviceAccounts).map(c -> ServiceAccountSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public ListWorkspaceServiceAccountsResponse build() {
            return new ListWorkspaceServiceAccountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
