/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceServiceAccountTokenResponse extends GrafanaResponse implements
        ToCopyableBuilder<CreateWorkspaceServiceAccountTokenResponse.Builder, CreateWorkspaceServiceAccountTokenResponse> {
    private static final SdkField<String> SERVICE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccountId").getter(getter(CreateWorkspaceServiceAccountTokenResponse::serviceAccountId))
            .setter(setter(Builder::serviceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountId").build()).build();

    private static final SdkField<ServiceAccountTokenSummaryWithKey> SERVICE_ACCOUNT_TOKEN_FIELD = SdkField
            .<ServiceAccountTokenSummaryWithKey> builder(MarshallingType.SDK_POJO).memberName("serviceAccountToken")
            .getter(getter(CreateWorkspaceServiceAccountTokenResponse::serviceAccountToken))
            .setter(setter(Builder::serviceAccountToken)).constructor(ServiceAccountTokenSummaryWithKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountToken").build())
            .build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateWorkspaceServiceAccountTokenResponse::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_ID_FIELD,
            SERVICE_ACCOUNT_TOKEN_FIELD, WORKSPACE_ID_FIELD));

    private final String serviceAccountId;

    private final ServiceAccountTokenSummaryWithKey serviceAccountToken;

    private final String workspaceId;

    private CreateWorkspaceServiceAccountTokenResponse(BuilderImpl builder) {
        super(builder);
        this.serviceAccountId = builder.serviceAccountId;
        this.serviceAccountToken = builder.serviceAccountToken;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The ID of the service account where the token was created.
     * </p>
     * 
     * @return The ID of the service account where the token was created.
     */
    public final String serviceAccountId() {
        return serviceAccountId;
    }

    /**
     * <p>
     * Information about the created token, including the key. Be sure to store the key securely.
     * </p>
     * 
     * @return Information about the created token, including the key. Be sure to store the key securely.
     */
    public final ServiceAccountTokenSummaryWithKey serviceAccountToken() {
        return serviceAccountToken;
    }

    /**
     * <p>
     * The ID of the workspace where the token was created.
     * </p>
     * 
     * @return The ID of the workspace where the token was created.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountToken());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceServiceAccountTokenResponse)) {
            return false;
        }
        CreateWorkspaceServiceAccountTokenResponse other = (CreateWorkspaceServiceAccountTokenResponse) obj;
        return Objects.equals(serviceAccountId(), other.serviceAccountId())
                && Objects.equals(serviceAccountToken(), other.serviceAccountToken())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceServiceAccountTokenResponse").add("ServiceAccountId", serviceAccountId())
                .add("ServiceAccountToken", serviceAccountToken()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceAccountId":
            return Optional.ofNullable(clazz.cast(serviceAccountId()));
        case "serviceAccountToken":
            return Optional.ofNullable(clazz.cast(serviceAccountToken()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceServiceAccountTokenResponse, T> g) {
        return obj -> g.apply((CreateWorkspaceServiceAccountTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkspaceServiceAccountTokenResponse> {
        /**
         * <p>
         * The ID of the service account where the token was created.
         * </p>
         * 
         * @param serviceAccountId
         *        The ID of the service account where the token was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountId(String serviceAccountId);

        /**
         * <p>
         * Information about the created token, including the key. Be sure to store the key securely.
         * </p>
         * 
         * @param serviceAccountToken
         *        Information about the created token, including the key. Be sure to store the key securely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountToken(ServiceAccountTokenSummaryWithKey serviceAccountToken);

        /**
         * <p>
         * Information about the created token, including the key. Be sure to store the key securely.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceAccountTokenSummaryWithKey.Builder} avoiding the need to create one manually via
         * {@link ServiceAccountTokenSummaryWithKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceAccountTokenSummaryWithKey.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceAccountToken(ServiceAccountTokenSummaryWithKey)}.
         * 
         * @param serviceAccountToken
         *        a consumer that will call methods on {@link ServiceAccountTokenSummaryWithKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAccountToken(ServiceAccountTokenSummaryWithKey)
         */
        default Builder serviceAccountToken(Consumer<ServiceAccountTokenSummaryWithKey.Builder> serviceAccountToken) {
            return serviceAccountToken(ServiceAccountTokenSummaryWithKey.builder().applyMutation(serviceAccountToken).build());
        }

        /**
         * <p>
         * The ID of the workspace where the token was created.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace where the token was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl extends GrafanaResponse.BuilderImpl implements Builder {
        private String serviceAccountId;

        private ServiceAccountTokenSummaryWithKey serviceAccountToken;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceServiceAccountTokenResponse model) {
            super(model);
            serviceAccountId(model.serviceAccountId);
            serviceAccountToken(model.serviceAccountToken);
            workspaceId(model.workspaceId);
        }

        public final String getServiceAccountId() {
            return serviceAccountId;
        }

        public final void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        @Override
        public final Builder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public final ServiceAccountTokenSummaryWithKey.Builder getServiceAccountToken() {
            return serviceAccountToken != null ? serviceAccountToken.toBuilder() : null;
        }

        public final void setServiceAccountToken(ServiceAccountTokenSummaryWithKey.BuilderImpl serviceAccountToken) {
            this.serviceAccountToken = serviceAccountToken != null ? serviceAccountToken.build() : null;
        }

        @Override
        public final Builder serviceAccountToken(ServiceAccountTokenSummaryWithKey serviceAccountToken) {
            this.serviceAccountToken = serviceAccountToken;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public CreateWorkspaceServiceAccountTokenResponse build() {
            return new CreateWorkspaceServiceAccountTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
