/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the information about a service account token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceAccountTokenSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceAccountTokenSummary.Builder, ServiceAccountTokenSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ServiceAccountTokenSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt").getter(getter(ServiceAccountTokenSummary::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ServiceAccountTokenSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_USED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUsedAt").getter(getter(ServiceAccountTokenSummary::lastUsedAt)).setter(setter(Builder::lastUsedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUsedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServiceAccountTokenSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            EXPIRES_AT_FIELD, ID_FIELD, LAST_USED_AT_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Instant expiresAt;

    private final String id;

    private final Instant lastUsedAt;

    private final String name;

    private ServiceAccountTokenSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.id = builder.id;
        this.lastUsedAt = builder.lastUsedAt;
        this.name = builder.name;
    }

    /**
     * <p>
     * When the service account token was created.
     * </p>
     * 
     * @return When the service account token was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * When the service account token will expire.
     * </p>
     * 
     * @return When the service account token will expire.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * The unique ID of the service account token.
     * </p>
     * 
     * @return The unique ID of the service account token.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The last time the token was used to authorize a Grafana HTTP API.
     * </p>
     * 
     * @return The last time the token was used to authorize a Grafana HTTP API.
     */
    public final Instant lastUsedAt() {
        return lastUsedAt;
    }

    /**
     * <p>
     * The name of the service account token.
     * </p>
     * 
     * @return The name of the service account token.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUsedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAccountTokenSummary)) {
            return false;
        }
        ServiceAccountTokenSummary other = (ServiceAccountTokenSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(expiresAt(), other.expiresAt())
                && Objects.equals(id(), other.id()) && Objects.equals(lastUsedAt(), other.lastUsedAt())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceAccountTokenSummary").add("CreatedAt", createdAt()).add("ExpiresAt", expiresAt())
                .add("Id", id()).add("LastUsedAt", lastUsedAt()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUsedAt":
            return Optional.ofNullable(clazz.cast(lastUsedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceAccountTokenSummary, T> g) {
        return obj -> g.apply((ServiceAccountTokenSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceAccountTokenSummary> {
        /**
         * <p>
         * When the service account token was created.
         * </p>
         * 
         * @param createdAt
         *        When the service account token was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * When the service account token will expire.
         * </p>
         * 
         * @param expiresAt
         *        When the service account token will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * The unique ID of the service account token.
         * </p>
         * 
         * @param id
         *        The unique ID of the service account token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The last time the token was used to authorize a Grafana HTTP API.
         * </p>
         * 
         * @param lastUsedAt
         *        The last time the token was used to authorize a Grafana HTTP API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUsedAt(Instant lastUsedAt);

        /**
         * <p>
         * The name of the service account token.
         * </p>
         * 
         * @param name
         *        The name of the service account token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Instant expiresAt;

        private String id;

        private Instant lastUsedAt;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAccountTokenSummary model) {
            createdAt(model.createdAt);
            expiresAt(model.expiresAt);
            id(model.id);
            lastUsedAt(model.lastUsedAt);
            name(model.name);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUsedAt() {
            return lastUsedAt;
        }

        public final void setLastUsedAt(Instant lastUsedAt) {
            this.lastUsedAt = lastUsedAt;
        }

        @Override
        public final Builder lastUsedAt(Instant lastUsedAt) {
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ServiceAccountTokenSummary build() {
            return new ServiceAccountTokenSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
