/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines which attributes in the IdP assertion are to be used to define information about the users
 * authenticated by the IdP to use the workspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssertionAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<AssertionAttributes.Builder, AssertionAttributes> {
    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(AssertionAttributes::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> GROUPS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("groups")
            .getter(getter(AssertionAttributes::groups)).setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build()).build();

    private static final SdkField<String> LOGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("login")
            .getter(getter(AssertionAttributes::login)).setter(setter(Builder::login))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("login").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssertionAttributes::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ORG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("org")
            .getter(getter(AssertionAttributes::org)).setter(setter(Builder::org))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("org").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("role")
            .getter(getter(AssertionAttributes::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, GROUPS_FIELD,
            LOGIN_FIELD, NAME_FIELD, ORG_FIELD, ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String email;

    private final String groups;

    private final String login;

    private final String name;

    private final String org;

    private final String role;

    private AssertionAttributes(BuilderImpl builder) {
        this.email = builder.email;
        this.groups = builder.groups;
        this.login = builder.login;
        this.name = builder.name;
        this.org = builder.org;
        this.role = builder.role;
    }

    /**
     * <p>
     * The name of the attribute within the SAML assertion to use as the email names for SAML users.
     * </p>
     * 
     * @return The name of the attribute within the SAML assertion to use as the email names for SAML users.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.
     * </p>
     * 
     * @return The name of the attribute within the SAML assertion to use as the user full "friendly" names for user
     *         groups.
     */
    public final String groups() {
        return groups;
    }

    /**
     * <p>
     * The name of the attribute within the SAML assertion to use as the login names for SAML users.
     * </p>
     * 
     * @return The name of the attribute within the SAML assertion to use as the login names for SAML users.
     */
    public final String login() {
        return login;
    }

    /**
     * <p>
     * The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.
     * </p>
     * 
     * @return The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML
     *         users.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users'
     * organizations.
     * </p>
     * 
     * @return The name of the attribute within the SAML assertion to use as the user full "friendly" names for the
     *         users' organizations.
     */
    public final String org() {
        return org;
    }

    /**
     * <p>
     * The name of the attribute within the SAML assertion to use as the user roles.
     * </p>
     * 
     * @return The name of the attribute within the SAML assertion to use as the user roles.
     */
    public final String role() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(login());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(org());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssertionAttributes)) {
            return false;
        }
        AssertionAttributes other = (AssertionAttributes) obj;
        return Objects.equals(email(), other.email()) && Objects.equals(groups(), other.groups())
                && Objects.equals(login(), other.login()) && Objects.equals(name(), other.name())
                && Objects.equals(org(), other.org()) && Objects.equals(role(), other.role());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssertionAttributes").add("Email", email()).add("Groups", groups()).add("Login", login())
                .add("Name", name()).add("Org", org()).add("Role", role()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "login":
            return Optional.ofNullable(clazz.cast(login()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "org":
            return Optional.ofNullable(clazz.cast(org()));
        case "role":
            return Optional.ofNullable(clazz.cast(role()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("email", EMAIL_FIELD);
        map.put("groups", GROUPS_FIELD);
        map.put("login", LOGIN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("org", ORG_FIELD);
        map.put("role", ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssertionAttributes, T> g) {
        return obj -> g.apply((AssertionAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssertionAttributes> {
        /**
         * <p>
         * The name of the attribute within the SAML assertion to use as the email names for SAML users.
         * </p>
         * 
         * @param email
         *        The name of the attribute within the SAML assertion to use as the email names for SAML users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.
         * </p>
         * 
         * @param groups
         *        The name of the attribute within the SAML assertion to use as the user full "friendly" names for user
         *        groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String groups);

        /**
         * <p>
         * The name of the attribute within the SAML assertion to use as the login names for SAML users.
         * </p>
         * 
         * @param login
         *        The name of the attribute within the SAML assertion to use as the login names for SAML users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder login(String login);

        /**
         * <p>
         * The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.
         * </p>
         * 
         * @param name
         *        The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users'
         * organizations.
         * </p>
         * 
         * @param org
         *        The name of the attribute within the SAML assertion to use as the user full "friendly" names for the
         *        users' organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder org(String org);

        /**
         * <p>
         * The name of the attribute within the SAML assertion to use as the user roles.
         * </p>
         * 
         * @param role
         *        The name of the attribute within the SAML assertion to use as the user roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);
    }

    static final class BuilderImpl implements Builder {
        private String email;

        private String groups;

        private String login;

        private String name;

        private String org;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(AssertionAttributes model) {
            email(model.email);
            groups(model.groups);
            login(model.login);
            name(model.name);
            org(model.org);
            role(model.role);
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getGroups() {
            return groups;
        }

        public final void setGroups(String groups) {
            this.groups = groups;
        }

        @Override
        public final Builder groups(String groups) {
            this.groups = groups;
            return this;
        }

        public final String getLogin() {
            return login;
        }

        public final void setLogin(String login) {
            this.login = login;
        }

        @Override
        public final Builder login(String login) {
            this.login = login;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOrg() {
            return org;
        }

        public final void setOrg(String org) {
            this.org = org;
        }

        @Override
        public final Builder org(String org) {
            this.org = org;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public AssertionAttributes build() {
            return new AssertionAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
