/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing information about the user authentication methods used by the workspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationDescription.Builder, AuthenticationDescription> {
    private static final SdkField<AwsSsoAuthentication> AWS_SSO_FIELD = SdkField
            .<AwsSsoAuthentication> builder(MarshallingType.SDK_POJO).memberName("awsSso")
            .getter(getter(AuthenticationDescription::awsSso)).setter(setter(Builder::awsSso))
            .constructor(AwsSsoAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSso").build()).build();

    private static final SdkField<List<String>> PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("providers")
            .getter(getter(AuthenticationDescription::providersAsStrings))
            .setter(setter(Builder::providersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SamlAuthentication> SAML_FIELD = SdkField
            .<SamlAuthentication> builder(MarshallingType.SDK_POJO).memberName("saml")
            .getter(getter(AuthenticationDescription::saml)).setter(setter(Builder::saml))
            .constructor(SamlAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("saml").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SSO_FIELD,
            PROVIDERS_FIELD, SAML_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsSsoAuthentication awsSso;

    private final List<String> providers;

    private final SamlAuthentication saml;

    private AuthenticationDescription(BuilderImpl builder) {
        this.awsSso = builder.awsSso;
        this.providers = builder.providers;
        this.saml = builder.saml;
    }

    /**
     * <p>
     * A structure containing information about how this workspace works with IAM Identity Center.
     * </p>
     * 
     * @return A structure containing information about how this workspace works with IAM Identity Center.
     */
    public final AwsSsoAuthentication awsSso() {
        return awsSso;
    }

    /**
     * <p>
     * Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to use the
     * Grafana console in the Amazon Managed Grafana workspace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviders} method.
     * </p>
     * 
     * @return Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to
     *         use the Grafana console in the Amazon Managed Grafana workspace.
     */
    public final List<AuthenticationProviderTypes> providers() {
        return AuthenticationProvidersCopier.copyStringToEnum(providers);
    }

    /**
     * For responses, this returns true if the service returned a value for the Providers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProviders() {
        return providers != null && !(providers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to use the
     * Grafana console in the Amazon Managed Grafana workspace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviders} method.
     * </p>
     * 
     * @return Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to
     *         use the Grafana console in the Amazon Managed Grafana workspace.
     */
    public final List<String> providersAsStrings() {
        return providers;
    }

    /**
     * <p>
     * A structure containing information about how this workspace works with SAML, including what attributes within the
     * assertion are to be mapped to user information in the workspace.
     * </p>
     * 
     * @return A structure containing information about how this workspace works with SAML, including what attributes
     *         within the assertion are to be mapped to user information in the workspace.
     */
    public final SamlAuthentication saml() {
        return saml;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsSso());
        hashCode = 31 * hashCode + Objects.hashCode(hasProviders() ? providersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(saml());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationDescription)) {
            return false;
        }
        AuthenticationDescription other = (AuthenticationDescription) obj;
        return Objects.equals(awsSso(), other.awsSso()) && hasProviders() == other.hasProviders()
                && Objects.equals(providersAsStrings(), other.providersAsStrings()) && Objects.equals(saml(), other.saml());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationDescription").add("AwsSso", awsSso())
                .add("Providers", hasProviders() ? providersAsStrings() : null).add("Saml", saml()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsSso":
            return Optional.ofNullable(clazz.cast(awsSso()));
        case "providers":
            return Optional.ofNullable(clazz.cast(providersAsStrings()));
        case "saml":
            return Optional.ofNullable(clazz.cast(saml()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsSso", AWS_SSO_FIELD);
        map.put("providers", PROVIDERS_FIELD);
        map.put("saml", SAML_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationDescription, T> g) {
        return obj -> g.apply((AuthenticationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationDescription> {
        /**
         * <p>
         * A structure containing information about how this workspace works with IAM Identity Center.
         * </p>
         * 
         * @param awsSso
         *        A structure containing information about how this workspace works with IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSso(AwsSsoAuthentication awsSso);

        /**
         * <p>
         * A structure containing information about how this workspace works with IAM Identity Center.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsSsoAuthentication.Builder} avoiding
         * the need to create one manually via {@link AwsSsoAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSsoAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #awsSso(AwsSsoAuthentication)}.
         * 
         * @param awsSso
         *        a consumer that will call methods on {@link AwsSsoAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSso(AwsSsoAuthentication)
         */
        default Builder awsSso(Consumer<AwsSsoAuthentication.Builder> awsSso) {
            return awsSso(AwsSsoAuthentication.builder().applyMutation(awsSso).build());
        }

        /**
         * <p>
         * Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to use
         * the Grafana console in the Amazon Managed Grafana workspace.
         * </p>
         * 
         * @param providers
         *        Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users
         *        to use the Grafana console in the Amazon Managed Grafana workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providersWithStrings(Collection<String> providers);

        /**
         * <p>
         * Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to use
         * the Grafana console in the Amazon Managed Grafana workspace.
         * </p>
         * 
         * @param providers
         *        Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users
         *        to use the Grafana console in the Amazon Managed Grafana workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providersWithStrings(String... providers);

        /**
         * <p>
         * Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to use
         * the Grafana console in the Amazon Managed Grafana workspace.
         * </p>
         * 
         * @param providers
         *        Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users
         *        to use the Grafana console in the Amazon Managed Grafana workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providers(Collection<AuthenticationProviderTypes> providers);

        /**
         * <p>
         * Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users to use
         * the Grafana console in the Amazon Managed Grafana workspace.
         * </p>
         * 
         * @param providers
         *        Specifies whether this workspace uses IAM Identity Center, SAML, or both methods to authenticate users
         *        to use the Grafana console in the Amazon Managed Grafana workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providers(AuthenticationProviderTypes... providers);

        /**
         * <p>
         * A structure containing information about how this workspace works with SAML, including what attributes within
         * the assertion are to be mapped to user information in the workspace.
         * </p>
         * 
         * @param saml
         *        A structure containing information about how this workspace works with SAML, including what attributes
         *        within the assertion are to be mapped to user information in the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saml(SamlAuthentication saml);

        /**
         * <p>
         * A structure containing information about how this workspace works with SAML, including what attributes within
         * the assertion are to be mapped to user information in the workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link SamlAuthentication.Builder} avoiding the
         * need to create one manually via {@link SamlAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlAuthentication.Builder#build()} is called immediately and its
         * result is passed to {@link #saml(SamlAuthentication)}.
         * 
         * @param saml
         *        a consumer that will call methods on {@link SamlAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #saml(SamlAuthentication)
         */
        default Builder saml(Consumer<SamlAuthentication.Builder> saml) {
            return saml(SamlAuthentication.builder().applyMutation(saml).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsSsoAuthentication awsSso;

        private List<String> providers = DefaultSdkAutoConstructList.getInstance();

        private SamlAuthentication saml;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationDescription model) {
            awsSso(model.awsSso);
            providersWithStrings(model.providers);
            saml(model.saml);
        }

        public final AwsSsoAuthentication.Builder getAwsSso() {
            return awsSso != null ? awsSso.toBuilder() : null;
        }

        public final void setAwsSso(AwsSsoAuthentication.BuilderImpl awsSso) {
            this.awsSso = awsSso != null ? awsSso.build() : null;
        }

        @Override
        public final Builder awsSso(AwsSsoAuthentication awsSso) {
            this.awsSso = awsSso;
            return this;
        }

        public final Collection<String> getProviders() {
            if (providers instanceof SdkAutoConstructList) {
                return null;
            }
            return providers;
        }

        public final void setProviders(Collection<String> providers) {
            this.providers = AuthenticationProvidersCopier.copy(providers);
        }

        @Override
        public final Builder providersWithStrings(Collection<String> providers) {
            this.providers = AuthenticationProvidersCopier.copy(providers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providersWithStrings(String... providers) {
            providersWithStrings(Arrays.asList(providers));
            return this;
        }

        @Override
        public final Builder providers(Collection<AuthenticationProviderTypes> providers) {
            this.providers = AuthenticationProvidersCopier.copyEnumToString(providers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providers(AuthenticationProviderTypes... providers) {
            providers(Arrays.asList(providers));
            return this;
        }

        public final SamlAuthentication.Builder getSaml() {
            return saml != null ? saml.toBuilder() : null;
        }

        public final void setSaml(SamlAuthentication.BuilderImpl saml) {
            this.saml = saml != null ? saml.build() : null;
        }

        @Override
        public final Builder saml(SamlAuthentication saml) {
            this.saml = saml;
            return this;
        }

        @Override
        public AuthenticationDescription build() {
            return new AuthenticationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
