/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceServiceAccountRequest extends GrafanaRequest implements
        ToCopyableBuilder<CreateWorkspaceServiceAccountRequest.Builder, CreateWorkspaceServiceAccountRequest> {
    private static final SdkField<String> GRAFANA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("grafanaRole").getter(getter(CreateWorkspaceServiceAccountRequest::grafanaRoleAsString))
            .setter(setter(Builder::grafanaRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaRole").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkspaceServiceAccountRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateWorkspaceServiceAccountRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAFANA_ROLE_FIELD,
            NAME_FIELD, WORKSPACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String grafanaRole;

    private final String name;

    private final String workspaceId;

    private CreateWorkspaceServiceAccountRequest(BuilderImpl builder) {
        super(builder);
        this.grafanaRole = builder.grafanaRole;
        this.name = builder.name;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The permission level to use for this service account.
     * </p>
     * <note>
     * <p>
     * For more information about the roles and the permissions each has, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in the
     * <i>Amazon Managed Grafana User Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grafanaRole} will
     * return {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grafanaRoleAsString}.
     * </p>
     * 
     * @return The permission level to use for this service account.</p> <note>
     *         <p>
     *         For more information about the roles and the permissions each has, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in the
     *         <i>Amazon Managed Grafana User Guide</i>.
     *         </p>
     * @see Role
     */
    public final Role grafanaRole() {
        return Role.fromValue(grafanaRole);
    }

    /**
     * <p>
     * The permission level to use for this service account.
     * </p>
     * <note>
     * <p>
     * For more information about the roles and the permissions each has, see <a
     * href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in the
     * <i>Amazon Managed Grafana User Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grafanaRole} will
     * return {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grafanaRoleAsString}.
     * </p>
     * 
     * @return The permission level to use for this service account.</p> <note>
     *         <p>
     *         For more information about the roles and the permissions each has, see <a
     *         href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in the
     *         <i>Amazon Managed Grafana User Guide</i>.
     *         </p>
     * @see Role
     */
    public final String grafanaRoleAsString() {
        return grafanaRole;
    }

    /**
     * <p>
     * A name for the service account. The name must be unique within the workspace, as it determines the ID associated
     * with the service account.
     * </p>
     * 
     * @return A name for the service account. The name must be unique within the workspace, as it determines the ID
     *         associated with the service account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the workspace within which to create the service account.
     * </p>
     * 
     * @return The ID of the workspace within which to create the service account.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(grafanaRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceServiceAccountRequest)) {
            return false;
        }
        CreateWorkspaceServiceAccountRequest other = (CreateWorkspaceServiceAccountRequest) obj;
        return Objects.equals(grafanaRoleAsString(), other.grafanaRoleAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceServiceAccountRequest").add("GrafanaRole", grafanaRoleAsString())
                .add("Name", name()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grafanaRole":
            return Optional.ofNullable(clazz.cast(grafanaRoleAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("grafanaRole", GRAFANA_ROLE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceServiceAccountRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceServiceAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkspaceServiceAccountRequest> {
        /**
         * <p>
         * The permission level to use for this service account.
         * </p>
         * <note>
         * <p>
         * For more information about the roles and the permissions each has, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in the
         * <i>Amazon Managed Grafana User Guide</i>.
         * </p>
         * </note>
         * 
         * @param grafanaRole
         *        The permission level to use for this service account.</p> <note>
         *        <p>
         *        For more information about the roles and the permissions each has, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in
         *        the <i>Amazon Managed Grafana User Guide</i>.
         *        </p>
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder grafanaRole(String grafanaRole);

        /**
         * <p>
         * The permission level to use for this service account.
         * </p>
         * <note>
         * <p>
         * For more information about the roles and the permissions each has, see <a
         * href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in the
         * <i>Amazon Managed Grafana User Guide</i>.
         * </p>
         * </note>
         * 
         * @param grafanaRole
         *        The permission level to use for this service account.</p> <note>
         *        <p>
         *        For more information about the roles and the permissions each has, see <a
         *        href="https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html">User roles</a> in
         *        the <i>Amazon Managed Grafana User Guide</i>.
         *        </p>
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder grafanaRole(Role grafanaRole);

        /**
         * <p>
         * A name for the service account. The name must be unique within the workspace, as it determines the ID
         * associated with the service account.
         * </p>
         * 
         * @param name
         *        A name for the service account. The name must be unique within the workspace, as it determines the ID
         *        associated with the service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the workspace within which to create the service account.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace within which to create the service account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private String grafanaRole;

        private String name;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceServiceAccountRequest model) {
            super(model);
            grafanaRole(model.grafanaRole);
            name(model.name);
            workspaceId(model.workspaceId);
        }

        public final String getGrafanaRole() {
            return grafanaRole;
        }

        public final void setGrafanaRole(String grafanaRole) {
            this.grafanaRole = grafanaRole;
        }

        @Override
        public final Builder grafanaRole(String grafanaRole) {
            this.grafanaRole = grafanaRole;
            return this;
        }

        @Override
        public final Builder grafanaRole(Role grafanaRole) {
            this.grafanaRole(grafanaRole == null ? null : grafanaRole.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceServiceAccountRequest build() {
            return new CreateWorkspaceServiceAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
