/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceServiceAccountTokenRequest extends GrafanaRequest implements
        ToCopyableBuilder<CreateWorkspaceServiceAccountTokenRequest.Builder, CreateWorkspaceServiceAccountTokenRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkspaceServiceAccountTokenRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> SECONDS_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("secondsToLive").getter(getter(CreateWorkspaceServiceAccountTokenRequest::secondsToLive))
            .setter(setter(Builder::secondsToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondsToLive").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccountId").getter(getter(CreateWorkspaceServiceAccountTokenRequest::serviceAccountId))
            .setter(setter(Builder::serviceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceAccountId").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateWorkspaceServiceAccountTokenRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SECONDS_TO_LIVE_FIELD, SERVICE_ACCOUNT_ID_FIELD, WORKSPACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Integer secondsToLive;

    private final String serviceAccountId;

    private final String workspaceId;

    private CreateWorkspaceServiceAccountTokenRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.secondsToLive = builder.secondsToLive;
        this.serviceAccountId = builder.serviceAccountId;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * A name for the token to create.
     * </p>
     * 
     * @return A name for the token to create.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
     * </p>
     * 
     * @return Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
     */
    public final Integer secondsToLive() {
        return secondsToLive;
    }

    /**
     * <p>
     * The ID of the service account for which to create a token.
     * </p>
     * 
     * @return The ID of the service account for which to create a token.
     */
    public final String serviceAccountId() {
        return serviceAccountId;
    }

    /**
     * <p>
     * The ID of the workspace the service account resides within.
     * </p>
     * 
     * @return The ID of the workspace the service account resides within.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(secondsToLive());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceServiceAccountTokenRequest)) {
            return false;
        }
        CreateWorkspaceServiceAccountTokenRequest other = (CreateWorkspaceServiceAccountTokenRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(secondsToLive(), other.secondsToLive())
                && Objects.equals(serviceAccountId(), other.serviceAccountId())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceServiceAccountTokenRequest").add("Name", name())
                .add("SecondsToLive", secondsToLive()).add("ServiceAccountId", serviceAccountId())
                .add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "secondsToLive":
            return Optional.ofNullable(clazz.cast(secondsToLive()));
        case "serviceAccountId":
            return Optional.ofNullable(clazz.cast(serviceAccountId()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("secondsToLive", SECONDS_TO_LIVE_FIELD);
        map.put("serviceAccountId", SERVICE_ACCOUNT_ID_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceServiceAccountTokenRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceServiceAccountTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkspaceServiceAccountTokenRequest> {
        /**
         * <p>
         * A name for the token to create.
         * </p>
         * 
         * @param name
         *        A name for the token to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
         * </p>
         * 
         * @param secondsToLive
         *        Sets how long the token will be valid, in seconds. You can set the time up to 30 days in the future.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsToLive(Integer secondsToLive);

        /**
         * <p>
         * The ID of the service account for which to create a token.
         * </p>
         * 
         * @param serviceAccountId
         *        The ID of the service account for which to create a token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountId(String serviceAccountId);

        /**
         * <p>
         * The ID of the workspace the service account resides within.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace the service account resides within.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private String name;

        private Integer secondsToLive;

        private String serviceAccountId;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceServiceAccountTokenRequest model) {
            super(model);
            name(model.name);
            secondsToLive(model.secondsToLive);
            serviceAccountId(model.serviceAccountId);
            workspaceId(model.workspaceId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getSecondsToLive() {
            return secondsToLive;
        }

        public final void setSecondsToLive(Integer secondsToLive) {
            this.secondsToLive = secondsToLive;
        }

        @Override
        public final Builder secondsToLive(Integer secondsToLive) {
            this.secondsToLive = secondsToLive;
            return this;
        }

        public final String getServiceAccountId() {
            return serviceAccountId;
        }

        public final void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        @Override
        public final Builder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceServiceAccountTokenRequest build() {
            return new CreateWorkspaceServiceAccountTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
