/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteWorkspaceServiceAccountTokenResponse extends GrafanaResponse implements
        ToCopyableBuilder<DeleteWorkspaceServiceAccountTokenResponse.Builder, DeleteWorkspaceServiceAccountTokenResponse> {
    private static final SdkField<String> SERVICE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccountId").getter(getter(DeleteWorkspaceServiceAccountTokenResponse::serviceAccountId))
            .setter(setter(Builder::serviceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountId").build()).build();

    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenId").getter(getter(DeleteWorkspaceServiceAccountTokenResponse::tokenId))
            .setter(setter(Builder::tokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenId").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(DeleteWorkspaceServiceAccountTokenResponse::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_ID_FIELD,
            TOKEN_ID_FIELD, WORKSPACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceAccountId;

    private final String tokenId;

    private final String workspaceId;

    private DeleteWorkspaceServiceAccountTokenResponse(BuilderImpl builder) {
        super(builder);
        this.serviceAccountId = builder.serviceAccountId;
        this.tokenId = builder.tokenId;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The ID of the service account where the token was deleted.
     * </p>
     * 
     * @return The ID of the service account where the token was deleted.
     */
    public final String serviceAccountId() {
        return serviceAccountId;
    }

    /**
     * <p>
     * The ID of the token that was deleted.
     * </p>
     * 
     * @return The ID of the token that was deleted.
     */
    public final String tokenId() {
        return tokenId;
    }

    /**
     * <p>
     * The ID of the workspace where the token was deleted.
     * </p>
     * 
     * @return The ID of the workspace where the token was deleted.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWorkspaceServiceAccountTokenResponse)) {
            return false;
        }
        DeleteWorkspaceServiceAccountTokenResponse other = (DeleteWorkspaceServiceAccountTokenResponse) obj;
        return Objects.equals(serviceAccountId(), other.serviceAccountId()) && Objects.equals(tokenId(), other.tokenId())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteWorkspaceServiceAccountTokenResponse").add("ServiceAccountId", serviceAccountId())
                .add("TokenId", tokenId()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceAccountId":
            return Optional.ofNullable(clazz.cast(serviceAccountId()));
        case "tokenId":
            return Optional.ofNullable(clazz.cast(tokenId()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceAccountId", SERVICE_ACCOUNT_ID_FIELD);
        map.put("tokenId", TOKEN_ID_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteWorkspaceServiceAccountTokenResponse, T> g) {
        return obj -> g.apply((DeleteWorkspaceServiceAccountTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteWorkspaceServiceAccountTokenResponse> {
        /**
         * <p>
         * The ID of the service account where the token was deleted.
         * </p>
         * 
         * @param serviceAccountId
         *        The ID of the service account where the token was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountId(String serviceAccountId);

        /**
         * <p>
         * The ID of the token that was deleted.
         * </p>
         * 
         * @param tokenId
         *        The ID of the token that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenId(String tokenId);

        /**
         * <p>
         * The ID of the workspace where the token was deleted.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace where the token was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl extends GrafanaResponse.BuilderImpl implements Builder {
        private String serviceAccountId;

        private String tokenId;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWorkspaceServiceAccountTokenResponse model) {
            super(model);
            serviceAccountId(model.serviceAccountId);
            tokenId(model.tokenId);
            workspaceId(model.workspaceId);
        }

        public final String getServiceAccountId() {
            return serviceAccountId;
        }

        public final void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        @Override
        public final Builder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public final String getTokenId() {
            return tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public DeleteWorkspaceServiceAccountTokenResponse build() {
            return new DeleteWorkspaceServiceAccountTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
