/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateLicenseResponse extends GrafanaResponse implements
        ToCopyableBuilder<DisassociateLicenseResponse.Builder, DisassociateLicenseResponse> {
    private static final SdkField<WorkspaceDescription> WORKSPACE_FIELD = SdkField
            .<WorkspaceDescription> builder(MarshallingType.SDK_POJO).memberName("workspace")
            .getter(getter(DisassociateLicenseResponse::workspace)).setter(setter(Builder::workspace))
            .constructor(WorkspaceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WorkspaceDescription workspace;

    private DisassociateLicenseResponse(BuilderImpl builder) {
        super(builder);
        this.workspace = builder.workspace;
    }

    /**
     * <p>
     * A structure containing information about the workspace.
     * </p>
     * 
     * @return A structure containing information about the workspace.
     */
    public final WorkspaceDescription workspace() {
        return workspace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateLicenseResponse)) {
            return false;
        }
        DisassociateLicenseResponse other = (DisassociateLicenseResponse) obj;
        return Objects.equals(workspace(), other.workspace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateLicenseResponse").add("Workspace", workspace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspace":
            return Optional.ofNullable(clazz.cast(workspace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspace", WORKSPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateLicenseResponse, T> g) {
        return obj -> g.apply((DisassociateLicenseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateLicenseResponse> {
        /**
         * <p>
         * A structure containing information about the workspace.
         * </p>
         * 
         * @param workspace
         *        A structure containing information about the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspace(WorkspaceDescription workspace);

        /**
         * <p>
         * A structure containing information about the workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceDescription.Builder} avoiding
         * the need to create one manually via {@link WorkspaceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #workspace(WorkspaceDescription)}.
         * 
         * @param workspace
         *        a consumer that will call methods on {@link WorkspaceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspace(WorkspaceDescription)
         */
        default Builder workspace(Consumer<WorkspaceDescription.Builder> workspace) {
            return workspace(WorkspaceDescription.builder().applyMutation(workspace).build());
        }
    }

    static final class BuilderImpl extends GrafanaResponse.BuilderImpl implements Builder {
        private WorkspaceDescription workspace;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateLicenseResponse model) {
            super(model);
            workspace(model.workspace);
        }

        public final WorkspaceDescription.Builder getWorkspace() {
            return workspace != null ? workspace.toBuilder() : null;
        }

        public final void setWorkspace(WorkspaceDescription.BuilderImpl workspace) {
            this.workspace = workspace != null ? workspace.build() : null;
        }

        @Override
        public final Builder workspace(WorkspaceDescription workspace) {
            this.workspace = workspace;
            return this;
        }

        @Override
        public DisassociateLicenseResponse build() {
            return new DisassociateLicenseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
