/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this
 * workspace. You can specify the metadata either by providing a URL to its location in the <code>url</code> parameter,
 * or by specifying the full metadata in XML format in the <code>xml</code> parameter. Specifying both will cause an
 * error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdpMetadata implements SdkPojo, Serializable, ToCopyableBuilder<IdpMetadata.Builder, IdpMetadata> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(IdpMetadata::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> XML_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("xml")
            .getter(getter(IdpMetadata::xml)).setter(setter(Builder::xml))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xml").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, XML_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String xml;

    private final Type type;

    private IdpMetadata(BuilderImpl builder) {
        this.url = builder.url;
        this.xml = builder.xml;
        this.type = builder.type;
    }

    /**
     * <p>
     * The URL of the location containing the IdP metadata.
     * </p>
     * 
     * @return The URL of the location containing the IdP metadata.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The full IdP metadata, in XML format.
     * </p>
     * 
     * @return The full IdP metadata, in XML format.
     */
    public final String xml() {
        return xml;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(xml());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdpMetadata)) {
            return false;
        }
        IdpMetadata other = (IdpMetadata) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(xml(), other.xml());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdpMetadata").add("Url", url()).add("Xml", xml()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "xml":
            return Optional.ofNullable(clazz.cast(xml()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #url()} initialized to the given value.
     *
     * <p>
     * The URL of the location containing the IdP metadata.
     * </p>
     * 
     * @param url
     *        The URL of the location containing the IdP metadata.
     */
    public static IdpMetadata fromUrl(String url) {
        return builder().url(url).build();
    }

    /**
     * Create an instance of this class with {@link #xml()} initialized to the given value.
     *
     * <p>
     * The full IdP metadata, in XML format.
     * </p>
     * 
     * @param xml
     *        The full IdP metadata, in XML format.
     */
    public static IdpMetadata fromXml(String xml) {
        return builder().xml(xml).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("url", URL_FIELD);
        map.put("xml", XML_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdpMetadata, T> g) {
        return obj -> g.apply((IdpMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdpMetadata> {
        /**
         * <p>
         * The URL of the location containing the IdP metadata.
         * </p>
         * 
         * @param url
         *        The URL of the location containing the IdP metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The full IdP metadata, in XML format.
         * </p>
         * 
         * @param xml
         *        The full IdP metadata, in XML format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xml(String xml);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String xml;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IdpMetadata model) {
            url(model.url);
            xml(model.xml);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            Object oldValue = this.url;
            this.url = url;
            handleUnionValueChange(Type.URL, oldValue, this.url);
        }

        @Override
        public final Builder url(String url) {
            Object oldValue = this.url;
            this.url = url;
            handleUnionValueChange(Type.URL, oldValue, this.url);
            return this;
        }

        public final String getXml() {
            return xml;
        }

        public final void setXml(String xml) {
            Object oldValue = this.xml;
            this.xml = xml;
            handleUnionValueChange(Type.XML, oldValue, this.xml);
        }

        @Override
        public final Builder xml(String xml) {
            Object oldValue = this.xml;
            this.xml = xml;
            handleUnionValueChange(Type.XML, oldValue, this.xml);
            return this;
        }

        @Override
        public IdpMetadata build() {
            return new IdpMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IdpMetadata#type()
     */
    public enum Type {
        URL,

        XML,

        UNKNOWN_TO_SDK_VERSION
    }
}
