/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkspaceServiceAccountTokensResponse extends GrafanaResponse implements
        ToCopyableBuilder<ListWorkspaceServiceAccountTokensResponse.Builder, ListWorkspaceServiceAccountTokensResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkspaceServiceAccountTokensResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccountId").getter(getter(ListWorkspaceServiceAccountTokensResponse::serviceAccountId))
            .setter(setter(Builder::serviceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountId").build()).build();

    private static final SdkField<List<ServiceAccountTokenSummary>> SERVICE_ACCOUNT_TOKENS_FIELD = SdkField
            .<List<ServiceAccountTokenSummary>> builder(MarshallingType.LIST)
            .memberName("serviceAccountTokens")
            .getter(getter(ListWorkspaceServiceAccountTokensResponse::serviceAccountTokens))
            .setter(setter(Builder::serviceAccountTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountTokens").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceAccountTokenSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceAccountTokenSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(ListWorkspaceServiceAccountTokensResponse::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVICE_ACCOUNT_ID_FIELD, SERVICE_ACCOUNT_TOKENS_FIELD, WORKSPACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final String serviceAccountId;

    private final List<ServiceAccountTokenSummary> serviceAccountTokens;

    private final String workspaceId;

    private ListWorkspaceServiceAccountTokensResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceAccountId = builder.serviceAccountId;
        this.serviceAccountTokens = builder.serviceAccountTokens;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The token to use when requesting the next set of service accounts.
     * </p>
     * 
     * @return The token to use when requesting the next set of service accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the service account where the tokens reside.
     * </p>
     * 
     * @return The ID of the service account where the tokens reside.
     */
    public final String serviceAccountId() {
        return serviceAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceAccountTokens property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceAccountTokens() {
        return serviceAccountTokens != null && !(serviceAccountTokens instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures containing information about the tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceAccountTokens} method.
     * </p>
     * 
     * @return An array of structures containing information about the tokens.
     */
    public final List<ServiceAccountTokenSummary> serviceAccountTokens() {
        return serviceAccountTokens;
    }

    /**
     * <p>
     * The ID of the workspace where the tokens reside.
     * </p>
     * 
     * @return The ID of the workspace where the tokens reside.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceAccountTokens() ? serviceAccountTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspaceServiceAccountTokensResponse)) {
            return false;
        }
        ListWorkspaceServiceAccountTokensResponse other = (ListWorkspaceServiceAccountTokensResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(serviceAccountId(), other.serviceAccountId())
                && hasServiceAccountTokens() == other.hasServiceAccountTokens()
                && Objects.equals(serviceAccountTokens(), other.serviceAccountTokens())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkspaceServiceAccountTokensResponse").add("NextToken", nextToken())
                .add("ServiceAccountId", serviceAccountId())
                .add("ServiceAccountTokens", hasServiceAccountTokens() ? serviceAccountTokens() : null)
                .add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serviceAccountId":
            return Optional.ofNullable(clazz.cast(serviceAccountId()));
        case "serviceAccountTokens":
            return Optional.ofNullable(clazz.cast(serviceAccountTokens()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("serviceAccountId", SERVICE_ACCOUNT_ID_FIELD);
        map.put("serviceAccountTokens", SERVICE_ACCOUNT_TOKENS_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspaceServiceAccountTokensResponse, T> g) {
        return obj -> g.apply((ListWorkspaceServiceAccountTokensResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkspaceServiceAccountTokensResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of service accounts.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of service accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the service account where the tokens reside.
         * </p>
         * 
         * @param serviceAccountId
         *        The ID of the service account where the tokens reside.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountId(String serviceAccountId);

        /**
         * <p>
         * An array of structures containing information about the tokens.
         * </p>
         * 
         * @param serviceAccountTokens
         *        An array of structures containing information about the tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountTokens(Collection<ServiceAccountTokenSummary> serviceAccountTokens);

        /**
         * <p>
         * An array of structures containing information about the tokens.
         * </p>
         * 
         * @param serviceAccountTokens
         *        An array of structures containing information about the tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountTokens(ServiceAccountTokenSummary... serviceAccountTokens);

        /**
         * <p>
         * An array of structures containing information about the tokens.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.grafana.model.ServiceAccountTokenSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.grafana.model.ServiceAccountTokenSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.grafana.model.ServiceAccountTokenSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceAccountTokens(List<ServiceAccountTokenSummary>)}.
         * 
         * @param serviceAccountTokens
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.grafana.model.ServiceAccountTokenSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAccountTokens(java.util.Collection<ServiceAccountTokenSummary>)
         */
        Builder serviceAccountTokens(Consumer<ServiceAccountTokenSummary.Builder>... serviceAccountTokens);

        /**
         * <p>
         * The ID of the workspace where the tokens reside.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace where the tokens reside.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl extends GrafanaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String serviceAccountId;

        private List<ServiceAccountTokenSummary> serviceAccountTokens = DefaultSdkAutoConstructList.getInstance();

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspaceServiceAccountTokensResponse model) {
            super(model);
            nextToken(model.nextToken);
            serviceAccountId(model.serviceAccountId);
            serviceAccountTokens(model.serviceAccountTokens);
            workspaceId(model.workspaceId);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServiceAccountId() {
            return serviceAccountId;
        }

        public final void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        @Override
        public final Builder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public final List<ServiceAccountTokenSummary.Builder> getServiceAccountTokens() {
            List<ServiceAccountTokenSummary.Builder> result = ServiceAccountTokenListCopier
                    .copyToBuilder(this.serviceAccountTokens);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceAccountTokens(Collection<ServiceAccountTokenSummary.BuilderImpl> serviceAccountTokens) {
            this.serviceAccountTokens = ServiceAccountTokenListCopier.copyFromBuilder(serviceAccountTokens);
        }

        @Override
        public final Builder serviceAccountTokens(Collection<ServiceAccountTokenSummary> serviceAccountTokens) {
            this.serviceAccountTokens = ServiceAccountTokenListCopier.copy(serviceAccountTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceAccountTokens(ServiceAccountTokenSummary... serviceAccountTokens) {
            serviceAccountTokens(Arrays.asList(serviceAccountTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceAccountTokens(Consumer<ServiceAccountTokenSummary.Builder>... serviceAccountTokens) {
            serviceAccountTokens(Stream.of(serviceAccountTokens)
                    .map(c -> ServiceAccountTokenSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public ListWorkspaceServiceAccountTokensResponse build() {
            return new ListWorkspaceServiceAccountTokensResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
