/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing information about how this workspace works with SAML.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamlAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<SamlAuthentication.Builder, SamlAuthentication> {
    private static final SdkField<SamlConfiguration> CONFIGURATION_FIELD = SdkField
            .<SamlConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(SamlAuthentication::configuration)).setter(setter(Builder::configuration))
            .constructor(SamlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SamlAuthentication::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SamlConfiguration configuration;

    private final String status;

    private SamlAuthentication(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.status = builder.status;
    }

    /**
     * <p>
     * A structure containing details about how this workspace works with SAML.
     * </p>
     * 
     * @return A structure containing details about how this workspace works with SAML.
     */
    public final SamlConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Specifies whether the workspace's SAML configuration is complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SamlConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether the workspace's SAML configuration is complete.
     * @see SamlConfigurationStatus
     */
    public final SamlConfigurationStatus status() {
        return SamlConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies whether the workspace's SAML configuration is complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SamlConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether the workspace's SAML configuration is complete.
     * @see SamlConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlAuthentication)) {
            return false;
        }
        SamlAuthentication other = (SamlAuthentication) obj;
        return Objects.equals(configuration(), other.configuration()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamlAuthentication").add("Configuration", configuration()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamlAuthentication, T> g) {
        return obj -> g.apply((SamlAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamlAuthentication> {
        /**
         * <p>
         * A structure containing details about how this workspace works with SAML.
         * </p>
         * 
         * @param configuration
         *        A structure containing details about how this workspace works with SAML.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(SamlConfiguration configuration);

        /**
         * <p>
         * A structure containing details about how this workspace works with SAML.
         * </p>
         * This is a convenience method that creates an instance of the {@link SamlConfiguration.Builder} avoiding the
         * need to create one manually via {@link SamlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(SamlConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link SamlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(SamlConfiguration)
         */
        default Builder configuration(Consumer<SamlConfiguration.Builder> configuration) {
            return configuration(SamlConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Specifies whether the workspace's SAML configuration is complete.
         * </p>
         * 
         * @param status
         *        Specifies whether the workspace's SAML configuration is complete.
         * @see SamlConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SamlConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether the workspace's SAML configuration is complete.
         * </p>
         * 
         * @param status
         *        Specifies whether the workspace's SAML configuration is complete.
         * @see SamlConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SamlConfigurationStatus
         */
        Builder status(SamlConfigurationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private SamlConfiguration configuration;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlAuthentication model) {
            configuration(model.configuration);
            status(model.status);
        }

        public final SamlConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(SamlConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(SamlConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SamlConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public SamlAuthentication build() {
            return new SamlAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
