/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing information about one error encountered while performing an <a
 * href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateError implements SdkPojo, Serializable, ToCopyableBuilder<UpdateError.Builder, UpdateError> {
    private static final SdkField<UpdateInstruction> CAUSED_BY_FIELD = SdkField
            .<UpdateInstruction> builder(MarshallingType.SDK_POJO).memberName("causedBy").getter(getter(UpdateError::causedBy))
            .setter(setter(Builder::causedBy)).constructor(UpdateInstruction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("causedBy").build()).build();

    private static final SdkField<Integer> CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("code")
            .getter(getter(UpdateError::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(UpdateError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAUSED_BY_FIELD, CODE_FIELD,
            MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateInstruction causedBy;

    private final Integer code;

    private final String message;

    private UpdateError(BuilderImpl builder) {
        this.causedBy = builder.causedBy;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * Specifies which permission update caused the error.
     * </p>
     * 
     * @return Specifies which permission update caused the error.
     */
    public final UpdateInstruction causedBy() {
        return causedBy;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public final Integer code() {
        return code;
    }

    /**
     * <p>
     * The message for this error.
     * </p>
     * 
     * @return The message for this error.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(causedBy());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateError)) {
            return false;
        }
        UpdateError other = (UpdateError) obj;
        return Objects.equals(causedBy(), other.causedBy()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateError").add("CausedBy", causedBy()).add("Code", code()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "causedBy":
            return Optional.ofNullable(clazz.cast(causedBy()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("causedBy", CAUSED_BY_FIELD);
        map.put("code", CODE_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateError, T> g) {
        return obj -> g.apply((UpdateError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateError> {
        /**
         * <p>
         * Specifies which permission update caused the error.
         * </p>
         * 
         * @param causedBy
         *        Specifies which permission update caused the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder causedBy(UpdateInstruction causedBy);

        /**
         * <p>
         * Specifies which permission update caused the error.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateInstruction.Builder} avoiding the
         * need to create one manually via {@link UpdateInstruction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateInstruction.Builder#build()} is called immediately and its
         * result is passed to {@link #causedBy(UpdateInstruction)}.
         * 
         * @param causedBy
         *        a consumer that will call methods on {@link UpdateInstruction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #causedBy(UpdateInstruction)
         */
        default Builder causedBy(Consumer<UpdateInstruction.Builder> causedBy) {
            return causedBy(UpdateInstruction.builder().applyMutation(causedBy).build());
        }

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param code
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * <p>
         * The message for this error.
         * </p>
         * 
         * @param message
         *        The message for this error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private UpdateInstruction causedBy;

        private Integer code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateError model) {
            causedBy(model.causedBy);
            code(model.code);
            message(model.message);
        }

        public final UpdateInstruction.Builder getCausedBy() {
            return causedBy != null ? causedBy.toBuilder() : null;
        }

        public final void setCausedBy(UpdateInstruction.BuilderImpl causedBy) {
            this.causedBy = causedBy != null ? causedBy.build() : null;
        }

        @Override
        public final Builder causedBy(UpdateInstruction causedBy) {
            this.causedBy = causedBy;
            return this;
        }

        public final Integer getCode() {
            return code;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public UpdateError build() {
            return new UpdateError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
