/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspaceAuthenticationResponse extends GrafanaResponse implements
        ToCopyableBuilder<UpdateWorkspaceAuthenticationResponse.Builder, UpdateWorkspaceAuthenticationResponse> {
    private static final SdkField<AuthenticationDescription> AUTHENTICATION_FIELD = SdkField
            .<AuthenticationDescription> builder(MarshallingType.SDK_POJO).memberName("authentication")
            .getter(getter(UpdateWorkspaceAuthenticationResponse::authentication)).setter(setter(Builder::authentication))
            .constructor(AuthenticationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AuthenticationDescription authentication;

    private UpdateWorkspaceAuthenticationResponse(BuilderImpl builder) {
        super(builder);
        this.authentication = builder.authentication;
    }

    /**
     * <p>
     * A structure that describes the user authentication for this workspace after the update is made.
     * </p>
     * 
     * @return A structure that describes the user authentication for this workspace after the update is made.
     */
    public final AuthenticationDescription authentication() {
        return authentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceAuthenticationResponse)) {
            return false;
        }
        UpdateWorkspaceAuthenticationResponse other = (UpdateWorkspaceAuthenticationResponse) obj;
        return Objects.equals(authentication(), other.authentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspaceAuthenticationResponse").add("Authentication", authentication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authentication", AUTHENTICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceAuthenticationResponse, T> g) {
        return obj -> g.apply((UpdateWorkspaceAuthenticationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWorkspaceAuthenticationResponse> {
        /**
         * <p>
         * A structure that describes the user authentication for this workspace after the update is made.
         * </p>
         * 
         * @param authentication
         *        A structure that describes the user authentication for this workspace after the update is made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(AuthenticationDescription authentication);

        /**
         * <p>
         * A structure that describes the user authentication for this workspace after the update is made.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationDescription.Builder}
         * avoiding the need to create one manually via {@link AuthenticationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #authentication(AuthenticationDescription)}.
         * 
         * @param authentication
         *        a consumer that will call methods on {@link AuthenticationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authentication(AuthenticationDescription)
         */
        default Builder authentication(Consumer<AuthenticationDescription.Builder> authentication) {
            return authentication(AuthenticationDescription.builder().applyMutation(authentication).build());
        }
    }

    static final class BuilderImpl extends GrafanaResponse.BuilderImpl implements Builder {
        private AuthenticationDescription authentication;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceAuthenticationResponse model) {
            super(model);
            authentication(model.authentication);
        }

        public final AuthenticationDescription.Builder getAuthentication() {
            return authentication != null ? authentication.toBuilder() : null;
        }

        public final void setAuthentication(AuthenticationDescription.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(AuthenticationDescription authentication) {
            this.authentication = authentication;
            return this;
        }

        @Override
        public UpdateWorkspaceAuthenticationResponse build() {
            return new UpdateWorkspaceAuthenticationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
