/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.grafana.GrafanaAsyncClient;
import software.amazon.awssdk.services.grafana.internal.UserAgentUtils;
import software.amazon.awssdk.services.grafana.model.ListVersionsRequest;
import software.amazon.awssdk.services.grafana.model.ListVersionsResponse;

public class ListVersionsPublisher
implements SdkPublisher<ListVersionsResponse> {
    private final GrafanaAsyncClient client;
    private final ListVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVersionsPublisher(GrafanaAsyncClient client, ListVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVersionsPublisher(GrafanaAsyncClient client, ListVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> grafanaVersions() {
        Function<ListVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grafanaVersions() != null) {
                return response.grafanaVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVersionsResponseFetcher
    implements AsyncPageFetcher<ListVersionsResponse> {
        private ListVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVersionsResponse> nextPage(ListVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListVersionsPublisher.this.client.listVersions(ListVersionsPublisher.this.firstRequest);
            }
            return ListVersionsPublisher.this.client.listVersions((ListVersionsRequest)((Object)ListVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

