/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaResponse;
import software.amazon.awssdk.services.grafana.model.WorkspaceDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteWorkspaceResponse
extends GrafanaResponse
implements ToCopyableBuilder<Builder, DeleteWorkspaceResponse> {
    private static final SdkField<WorkspaceDescription> WORKSPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workspace").getter(DeleteWorkspaceResponse.getter(DeleteWorkspaceResponse::workspace)).setter(DeleteWorkspaceResponse.setter(Builder::workspace)).constructor(WorkspaceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteWorkspaceResponse.memberNameToFieldInitializer();
    private final WorkspaceDescription workspace;

    private DeleteWorkspaceResponse(BuilderImpl builder) {
        super(builder);
        this.workspace = builder.workspace;
    }

    public final WorkspaceDescription workspace() {
        return this.workspace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWorkspaceResponse)) {
            return false;
        }
        DeleteWorkspaceResponse other = (DeleteWorkspaceResponse)((Object)obj);
        return Objects.equals(this.workspace(), other.workspace());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteWorkspaceResponse").add("Workspace", (Object)this.workspace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspace": {
                return Optional.ofNullable(clazz.cast(this.workspace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<WorkspaceDescription>> map = new HashMap<String, SdkField<WorkspaceDescription>>();
        map.put("workspace", WORKSPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteWorkspaceResponse, T> g) {
        return obj -> g.apply((DeleteWorkspaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaResponse.BuilderImpl
    implements Builder {
        private WorkspaceDescription workspace;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWorkspaceResponse model) {
            super(model);
            this.workspace(model.workspace);
        }

        public final WorkspaceDescription.Builder getWorkspace() {
            return this.workspace != null ? this.workspace.toBuilder() : null;
        }

        public final void setWorkspace(WorkspaceDescription.BuilderImpl workspace) {
            this.workspace = workspace != null ? workspace.build() : null;
        }

        @Override
        public final Builder workspace(WorkspaceDescription workspace) {
            this.workspace = workspace;
            return this;
        }

        @Override
        public DeleteWorkspaceResponse build() {
            return new DeleteWorkspaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GrafanaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteWorkspaceResponse> {
        public Builder workspace(WorkspaceDescription var1);

        default public Builder workspace(Consumer<WorkspaceDescription.Builder> workspace) {
            return this.workspace((WorkspaceDescription)((WorkspaceDescription.Builder)WorkspaceDescription.builder().applyMutation(workspace)).build());
        }
    }
}

