/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.RoleValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoleValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoleValues> {
    private static final SdkField<List<String>> ADMIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("admin").getter(RoleValues.getter(RoleValues::admin)).setter(RoleValues.setter(Builder::admin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("admin").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EDITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("editor").getter(RoleValues.getter(RoleValues::editor)).setter(RoleValues.setter(Builder::editor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("editor").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_FIELD, EDITOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoleValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> admin;
    private final List<String> editor;

    private RoleValues(BuilderImpl builder) {
        this.admin = builder.admin;
        this.editor = builder.editor;
    }

    public final boolean hasAdmin() {
        return this.admin != null && !(this.admin instanceof SdkAutoConstructList);
    }

    public final List<String> admin() {
        return this.admin;
    }

    public final boolean hasEditor() {
        return this.editor != null && !(this.editor instanceof SdkAutoConstructList);
    }

    public final List<String> editor() {
        return this.editor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdmin() ? this.admin() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEditor() ? this.editor() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleValues)) {
            return false;
        }
        RoleValues other = (RoleValues)obj;
        return this.hasAdmin() == other.hasAdmin() && Objects.equals(this.admin(), other.admin()) && this.hasEditor() == other.hasEditor() && Objects.equals(this.editor(), other.editor());
    }

    public final String toString() {
        return ToString.builder((String)"RoleValues").add("Admin", (Object)(this.admin() == null ? null : "*** Sensitive Data Redacted ***")).add("Editor", (Object)(this.editor() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "admin": {
                return Optional.ofNullable(clazz.cast(this.admin()));
            }
            case "editor": {
                return Optional.ofNullable(clazz.cast(this.editor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("admin", ADMIN_FIELD);
        map.put("editor", EDITOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoleValues, T> g) {
        return obj -> g.apply((RoleValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> admin = DefaultSdkAutoConstructList.getInstance();
        private List<String> editor = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoleValues model) {
            this.admin(model.admin);
            this.editor(model.editor);
        }

        public final Collection<String> getAdmin() {
            if (this.admin instanceof SdkAutoConstructList) {
                return null;
            }
            return this.admin;
        }

        public final void setAdmin(Collection<String> admin) {
            this.admin = RoleValueListCopier.copy(admin);
        }

        @Override
        public final Builder admin(Collection<String> admin) {
            this.admin = RoleValueListCopier.copy(admin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder admin(String ... admin) {
            this.admin(Arrays.asList(admin));
            return this;
        }

        public final Collection<String> getEditor() {
            if (this.editor instanceof SdkAutoConstructList) {
                return null;
            }
            return this.editor;
        }

        public final void setEditor(Collection<String> editor) {
            this.editor = RoleValueListCopier.copy(editor);
        }

        @Override
        public final Builder editor(Collection<String> editor) {
            this.editor = RoleValueListCopier.copy(editor);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder editor(String ... editor) {
            this.editor(Arrays.asList(editor));
            return this;
        }

        public RoleValues build() {
            return new RoleValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoleValues> {
        public Builder admin(Collection<String> var1);

        public Builder admin(String ... var1);

        public Builder editor(Collection<String> var1);

        public Builder editor(String ... var1);
    }
}

