/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.PrefixListIdsCopier;
import software.amazon.awssdk.services.grafana.model.VpceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkAccessConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkAccessConfiguration> {
    private static final SdkField<List<String>> PREFIX_LIST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("prefixListIds").getter(NetworkAccessConfiguration.getter(NetworkAccessConfiguration::prefixListIds)).setter(NetworkAccessConfiguration.setter(Builder::prefixListIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixListIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpceIds").getter(NetworkAccessConfiguration.getter(NetworkAccessConfiguration::vpceIds)).setter(NetworkAccessConfiguration.setter(Builder::vpceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_IDS_FIELD, VPCE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkAccessConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> prefixListIds;
    private final List<String> vpceIds;

    private NetworkAccessConfiguration(BuilderImpl builder) {
        this.prefixListIds = builder.prefixListIds;
        this.vpceIds = builder.vpceIds;
    }

    public final boolean hasPrefixListIds() {
        return this.prefixListIds != null && !(this.prefixListIds instanceof SdkAutoConstructList);
    }

    public final List<String> prefixListIds() {
        return this.prefixListIds;
    }

    public final boolean hasVpceIds() {
        return this.vpceIds != null && !(this.vpceIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpceIds() {
        return this.vpceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrefixListIds() ? this.prefixListIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpceIds() ? this.vpceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAccessConfiguration)) {
            return false;
        }
        NetworkAccessConfiguration other = (NetworkAccessConfiguration)obj;
        return this.hasPrefixListIds() == other.hasPrefixListIds() && Objects.equals(this.prefixListIds(), other.prefixListIds()) && this.hasVpceIds() == other.hasVpceIds() && Objects.equals(this.vpceIds(), other.vpceIds());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkAccessConfiguration").add("PrefixListIds", this.hasPrefixListIds() ? this.prefixListIds() : null).add("VpceIds", this.hasVpceIds() ? this.vpceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "prefixListIds": {
                return Optional.ofNullable(clazz.cast(this.prefixListIds()));
            }
            case "vpceIds": {
                return Optional.ofNullable(clazz.cast(this.vpceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("prefixListIds", PREFIX_LIST_IDS_FIELD);
        map.put("vpceIds", VPCE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkAccessConfiguration, T> g) {
        return obj -> g.apply((NetworkAccessConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> prefixListIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAccessConfiguration model) {
            this.prefixListIds(model.prefixListIds);
            this.vpceIds(model.vpceIds);
        }

        public final Collection<String> getPrefixListIds() {
            if (this.prefixListIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.prefixListIds;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdsCopier.copy(prefixListIds);
        }

        @Override
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdsCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(String ... prefixListIds) {
            this.prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final Collection<String> getVpceIds() {
            if (this.vpceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpceIds;
        }

        public final void setVpceIds(Collection<String> vpceIds) {
            this.vpceIds = VpceIdsCopier.copy(vpceIds);
        }

        @Override
        public final Builder vpceIds(Collection<String> vpceIds) {
            this.vpceIds = VpceIdsCopier.copy(vpceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceIds(String ... vpceIds) {
            this.vpceIds(Arrays.asList(vpceIds));
            return this;
        }

        public NetworkAccessConfiguration build() {
            return new NetworkAccessConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkAccessConfiguration> {
        public Builder prefixListIds(Collection<String> var1);

        public Builder prefixListIds(String ... var1);

        public Builder vpceIds(Collection<String> var1);

        public Builder vpceIds(String ... var1);
    }
}

