/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupResponse;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountResponse;
import software.amazon.awssdk.services.greengrass.model.BadRequestException;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleRequest;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleResponse;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountRequest;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GreengrassException;
import software.amazon.awssdk.services.greengrass.model.InternalServerErrorException;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsResponse;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.transform.AssociateRoleToGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.AssociateServiceRoleToAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateConnectorDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateCoreDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeviceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateFunctionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateLoggerDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateResourceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSoftwareUpdateJobRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSubscriptionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DisassociateRoleFromGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DisassociateServiceRoleFromAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetAssociatedRoleRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetBulkDeploymentStatusRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectivityInfoRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectorDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetCoreDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeploymentStatusRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeviceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetFunctionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupCertificateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetLoggerDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetResourceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetServiceRoleForAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetSubscriptionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListBulkDeploymentDetailedReportsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListBulkDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListConnectorDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListConnectorDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListCoreDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListCoreDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeviceDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeviceDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListFunctionDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListFunctionDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupCertificateAuthoritiesRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListLoggerDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListLoggerDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListResourceDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListResourceDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListSubscriptionDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListSubscriptionDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ResetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.StartBulkDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.StopBulkDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateConnectivityInfoRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateGroupCertificateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateSubscriptionDefinitionRequestMarshaller;

/**
 * Internal implementation of {@link GreengrassClient}.
 *
 * @see GreengrassClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGreengrassClient implements GreengrassClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGreengrassClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's
     * permissions should allow Greengrass core Lambda functions to perform actions against the cloud.
     *
     * @param associateRoleToGroupRequest
     * @return Result of the AssociateRoleToGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.AssociateRoleToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateRoleToGroupResponse associateRoleToGroup(AssociateRoleToGroupRequest associateRoleToGroupRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateRoleToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateRoleToGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<AssociateRoleToGroupRequest, AssociateRoleToGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(associateRoleToGroupRequest)
                .withMarshaller(new AssociateRoleToGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS
     * IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in
     * the policy ''AWSGreengrassResourceAccessRolePolicy''.
     *
     * @param associateServiceRoleToAccountRequest
     * @return Result of the AssociateServiceRoleToAccount operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.AssociateServiceRoleToAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateServiceRoleToAccountResponse associateServiceRoleToAccount(
            AssociateServiceRoleToAccountRequest associateServiceRoleToAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateServiceRoleToAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateServiceRoleToAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateServiceRoleToAccountRequest, AssociateServiceRoleToAccountResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(associateServiceRoleToAccountRequest)
                        .withMarshaller(new AssociateServiceRoleToAccountRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a connector definition. You may provide the initial version of the connector definition now or use
     * ''CreateConnectorDefinitionVersion'' at a later time.
     *
     * @param createConnectorDefinitionRequest
     * @return Result of the CreateConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConnectorDefinitionResponse createConnectorDefinition(
            CreateConnectorDefinitionRequest createConnectorDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConnectorDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateConnectorDefinitionRequest, CreateConnectorDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createConnectorDefinitionRequest)
                        .withMarshaller(new CreateConnectorDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a version of a connector definition which has already been defined.
     *
     * @param createConnectorDefinitionVersionRequest
     * @return Result of the CreateConnectorDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateConnectorDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConnectorDefinitionVersionResponse createConnectorDefinitionVersion(
            CreateConnectorDefinitionVersionRequest createConnectorDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectorDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConnectorDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateConnectorDefinitionVersionRequest, CreateConnectorDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createConnectorDefinitionVersionRequest)
                        .withMarshaller(new CreateConnectorDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a core definition. You may provide the initial version of the core definition now or use
     * ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.
     *
     * @param createCoreDefinitionRequest
     *        Information needed to create a core definition.
     * @return Result of the CreateCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCoreDefinitionResponse createCoreDefinition(CreateCoreDefinitionRequest createCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCoreDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateCoreDefinitionRequest, CreateCoreDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createCoreDefinitionRequest)
                .withMarshaller(new CreateCoreDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly
     * one Greengrass core.
     *
     * @param createCoreDefinitionVersionRequest
     * @return Result of the CreateCoreDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateCoreDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCoreDefinitionVersionResponse createCoreDefinitionVersion(
            CreateCoreDefinitionVersionRequest createCoreDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCoreDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCoreDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateCoreDefinitionVersionRequest, CreateCoreDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createCoreDefinitionVersionRequest)
                        .withMarshaller(new CreateCoreDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token''
     * token and the request parameters.
     *
     * @param createDeploymentRequest
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDeploymentRequest).withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a device definition. You may provide the initial version of the device definition now or use
     * ''CreateDeviceDefinitionVersion'' at a later time.
     *
     * @param createDeviceDefinitionRequest
     * @return Result of the CreateDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDeviceDefinitionResponse createDeviceDefinition(CreateDeviceDefinitionRequest createDeviceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDeviceDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateDeviceDefinitionRequest, CreateDeviceDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDeviceDefinitionRequest)
                .withMarshaller(new CreateDeviceDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a version of a device definition that has already been defined.
     *
     * @param createDeviceDefinitionVersionRequest
     * @return Result of the CreateDeviceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateDeviceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDeviceDefinitionVersionResponse createDeviceDefinitionVersion(
            CreateDeviceDefinitionVersionRequest createDeviceDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeviceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDeviceDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateDeviceDefinitionVersionRequest, CreateDeviceDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createDeviceDefinitionVersionRequest)
                        .withMarshaller(new CreateDeviceDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be
     * used in a group. You can create an initial version of the definition by providing a list of Lambda functions and
     * their configurations now, or use ''CreateFunctionDefinitionVersion'' later.
     *
     * @param createFunctionDefinitionRequest
     * @return Result of the CreateFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFunctionDefinitionResponse createFunctionDefinition(
            CreateFunctionDefinitionRequest createFunctionDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFunctionDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateFunctionDefinitionRequest, CreateFunctionDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createFunctionDefinitionRequest)
                        .withMarshaller(new CreateFunctionDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a version of a Lambda function definition that has already been defined.
     *
     * @param createFunctionDefinitionVersionRequest
     *        Information needed to create a function definition version.
     * @return Result of the CreateFunctionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateFunctionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFunctionDefinitionVersionResponse createFunctionDefinitionVersion(
            CreateFunctionDefinitionVersionRequest createFunctionDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFunctionDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFunctionDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateFunctionDefinitionVersionRequest, CreateFunctionDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createFunctionDefinitionVersionRequest)
                        .withMarshaller(new CreateFunctionDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time.
     * Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a
     * library or command-line application to create and deploy Greengrass groups.
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createGroupRequest).withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.
     *
     * @param createGroupCertificateAuthorityRequest
     * @return Result of the CreateGroupCertificateAuthority operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroupCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGroupCertificateAuthorityResponse createGroupCertificateAuthority(
            CreateGroupCertificateAuthorityRequest createGroupCertificateAuthorityRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupCertificateAuthorityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateGroupCertificateAuthorityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateGroupCertificateAuthorityRequest, CreateGroupCertificateAuthorityResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createGroupCertificateAuthorityRequest)
                        .withMarshaller(new CreateGroupCertificateAuthorityRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a version of a group which has already been defined.
     *
     * @param createGroupVersionRequest
     * @return Result of the CreateGroupVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateGroupVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateGroupVersionResponse createGroupVersion(CreateGroupVersionRequest createGroupVersionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateGroupVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateGroupVersionRequest, CreateGroupVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createGroupVersionRequest).withMarshaller(new CreateGroupVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a logger definition. You may provide the initial version of the logger definition now or use
     * ''CreateLoggerDefinitionVersion'' at a later time.
     *
     * @param createLoggerDefinitionRequest
     * @return Result of the CreateLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLoggerDefinitionResponse createLoggerDefinition(CreateLoggerDefinitionRequest createLoggerDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLoggerDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateLoggerDefinitionRequest, CreateLoggerDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createLoggerDefinitionRequest)
                .withMarshaller(new CreateLoggerDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a version of a logger definition that has already been defined.
     *
     * @param createLoggerDefinitionVersionRequest
     * @return Result of the CreateLoggerDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateLoggerDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLoggerDefinitionVersionResponse createLoggerDefinitionVersion(
            CreateLoggerDefinitionVersionRequest createLoggerDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLoggerDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLoggerDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateLoggerDefinitionVersionRequest, CreateLoggerDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createLoggerDefinitionVersionRequest)
                        .withMarshaller(new CreateLoggerDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial
     * version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
     *
     * @param createResourceDefinitionRequest
     * @return Result of the CreateResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourceDefinitionResponse createResourceDefinition(
            CreateResourceDefinitionRequest createResourceDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourceDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateResourceDefinitionRequest, CreateResourceDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createResourceDefinitionRequest)
                        .withMarshaller(new CreateResourceDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a version of a resource definition that has already been defined.
     *
     * @param createResourceDefinitionVersionRequest
     * @return Result of the CreateResourceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateResourceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourceDefinitionVersionResponse createResourceDefinitionVersion(
            CreateResourceDefinitionVersionRequest createResourceDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourceDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateResourceDefinitionVersionRequest, CreateResourceDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createResourceDefinitionVersionRequest)
                        .withMarshaller(new CreateResourceDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the
     * OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional
     * commands to manage a Greengrass core software update job.
     *
     * @param createSoftwareUpdateJobRequest
     * @return Result of the CreateSoftwareUpdateJob operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSoftwareUpdateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSoftwareUpdateJobResponse createSoftwareUpdateJob(CreateSoftwareUpdateJobRequest createSoftwareUpdateJobRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSoftwareUpdateJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSoftwareUpdateJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateSoftwareUpdateJobRequest, CreateSoftwareUpdateJobResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createSoftwareUpdateJobRequest)
                .withMarshaller(new CreateSoftwareUpdateJobRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a subscription definition. You may provide the initial version of the subscription definition now or use
     * ''CreateSubscriptionDefinitionVersion'' at a later time.
     *
     * @param createSubscriptionDefinitionRequest
     * @return Result of the CreateSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSubscriptionDefinitionResponse createSubscriptionDefinition(
            CreateSubscriptionDefinitionRequest createSubscriptionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSubscriptionDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateSubscriptionDefinitionRequest, CreateSubscriptionDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createSubscriptionDefinitionRequest)
                        .withMarshaller(new CreateSubscriptionDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Creates a version of a subscription definition which has already been defined.
     *
     * @param createSubscriptionDefinitionVersionRequest
     * @return Result of the CreateSubscriptionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.CreateSubscriptionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSubscriptionDefinitionVersionResponse createSubscriptionDefinitionVersion(
            CreateSubscriptionDefinitionVersionRequest createSubscriptionDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSubscriptionDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSubscriptionDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateSubscriptionDefinitionVersionRequest, CreateSubscriptionDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createSubscriptionDefinitionVersionRequest)
                        .withMarshaller(new CreateSubscriptionDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Deletes a connector definition.
     *
     * @param deleteConnectorDefinitionRequest
     * @return Result of the DeleteConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectorDefinitionResponse deleteConnectorDefinition(
            DeleteConnectorDefinitionRequest deleteConnectorDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConnectorDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteConnectorDefinitionRequest, DeleteConnectorDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteConnectorDefinitionRequest)
                        .withMarshaller(new DeleteConnectorDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Deletes a core definition.
     *
     * @param deleteCoreDefinitionRequest
     * @return Result of the DeleteCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCoreDefinitionResponse deleteCoreDefinition(DeleteCoreDefinitionRequest deleteCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCoreDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteCoreDefinitionRequest, DeleteCoreDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteCoreDefinitionRequest)
                .withMarshaller(new DeleteCoreDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Deletes a device definition.
     *
     * @param deleteDeviceDefinitionRequest
     * @return Result of the DeleteDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDeviceDefinitionResponse deleteDeviceDefinition(DeleteDeviceDefinitionRequest deleteDeviceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDeviceDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteDeviceDefinitionRequest, DeleteDeviceDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDeviceDefinitionRequest)
                .withMarshaller(new DeleteDeviceDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Deletes a Lambda function definition.
     *
     * @param deleteFunctionDefinitionRequest
     * @return Result of the DeleteFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFunctionDefinitionResponse deleteFunctionDefinition(
            DeleteFunctionDefinitionRequest deleteFunctionDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFunctionDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteFunctionDefinitionRequest, DeleteFunctionDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteFunctionDefinitionRequest)
                        .withMarshaller(new DeleteFunctionDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Deletes a group.
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteGroupRequest).withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * Deletes a logger definition.
     *
     * @param deleteLoggerDefinitionRequest
     * @return Result of the DeleteLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLoggerDefinitionResponse deleteLoggerDefinition(DeleteLoggerDefinitionRequest deleteLoggerDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLoggerDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteLoggerDefinitionRequest, DeleteLoggerDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteLoggerDefinitionRequest)
                .withMarshaller(new DeleteLoggerDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Deletes a resource definition.
     *
     * @param deleteResourceDefinitionRequest
     * @return Result of the DeleteResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourceDefinitionResponse deleteResourceDefinition(
            DeleteResourceDefinitionRequest deleteResourceDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourceDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteResourceDefinitionRequest, DeleteResourceDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteResourceDefinitionRequest)
                        .withMarshaller(new DeleteResourceDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Deletes a subscription definition.
     *
     * @param deleteSubscriptionDefinitionRequest
     * @return Result of the DeleteSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DeleteSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSubscriptionDefinitionResponse deleteSubscriptionDefinition(
            DeleteSubscriptionDefinitionRequest deleteSubscriptionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSubscriptionDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteSubscriptionDefinitionRequest, DeleteSubscriptionDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteSubscriptionDefinitionRequest)
                        .withMarshaller(new DeleteSubscriptionDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Disassociates the role from a group.
     *
     * @param disassociateRoleFromGroupRequest
     * @return Result of the DisassociateRoleFromGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DisassociateRoleFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateRoleFromGroupResponse disassociateRoleFromGroup(
            DisassociateRoleFromGroupRequest disassociateRoleFromGroupRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateRoleFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateRoleFromGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateRoleFromGroupRequest, DisassociateRoleFromGroupResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(disassociateRoleFromGroupRequest)
                        .withMarshaller(new DisassociateRoleFromGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.
     *
     * @param disassociateServiceRoleFromAccountRequest
     * @return Result of the DisassociateServiceRoleFromAccount operation returned by the service.
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.DisassociateServiceRoleFromAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateServiceRoleFromAccountResponse disassociateServiceRoleFromAccount(
            DisassociateServiceRoleFromAccountRequest disassociateServiceRoleFromAccountRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateServiceRoleFromAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateServiceRoleFromAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateServiceRoleFromAccountRequest, DisassociateServiceRoleFromAccountResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(disassociateServiceRoleFromAccountRequest)
                        .withMarshaller(new DisassociateServiceRoleFromAccountRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves the role associated with a particular group.
     *
     * @param getAssociatedRoleRequest
     * @return Result of the GetAssociatedRole operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetAssociatedRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetAssociatedRoleResponse getAssociatedRole(GetAssociatedRoleRequest getAssociatedRoleRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAssociatedRoleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAssociatedRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAssociatedRoleRequest, GetAssociatedRoleResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getAssociatedRoleRequest).withMarshaller(new GetAssociatedRoleRequestMarshaller(protocolFactory)));
    }

    /**
     * Returns the status of a bulk deployment.
     *
     * @param getBulkDeploymentStatusRequest
     * @return Result of the GetBulkDeploymentStatus operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetBulkDeploymentStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBulkDeploymentStatusResponse getBulkDeploymentStatus(GetBulkDeploymentStatusRequest getBulkDeploymentStatusRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBulkDeploymentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBulkDeploymentStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetBulkDeploymentStatusRequest, GetBulkDeploymentStatusResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBulkDeploymentStatusRequest)
                .withMarshaller(new GetBulkDeploymentStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves the connectivity information for a core.
     *
     * @param getConnectivityInfoRequest
     * @return Result of the GetConnectivityInfo operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectivityInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetConnectivityInfoResponse getConnectivityInfo(GetConnectivityInfoRequest getConnectivityInfoRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConnectivityInfoResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConnectivityInfoResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetConnectivityInfoRequest, GetConnectivityInfoResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getConnectivityInfoRequest).withMarshaller(new GetConnectivityInfoRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a connector definition.
     *
     * @param getConnectorDefinitionRequest
     * @return Result of the GetConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConnectorDefinitionResponse getConnectorDefinition(GetConnectorDefinitionRequest getConnectorDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConnectorDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetConnectorDefinitionRequest, GetConnectorDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getConnectorDefinitionRequest)
                .withMarshaller(new GetConnectorDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a connector definition version, including the connectors that the version contains.
     * Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud
     * services.
     *
     * @param getConnectorDefinitionVersionRequest
     * @return Result of the GetConnectorDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetConnectorDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConnectorDefinitionVersionResponse getConnectorDefinitionVersion(
            GetConnectorDefinitionVersionRequest getConnectorDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConnectorDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConnectorDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetConnectorDefinitionVersionRequest, GetConnectorDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getConnectorDefinitionVersionRequest)
                        .withMarshaller(new GetConnectorDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionRequest
     * @return Result of the GetCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCoreDefinitionResponse getCoreDefinition(GetCoreDefinitionRequest getCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCoreDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCoreDefinitionRequest, GetCoreDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getCoreDefinitionRequest).withMarshaller(new GetCoreDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionVersionRequest
     * @return Result of the GetCoreDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetCoreDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCoreDefinitionVersionResponse getCoreDefinitionVersion(
            GetCoreDefinitionVersionRequest getCoreDefinitionVersionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCoreDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCoreDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetCoreDefinitionVersionRequest, GetCoreDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getCoreDefinitionVersionRequest)
                        .withMarshaller(new GetCoreDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Returns the status of a deployment.
     *
     * @param getDeploymentStatusRequest
     * @return Result of the GetDeploymentStatus operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeploymentStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDeploymentStatusResponse getDeploymentStatus(GetDeploymentStatusRequest getDeploymentStatusRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeploymentStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentStatusRequest, GetDeploymentStatusResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDeploymentStatusRequest).withMarshaller(new GetDeploymentStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a device definition.
     *
     * @param getDeviceDefinitionRequest
     * @return Result of the GetDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDeviceDefinitionResponse getDeviceDefinition(GetDeviceDefinitionRequest getDeviceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeviceDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDeviceDefinitionRequest, GetDeviceDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDeviceDefinitionRequest).withMarshaller(new GetDeviceDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a device definition version.
     *
     * @param getDeviceDefinitionVersionRequest
     * @return Result of the GetDeviceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetDeviceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeviceDefinitionVersionResponse getDeviceDefinitionVersion(
            GetDeviceDefinitionVersionRequest getDeviceDefinitionVersionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeviceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeviceDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetDeviceDefinitionVersionRequest, GetDeviceDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getDeviceDefinitionVersionRequest)
                        .withMarshaller(new GetDeviceDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a Lambda function definition, including its creation time and latest version.
     *
     * @param getFunctionDefinitionRequest
     * @return Result of the GetFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFunctionDefinitionResponse getFunctionDefinition(GetFunctionDefinitionRequest getFunctionDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetFunctionDefinitionRequest, GetFunctionDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getFunctionDefinitionRequest)
                .withMarshaller(new GetFunctionDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a Lambda function definition version, including which Lambda functions are included
     * in the version and their configurations.
     *
     * @param getFunctionDefinitionVersionRequest
     * @return Result of the GetFunctionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetFunctionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFunctionDefinitionVersionResponse getFunctionDefinitionVersion(
            GetFunctionDefinitionVersionRequest getFunctionDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetFunctionDefinitionVersionRequest, GetFunctionDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getFunctionDefinitionVersionRequest)
                        .withMarshaller(new GetFunctionDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a group.
     *
     * @param getGroupRequest
     * @return Result of the GetGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getGroupRequest)
                .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * Retreives the CA associated with a group. Returns the public key of the CA.
     *
     * @param getGroupCertificateAuthorityRequest
     * @return Result of the GetGroupCertificateAuthority operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGroupCertificateAuthorityResponse getGroupCertificateAuthority(
            GetGroupCertificateAuthorityRequest getGroupCertificateAuthorityRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGroupCertificateAuthorityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetGroupCertificateAuthorityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetGroupCertificateAuthorityRequest, GetGroupCertificateAuthorityResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getGroupCertificateAuthorityRequest)
                        .withMarshaller(new GetGroupCertificateAuthorityRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves the current configuration for the CA used by the group.
     *
     * @param getGroupCertificateConfigurationRequest
     * @return Result of the GetGroupCertificateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupCertificateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGroupCertificateConfigurationResponse getGroupCertificateConfiguration(
            GetGroupCertificateConfigurationRequest getGroupCertificateConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGroupCertificateConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetGroupCertificateConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetGroupCertificateConfigurationRequest, GetGroupCertificateConfigurationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getGroupCertificateConfigurationRequest)
                        .withMarshaller(new GetGroupCertificateConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a group version.
     *
     * @param getGroupVersionRequest
     * @return Result of the GetGroupVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetGroupVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGroupVersionResponse getGroupVersion(GetGroupVersionRequest getGroupVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGroupVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGroupVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetGroupVersionRequest, GetGroupVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getGroupVersionRequest).withMarshaller(new GetGroupVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a logger definition.
     *
     * @param getLoggerDefinitionRequest
     * @return Result of the GetLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLoggerDefinitionResponse getLoggerDefinition(GetLoggerDefinitionRequest getLoggerDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLoggerDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetLoggerDefinitionRequest, GetLoggerDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getLoggerDefinitionRequest).withMarshaller(new GetLoggerDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a logger definition version.
     *
     * @param getLoggerDefinitionVersionRequest
     * @return Result of the GetLoggerDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetLoggerDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLoggerDefinitionVersionResponse getLoggerDefinitionVersion(
            GetLoggerDefinitionVersionRequest getLoggerDefinitionVersionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLoggerDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLoggerDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetLoggerDefinitionVersionRequest, GetLoggerDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getLoggerDefinitionVersionRequest)
                        .withMarshaller(new GetLoggerDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a resource definition, including its creation time and latest version.
     *
     * @param getResourceDefinitionRequest
     * @return Result of the GetResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourceDefinitionResponse getResourceDefinition(GetResourceDefinitionRequest getResourceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetResourceDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetResourceDefinitionRequest, GetResourceDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getResourceDefinitionRequest)
                .withMarshaller(new GetResourceDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a resource definition version, including which resources are included in the version.
     *
     * @param getResourceDefinitionVersionRequest
     * @return Result of the GetResourceDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetResourceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourceDefinitionVersionResponse getResourceDefinitionVersion(
            GetResourceDefinitionVersionRequest getResourceDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetResourceDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetResourceDefinitionVersionRequest, GetResourceDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getResourceDefinitionVersionRequest)
                        .withMarshaller(new GetResourceDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves the service role that is attached to your account.
     *
     * @param getServiceRoleForAccountRequest
     * @return Result of the GetServiceRoleForAccount operation returned by the service.
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetServiceRoleForAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetServiceRoleForAccountResponse getServiceRoleForAccount(
            GetServiceRoleForAccountRequest getServiceRoleForAccountRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetServiceRoleForAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetServiceRoleForAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetServiceRoleForAccountRequest, GetServiceRoleForAccountResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getServiceRoleForAccountRequest)
                        .withMarshaller(new GetServiceRoleForAccountRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a subscription definition.
     *
     * @param getSubscriptionDefinitionRequest
     * @return Result of the GetSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSubscriptionDefinitionResponse getSubscriptionDefinition(
            GetSubscriptionDefinitionRequest getSubscriptionDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSubscriptionDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetSubscriptionDefinitionRequest, GetSubscriptionDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getSubscriptionDefinitionRequest)
                        .withMarshaller(new GetSubscriptionDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves information about a subscription definition version.
     *
     * @param getSubscriptionDefinitionVersionRequest
     * @return Result of the GetSubscriptionDefinitionVersion operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.GetSubscriptionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSubscriptionDefinitionVersionResponse getSubscriptionDefinitionVersion(
            GetSubscriptionDefinitionVersionRequest getSubscriptionDefinitionVersionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSubscriptionDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSubscriptionDefinitionVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetSubscriptionDefinitionVersionRequest, GetSubscriptionDefinitionVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getSubscriptionDefinitionVersionRequest)
                        .withMarshaller(new GetSubscriptionDefinitionVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current
     * deployment status.
     *
     * @param listBulkDeploymentDetailedReportsRequest
     * @return Result of the ListBulkDeploymentDetailedReports operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListBulkDeploymentDetailedReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBulkDeploymentDetailedReportsResponse listBulkDeploymentDetailedReports(
            ListBulkDeploymentDetailedReportsRequest listBulkDeploymentDetailedReportsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBulkDeploymentDetailedReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBulkDeploymentDetailedReportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListBulkDeploymentDetailedReportsRequest, ListBulkDeploymentDetailedReportsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listBulkDeploymentDetailedReportsRequest)
                        .withMarshaller(new ListBulkDeploymentDetailedReportsRequestMarshaller(protocolFactory)));
    }

    /**
     * Returns a list of bulk deployments.
     *
     * @param listBulkDeploymentsRequest
     * @return Result of the ListBulkDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListBulkDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBulkDeploymentsResponse listBulkDeployments(ListBulkDeploymentsRequest listBulkDeploymentsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBulkDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBulkDeploymentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListBulkDeploymentsRequest, ListBulkDeploymentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listBulkDeploymentsRequest).withMarshaller(new ListBulkDeploymentsRequestMarshaller(protocolFactory)));
    }

    /**
     * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the
     * Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other
     * cloud services.
     *
     * @param listConnectorDefinitionVersionsRequest
     * @return Result of the ListConnectorDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListConnectorDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConnectorDefinitionVersionsResponse listConnectorDefinitionVersions(
            ListConnectorDefinitionVersionsRequest listConnectorDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConnectorDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListConnectorDefinitionVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListConnectorDefinitionVersionsRequest, ListConnectorDefinitionVersionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listConnectorDefinitionVersionsRequest)
                        .withMarshaller(new ListConnectorDefinitionVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves a list of connector definitions.
     *
     * @param listConnectorDefinitionsRequest
     * @return Result of the ListConnectorDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListConnectorDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConnectorDefinitionsResponse listConnectorDefinitions(
            ListConnectorDefinitionsRequest listConnectorDefinitionsRequest) throws AwsServiceException, SdkClientException,
            GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConnectorDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListConnectorDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListConnectorDefinitionsRequest, ListConnectorDefinitionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listConnectorDefinitionsRequest)
                        .withMarshaller(new ListConnectorDefinitionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Lists the versions of a core definition.
     *
     * @param listCoreDefinitionVersionsRequest
     * @return Result of the ListCoreDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListCoreDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCoreDefinitionVersionsResponse listCoreDefinitionVersions(
            ListCoreDefinitionVersionsRequest listCoreDefinitionVersionsRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCoreDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCoreDefinitionVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListCoreDefinitionVersionsRequest, ListCoreDefinitionVersionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listCoreDefinitionVersionsRequest)
                        .withMarshaller(new ListCoreDefinitionVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves a list of core definitions.
     *
     * @param listCoreDefinitionsRequest
     * @return Result of the ListCoreDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListCoreDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCoreDefinitionsResponse listCoreDefinitions(ListCoreDefinitionsRequest listCoreDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCoreDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCoreDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListCoreDefinitionsRequest, ListCoreDefinitionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listCoreDefinitionsRequest).withMarshaller(new ListCoreDefinitionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Returns a history of deployments for the group.
     *
     * @param listDeploymentsRequest
     * @return Result of the ListDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDeploymentsResponse listDeployments(ListDeploymentsRequest listDeploymentsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDeploymentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListDeploymentsRequest, ListDeploymentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDeploymentsRequest).withMarshaller(new ListDeploymentsRequestMarshaller(protocolFactory)));
    }

    /**
     * Lists the versions of a device definition.
     *
     * @param listDeviceDefinitionVersionsRequest
     * @return Result of the ListDeviceDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeviceDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeviceDefinitionVersionsResponse listDeviceDefinitionVersions(
            ListDeviceDefinitionVersionsRequest listDeviceDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeviceDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDeviceDefinitionVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListDeviceDefinitionVersionsRequest, ListDeviceDefinitionVersionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listDeviceDefinitionVersionsRequest)
                        .withMarshaller(new ListDeviceDefinitionVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves a list of device definitions.
     *
     * @param listDeviceDefinitionsRequest
     * @return Result of the ListDeviceDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListDeviceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeviceDefinitionsResponse listDeviceDefinitions(ListDeviceDefinitionsRequest listDeviceDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeviceDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDeviceDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListDeviceDefinitionsRequest, ListDeviceDefinitionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDeviceDefinitionsRequest)
                .withMarshaller(new ListDeviceDefinitionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Lists the versions of a Lambda function definition.
     *
     * @param listFunctionDefinitionVersionsRequest
     * @return Result of the ListFunctionDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListFunctionDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFunctionDefinitionVersionsResponse listFunctionDefinitionVersions(
            ListFunctionDefinitionVersionsRequest listFunctionDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFunctionDefinitionVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListFunctionDefinitionVersionsRequest, ListFunctionDefinitionVersionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listFunctionDefinitionVersionsRequest)
                        .withMarshaller(new ListFunctionDefinitionVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves a list of Lambda function definitions.
     *
     * @param listFunctionDefinitionsRequest
     * @return Result of the ListFunctionDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListFunctionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFunctionDefinitionsResponse listFunctionDefinitions(ListFunctionDefinitionsRequest listFunctionDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFunctionDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListFunctionDefinitionsRequest, ListFunctionDefinitionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listFunctionDefinitionsRequest)
                .withMarshaller(new ListFunctionDefinitionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves the current CAs for a group.
     *
     * @param listGroupCertificateAuthoritiesRequest
     * @return Result of the ListGroupCertificateAuthorities operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroupCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGroupCertificateAuthoritiesResponse listGroupCertificateAuthorities(
            ListGroupCertificateAuthoritiesRequest listGroupCertificateAuthoritiesRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupCertificateAuthoritiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListGroupCertificateAuthoritiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListGroupCertificateAuthoritiesRequest, ListGroupCertificateAuthoritiesResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listGroupCertificateAuthoritiesRequest)
                        .withMarshaller(new ListGroupCertificateAuthoritiesRequestMarshaller(protocolFactory)));
    }

    /**
     * Lists the versions of a group.
     *
     * @param listGroupVersionsRequest
     * @return Result of the ListGroupVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroupVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListGroupVersionsResponse listGroupVersions(ListGroupVersionsRequest listGroupVersionsRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGroupVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListGroupVersionsRequest, ListGroupVersionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listGroupVersionsRequest).withMarshaller(new ListGroupVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves a list of groups.
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws AwsServiceException, SdkClientException,
            GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listGroupsRequest)
                .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory)));
    }

    /**
     * Lists the versions of a logger definition.
     *
     * @param listLoggerDefinitionVersionsRequest
     * @return Result of the ListLoggerDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListLoggerDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLoggerDefinitionVersionsResponse listLoggerDefinitionVersions(
            ListLoggerDefinitionVersionsRequest listLoggerDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLoggerDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLoggerDefinitionVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListLoggerDefinitionVersionsRequest, ListLoggerDefinitionVersionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listLoggerDefinitionVersionsRequest)
                        .withMarshaller(new ListLoggerDefinitionVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves a list of logger definitions.
     *
     * @param listLoggerDefinitionsRequest
     * @return Result of the ListLoggerDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListLoggerDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLoggerDefinitionsResponse listLoggerDefinitions(ListLoggerDefinitionsRequest listLoggerDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLoggerDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLoggerDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListLoggerDefinitionsRequest, ListLoggerDefinitionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listLoggerDefinitionsRequest)
                .withMarshaller(new ListLoggerDefinitionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Lists the versions of a resource definition.
     *
     * @param listResourceDefinitionVersionsRequest
     * @return Result of the ListResourceDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListResourceDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceDefinitionVersionsResponse listResourceDefinitionVersions(
            ListResourceDefinitionVersionsRequest listResourceDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourceDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourceDefinitionVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListResourceDefinitionVersionsRequest, ListResourceDefinitionVersionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listResourceDefinitionVersionsRequest)
                        .withMarshaller(new ListResourceDefinitionVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves a list of resource definitions.
     *
     * @param listResourceDefinitionsRequest
     * @return Result of the ListResourceDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListResourceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceDefinitionsResponse listResourceDefinitions(ListResourceDefinitionsRequest listResourceDefinitionsRequest)
            throws AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourceDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourceDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListResourceDefinitionsRequest, ListResourceDefinitionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listResourceDefinitionsRequest)
                .withMarshaller(new ListResourceDefinitionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Lists the versions of a subscription definition.
     *
     * @param listSubscriptionDefinitionVersionsRequest
     * @return Result of the ListSubscriptionDefinitionVersions operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListSubscriptionDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSubscriptionDefinitionVersionsResponse listSubscriptionDefinitionVersions(
            ListSubscriptionDefinitionVersionsRequest listSubscriptionDefinitionVersionsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSubscriptionDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSubscriptionDefinitionVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListSubscriptionDefinitionVersionsRequest, ListSubscriptionDefinitionVersionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listSubscriptionDefinitionVersionsRequest)
                        .withMarshaller(new ListSubscriptionDefinitionVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Retrieves a list of subscription definitions.
     *
     * @param listSubscriptionDefinitionsRequest
     * @return Result of the ListSubscriptionDefinitions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ListSubscriptionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSubscriptionDefinitionsResponse listSubscriptionDefinitions(
            ListSubscriptionDefinitionsRequest listSubscriptionDefinitionsRequest) throws AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSubscriptionDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSubscriptionDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListSubscriptionDefinitionsRequest, ListSubscriptionDefinitionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listSubscriptionDefinitionsRequest)
                        .withMarshaller(new ListSubscriptionDefinitionsRequestMarshaller(protocolFactory)));
    }

    /**
     * Resets a group's deployments.
     *
     * @param resetDeploymentsRequest
     *        Information needed to reset deployments.
     * @return Result of the ResetDeployments operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.ResetDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ResetDeploymentsResponse resetDeployments(ResetDeploymentsRequest resetDeploymentsRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ResetDeploymentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ResetDeploymentsRequest, ResetDeploymentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(resetDeploymentsRequest).withMarshaller(new ResetDeploymentsRequestMarshaller(protocolFactory)));
    }

    /**
     * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group
     * versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We
     * recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These
     * requests are idempotent with respect to the token and the request parameters.
     *
     * @param startBulkDeploymentRequest
     * @return Result of the StartBulkDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.StartBulkDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartBulkDeploymentResponse startBulkDeployment(StartBulkDeploymentRequest startBulkDeploymentRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartBulkDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartBulkDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StartBulkDeploymentRequest, StartBulkDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(startBulkDeploymentRequest).withMarshaller(new StartBulkDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is
     * stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This
     * action doesn't rollback completed deployments or cancel pending deployments.
     *
     * @param stopBulkDeploymentRequest
     * @return Result of the StopBulkDeployment operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.StopBulkDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StopBulkDeploymentResponse stopBulkDeployment(StopBulkDeploymentRequest stopBulkDeploymentRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopBulkDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopBulkDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StopBulkDeploymentRequest, StopBulkDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(stopBulkDeploymentRequest).withMarshaller(new StopBulkDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates the connectivity information for the core. Any devices that belong to the group which has this core will
     * receive this information in order to find the location of the core and connect to it.
     *
     * @param updateConnectivityInfoRequest
     *        Connectivity information.
     * @return Result of the UpdateConnectivityInfo operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateConnectivityInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConnectivityInfoResponse updateConnectivityInfo(UpdateConnectivityInfoRequest updateConnectivityInfoRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectivityInfoResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConnectivityInfoResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateConnectivityInfoRequest, UpdateConnectivityInfoResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateConnectivityInfoRequest)
                .withMarshaller(new UpdateConnectivityInfoRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates a connector definition.
     *
     * @param updateConnectorDefinitionRequest
     * @return Result of the UpdateConnectorDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConnectorDefinitionResponse updateConnectorDefinition(
            UpdateConnectorDefinitionRequest updateConnectorDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConnectorDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateConnectorDefinitionRequest, UpdateConnectorDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateConnectorDefinitionRequest)
                        .withMarshaller(new UpdateConnectorDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates a core definition.
     *
     * @param updateCoreDefinitionRequest
     * @return Result of the UpdateCoreDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCoreDefinitionResponse updateCoreDefinition(UpdateCoreDefinitionRequest updateCoreDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCoreDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateCoreDefinitionRequest, UpdateCoreDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateCoreDefinitionRequest)
                .withMarshaller(new UpdateCoreDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates a device definition.
     *
     * @param updateDeviceDefinitionRequest
     * @return Result of the UpdateDeviceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDeviceDefinitionResponse updateDeviceDefinition(UpdateDeviceDefinitionRequest updateDeviceDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDeviceDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateDeviceDefinitionRequest, UpdateDeviceDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateDeviceDefinitionRequest)
                .withMarshaller(new UpdateDeviceDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates a Lambda function definition.
     *
     * @param updateFunctionDefinitionRequest
     * @return Result of the UpdateFunctionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFunctionDefinitionResponse updateFunctionDefinition(
            UpdateFunctionDefinitionRequest updateFunctionDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFunctionDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateFunctionDefinitionRequest, UpdateFunctionDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateFunctionDefinitionRequest)
                        .withMarshaller(new UpdateFunctionDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates a group.
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateGroupRequest).withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates the Certificate expiry time for a group.
     *
     * @param updateGroupCertificateConfigurationRequest
     * @return Result of the UpdateGroupCertificateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws InternalServerErrorException
     *         server error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateGroupCertificateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGroupCertificateConfigurationResponse updateGroupCertificateConfiguration(
            UpdateGroupCertificateConfigurationRequest updateGroupCertificateConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGroupCertificateConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateGroupCertificateConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateGroupCertificateConfigurationRequest, UpdateGroupCertificateConfigurationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateGroupCertificateConfigurationRequest)
                        .withMarshaller(new UpdateGroupCertificateConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates a logger definition.
     *
     * @param updateLoggerDefinitionRequest
     * @return Result of the UpdateLoggerDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateLoggerDefinitionResponse updateLoggerDefinition(UpdateLoggerDefinitionRequest updateLoggerDefinitionRequest)
            throws BadRequestException, AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLoggerDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateLoggerDefinitionRequest, UpdateLoggerDefinitionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateLoggerDefinitionRequest)
                .withMarshaller(new UpdateLoggerDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates a resource definition.
     *
     * @param updateResourceDefinitionRequest
     * @return Result of the UpdateResourceDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateResourceDefinitionResponse updateResourceDefinition(
            UpdateResourceDefinitionRequest updateResourceDefinitionRequest) throws BadRequestException, AwsServiceException,
            SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateResourceDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateResourceDefinitionRequest, UpdateResourceDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateResourceDefinitionRequest)
                        .withMarshaller(new UpdateResourceDefinitionRequestMarshaller(protocolFactory)));
    }

    /**
     * Updates a subscription definition.
     *
     * @param updateSubscriptionDefinitionRequest
     * @return Result of the UpdateSubscriptionDefinition operation returned by the service.
     * @throws BadRequestException
     *         invalid request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GreengrassException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GreengrassClient.UpdateSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSubscriptionDefinitionResponse updateSubscriptionDefinition(
            UpdateSubscriptionDefinitionRequest updateSubscriptionDefinitionRequest) throws BadRequestException,
            AwsServiceException, SdkClientException, GreengrassException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSubscriptionDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateSubscriptionDefinitionRequest, UpdateSubscriptionDefinitionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateSubscriptionDefinitionRequest)
                        .withMarshaller(new UpdateSubscriptionDefinitionRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(GreengrassException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
