/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceDefinitionVersionResponse extends GreengrassResponse implements
        ToCopyableBuilder<GetDeviceDefinitionVersionResponse.Builder, GetDeviceDefinitionVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeviceDefinitionVersionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeviceDefinitionVersionResponse::creationTimestamp)).setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<DeviceDefinitionVersion> DEFINITION_FIELD = SdkField
            .<DeviceDefinitionVersion> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetDeviceDefinitionVersionResponse::definition)).setter(setter(Builder::definition))
            .constructor(DeviceDefinitionVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeviceDefinitionVersionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeviceDefinitionVersionResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeviceDefinitionVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIMESTAMP_FIELD, DEFINITION_FIELD, ID_FIELD, NEXT_TOKEN_FIELD, VERSION_FIELD));

    private final String arn;

    private final String creationTimestamp;

    private final DeviceDefinitionVersion definition;

    private final String id;

    private final String nextToken;

    private final String version;

    private GetDeviceDefinitionVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTimestamp = builder.creationTimestamp;
        this.definition = builder.definition;
        this.id = builder.id;
        this.nextToken = builder.nextToken;
        this.version = builder.version;
    }

    /**
     * The ARN of the device definition version.
     * 
     * @return The ARN of the device definition version.
     */
    public String arn() {
        return arn;
    }

    /**
     * The time, in milliseconds since the epoch, when the device definition version was created.
     * 
     * @return The time, in milliseconds since the epoch, when the device definition version was created.
     */
    public String creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * Information about the device definition version.
     * 
     * @return Information about the device definition version.
     */
    public DeviceDefinitionVersion definition() {
        return definition;
    }

    /**
     * The ID of the device definition version.
     * 
     * @return The ID of the device definition version.
     */
    public String id() {
        return id;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * The version of the device definition version.
     * 
     * @return The version of the device definition version.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceDefinitionVersionResponse)) {
            return false;
        }
        GetDeviceDefinitionVersionResponse other = (GetDeviceDefinitionVersionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(definition(), other.definition()) && Objects.equals(id(), other.id())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDeviceDefinitionVersionResponse").add("Arn", arn())
                .add("CreationTimestamp", creationTimestamp()).add("Definition", definition()).add("Id", id())
                .add("NextToken", nextToken()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceDefinitionVersionResponse, T> g) {
        return obj -> g.apply((GetDeviceDefinitionVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeviceDefinitionVersionResponse> {
        /**
         * The ARN of the device definition version.
         * 
         * @param arn
         *        The ARN of the device definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The time, in milliseconds since the epoch, when the device definition version was created.
         * 
         * @param creationTimestamp
         *        The time, in milliseconds since the epoch, when the device definition version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(String creationTimestamp);

        /**
         * Information about the device definition version.
         * 
         * @param definition
         *        Information about the device definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(DeviceDefinitionVersion definition);

        /**
         * Information about the device definition version. This is a convenience that creates an instance of the
         * {@link DeviceDefinitionVersion.Builder} avoiding the need to create one manually via
         * {@link DeviceDefinitionVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceDefinitionVersion.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(DeviceDefinitionVersion)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link DeviceDefinitionVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(DeviceDefinitionVersion)
         */
        default Builder definition(Consumer<DeviceDefinitionVersion.Builder> definition) {
            return definition(DeviceDefinitionVersion.builder().applyMutation(definition).build());
        }

        /**
         * The ID of the device definition version.
         * 
         * @param id
         *        The ID of the device definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The version of the device definition version.
         * 
         * @param version
         *        The version of the device definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String arn;

        private String creationTimestamp;

        private DeviceDefinitionVersion definition;

        private String id;

        private String nextToken;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceDefinitionVersionResponse model) {
            super(model);
            arn(model.arn);
            creationTimestamp(model.creationTimestamp);
            definition(model.definition);
            id(model.id);
            nextToken(model.nextToken);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final DeviceDefinitionVersion.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DeviceDefinitionVersion definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DeviceDefinitionVersion.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public GetDeviceDefinitionVersionResponse build() {
            return new GetDeviceDefinitionVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
