/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<GetFunctionDefinitionVersionRequest.Builder, GetFunctionDefinitionVersionRequest> {
    private static final SdkField<String> FUNCTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFunctionDefinitionVersionRequest::functionDefinitionId))
            .setter(setter(Builder::functionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionDefinitionId").build()).build();

    private static final SdkField<String> FUNCTION_DEFINITION_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetFunctionDefinitionVersionRequest::functionDefinitionVersionId))
            .setter(setter(Builder::functionDefinitionVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionDefinitionVersionId").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFunctionDefinitionVersionRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_DEFINITION_ID_FIELD,
            FUNCTION_DEFINITION_VERSION_ID_FIELD, NEXT_TOKEN_FIELD));

    private final String functionDefinitionId;

    private final String functionDefinitionVersionId;

    private final String nextToken;

    private GetFunctionDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.functionDefinitionId = builder.functionDefinitionId;
        this.functionDefinitionVersionId = builder.functionDefinitionVersionId;
        this.nextToken = builder.nextToken;
    }

    /**
     * The ID of the Lambda function definition.
     * 
     * @return The ID of the Lambda function definition.
     */
    public String functionDefinitionId() {
        return functionDefinitionId;
    }

    /**
     * The ID of the function definition version.
     * 
     * @return The ID of the function definition version.
     */
    public String functionDefinitionVersionId() {
        return functionDefinitionVersionId;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(functionDefinitionVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionDefinitionVersionRequest)) {
            return false;
        }
        GetFunctionDefinitionVersionRequest other = (GetFunctionDefinitionVersionRequest) obj;
        return Objects.equals(functionDefinitionId(), other.functionDefinitionId())
                && Objects.equals(functionDefinitionVersionId(), other.functionDefinitionVersionId())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetFunctionDefinitionVersionRequest").add("FunctionDefinitionId", functionDefinitionId())
                .add("FunctionDefinitionVersionId", functionDefinitionVersionId()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionDefinitionId":
            return Optional.ofNullable(clazz.cast(functionDefinitionId()));
        case "FunctionDefinitionVersionId":
            return Optional.ofNullable(clazz.cast(functionDefinitionVersionId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionDefinitionVersionRequest, T> g) {
        return obj -> g.apply((GetFunctionDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFunctionDefinitionVersionRequest> {
        /**
         * The ID of the Lambda function definition.
         * 
         * @param functionDefinitionId
         *        The ID of the Lambda function definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionDefinitionId(String functionDefinitionId);

        /**
         * The ID of the function definition version.
         * 
         * @param functionDefinitionVersionId
         *        The ID of the function definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionDefinitionVersionId(String functionDefinitionVersionId);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String functionDefinitionId;

        private String functionDefinitionVersionId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionDefinitionVersionRequest model) {
            super(model);
            functionDefinitionId(model.functionDefinitionId);
            functionDefinitionVersionId(model.functionDefinitionVersionId);
            nextToken(model.nextToken);
        }

        public final String getFunctionDefinitionId() {
            return functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        public final String getFunctionDefinitionVersionId() {
            return functionDefinitionVersionId;
        }

        @Override
        public final Builder functionDefinitionVersionId(String functionDefinitionVersionId) {
            this.functionDefinitionVersionId = functionDefinitionVersionId;
            return this;
        }

        public final void setFunctionDefinitionVersionId(String functionDefinitionVersionId) {
            this.functionDefinitionVersionId = functionDefinitionVersionId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFunctionDefinitionVersionRequest build() {
            return new GetFunctionDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
