/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupCertificateAuthoritiesResponse extends GreengrassResponse implements
        ToCopyableBuilder<ListGroupCertificateAuthoritiesResponse.Builder, ListGroupCertificateAuthoritiesResponse> {
    private static final SdkField<List<GroupCertificateAuthorityProperties>> GROUP_CERTIFICATE_AUTHORITIES_FIELD = SdkField
            .<List<GroupCertificateAuthorityProperties>> builder(MarshallingType.LIST)
            .getter(getter(ListGroupCertificateAuthoritiesResponse::groupCertificateAuthorities))
            .setter(setter(Builder::groupCertificateAuthorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupCertificateAuthorities")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupCertificateAuthorityProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupCertificateAuthorityProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GROUP_CERTIFICATE_AUTHORITIES_FIELD));

    private final List<GroupCertificateAuthorityProperties> groupCertificateAuthorities;

    private ListGroupCertificateAuthoritiesResponse(BuilderImpl builder) {
        super(builder);
        this.groupCertificateAuthorities = builder.groupCertificateAuthorities;
    }

    /**
     * A list of certificate authorities associated with the group.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of certificate authorities associated with the group.
     */
    public List<GroupCertificateAuthorityProperties> groupCertificateAuthorities() {
        return groupCertificateAuthorities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupCertificateAuthorities());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupCertificateAuthoritiesResponse)) {
            return false;
        }
        ListGroupCertificateAuthoritiesResponse other = (ListGroupCertificateAuthoritiesResponse) obj;
        return Objects.equals(groupCertificateAuthorities(), other.groupCertificateAuthorities());
    }

    @Override
    public String toString() {
        return ToString.builder("ListGroupCertificateAuthoritiesResponse")
                .add("GroupCertificateAuthorities", groupCertificateAuthorities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupCertificateAuthorities":
            return Optional.ofNullable(clazz.cast(groupCertificateAuthorities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupCertificateAuthoritiesResponse, T> g) {
        return obj -> g.apply((ListGroupCertificateAuthoritiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupCertificateAuthoritiesResponse> {
        /**
         * A list of certificate authorities associated with the group.
         * 
         * @param groupCertificateAuthorities
         *        A list of certificate authorities associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupCertificateAuthorities(Collection<GroupCertificateAuthorityProperties> groupCertificateAuthorities);

        /**
         * A list of certificate authorities associated with the group.
         * 
         * @param groupCertificateAuthorities
         *        A list of certificate authorities associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupCertificateAuthorities(GroupCertificateAuthorityProperties... groupCertificateAuthorities);

        /**
         * A list of certificate authorities associated with the group. This is a convenience that creates an instance
         * of the {@link List<GroupCertificateAuthorityProperties>.Builder} avoiding the need to create one manually via
         * {@link List<GroupCertificateAuthorityProperties>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupCertificateAuthorityProperties>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #groupCertificateAuthorities(List<GroupCertificateAuthorityProperties>)}.
         * 
         * @param groupCertificateAuthorities
         *        a consumer that will call methods on {@link List<GroupCertificateAuthorityProperties>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupCertificateAuthorities(List<GroupCertificateAuthorityProperties>)
         */
        Builder groupCertificateAuthorities(Consumer<GroupCertificateAuthorityProperties.Builder>... groupCertificateAuthorities);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private List<GroupCertificateAuthorityProperties> groupCertificateAuthorities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupCertificateAuthoritiesResponse model) {
            super(model);
            groupCertificateAuthorities(model.groupCertificateAuthorities);
        }

        public final Collection<GroupCertificateAuthorityProperties.Builder> getGroupCertificateAuthorities() {
            return groupCertificateAuthorities != null ? groupCertificateAuthorities.stream()
                    .map(GroupCertificateAuthorityProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupCertificateAuthorities(
                Collection<GroupCertificateAuthorityProperties> groupCertificateAuthorities) {
            this.groupCertificateAuthorities = ___listOfGroupCertificateAuthorityPropertiesCopier
                    .copy(groupCertificateAuthorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupCertificateAuthorities(GroupCertificateAuthorityProperties... groupCertificateAuthorities) {
            groupCertificateAuthorities(Arrays.asList(groupCertificateAuthorities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupCertificateAuthorities(
                Consumer<GroupCertificateAuthorityProperties.Builder>... groupCertificateAuthorities) {
            groupCertificateAuthorities(Stream.of(groupCertificateAuthorities)
                    .map(c -> GroupCertificateAuthorityProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGroupCertificateAuthorities(
                Collection<GroupCertificateAuthorityProperties.BuilderImpl> groupCertificateAuthorities) {
            this.groupCertificateAuthorities = ___listOfGroupCertificateAuthorityPropertiesCopier
                    .copyFromBuilder(groupCertificateAuthorities);
        }

        @Override
        public ListGroupCertificateAuthoritiesResponse build() {
            return new ListGroupCertificateAuthoritiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
