/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsResponse extends GreengrassResponse implements
        ToCopyableBuilder<ListGroupsResponse.Builder, ListGroupsResponse> {
    private static final SdkField<List<GroupInformation>> GROUPS_FIELD = SdkField
            .<List<GroupInformation>> builder(MarshallingType.LIST)
            .getter(getter(ListGroupsResponse::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GROUPS_FIELD, NEXT_TOKEN_FIELD));

    private final List<GroupInformation> groups;

    private final String nextToken;

    private ListGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.groups = builder.groups;
        this.nextToken = builder.nextToken;
    }

    /**
     * Information about a group.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about a group.
     */
    public List<GroupInformation> groups() {
        return groups;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsResponse)) {
            return false;
        }
        ListGroupsResponse other = (ListGroupsResponse) obj;
        return Objects.equals(groups(), other.groups()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListGroupsResponse").add("Groups", groups()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsResponse, T> g) {
        return obj -> g.apply((ListGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGroupsResponse> {
        /**
         * Information about a group.
         * 
         * @param groups
         *        Information about a group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupInformation> groups);

        /**
         * Information about a group.
         * 
         * @param groups
         *        Information about a group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupInformation... groups);

        /**
         * Information about a group. This is a convenience that creates an instance of the {@link List
         * <GroupInformation>.Builder} avoiding the need to create one manually via {@link List
         * <GroupInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupInformation>.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupInformation>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<GroupInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<GroupInformation>)
         */
        Builder groups(Consumer<GroupInformation.Builder>... groups);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private List<GroupInformation> groups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsResponse model) {
            super(model);
            groups(model.groups);
            nextToken(model.nextToken);
        }

        public final Collection<GroupInformation.Builder> getGroups() {
            return groups != null ? groups.stream().map(GroupInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupInformation> groups) {
            this.groups = ___listOfGroupInformationCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupInformation... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupInformation.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupInformation.BuilderImpl> groups) {
            this.groups = ___listOfGroupInformationCopier.copyFromBuilder(groups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGroupsResponse build() {
            return new ListGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
