/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes that define an Amazon SageMaker machine learning resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SageMakerMachineLearningModelResourceData implements SdkPojo, Serializable,
        ToCopyableBuilder<SageMakerMachineLearningModelResourceData.Builder, SageMakerMachineLearningModelResourceData> {
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SageMakerMachineLearningModelResourceData::destinationPath)).setter(setter(Builder::destinationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPath").build()).build();

    private static final SdkField<String> SAGE_MAKER_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SageMakerMachineLearningModelResourceData::sageMakerJobArn)).setter(setter(Builder::sageMakerJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PATH_FIELD,
            SAGE_MAKER_JOB_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationPath;

    private final String sageMakerJobArn;

    private SageMakerMachineLearningModelResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.sageMakerJobArn = builder.sageMakerJobArn;
    }

    /**
     * The absolute local path of the resource inside the Lambda environment.
     * 
     * @return The absolute local path of the resource inside the Lambda environment.
     */
    public String destinationPath() {
        return destinationPath;
    }

    /**
     * The ARN of the Amazon SageMaker training job that represents the source model.
     * 
     * @return The ARN of the Amazon SageMaker training job that represents the source model.
     */
    public String sageMakerJobArn() {
        return sageMakerJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerJobArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerMachineLearningModelResourceData)) {
            return false;
        }
        SageMakerMachineLearningModelResourceData other = (SageMakerMachineLearningModelResourceData) obj;
        return Objects.equals(destinationPath(), other.destinationPath())
                && Objects.equals(sageMakerJobArn(), other.sageMakerJobArn());
    }

    @Override
    public String toString() {
        return ToString.builder("SageMakerMachineLearningModelResourceData").add("DestinationPath", destinationPath())
                .add("SageMakerJobArn", sageMakerJobArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPath":
            return Optional.ofNullable(clazz.cast(destinationPath()));
        case "SageMakerJobArn":
            return Optional.ofNullable(clazz.cast(sageMakerJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SageMakerMachineLearningModelResourceData, T> g) {
        return obj -> g.apply((SageMakerMachineLearningModelResourceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SageMakerMachineLearningModelResourceData> {
        /**
         * The absolute local path of the resource inside the Lambda environment.
         * 
         * @param destinationPath
         *        The absolute local path of the resource inside the Lambda environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPath(String destinationPath);

        /**
         * The ARN of the Amazon SageMaker training job that represents the source model.
         * 
         * @param sageMakerJobArn
         *        The ARN of the Amazon SageMaker training job that represents the source model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerJobArn(String sageMakerJobArn);
    }

    static final class BuilderImpl implements Builder {
        private String destinationPath;

        private String sageMakerJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerMachineLearningModelResourceData model) {
            destinationPath(model.destinationPath);
            sageMakerJobArn(model.sageMakerJobArn);
        }

        public final String getDestinationPath() {
            return destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        public final String getSageMakerJobArn() {
            return sageMakerJobArn;
        }

        @Override
        public final Builder sageMakerJobArn(String sageMakerJobArn) {
            this.sageMakerJobArn = sageMakerJobArn;
            return this;
        }

        public final void setSageMakerJobArn(String sageMakerJobArn) {
            this.sageMakerJobArn = sageMakerJobArn;
        }

        @Override
        public SageMakerMachineLearningModelResourceData build() {
            return new SageMakerMachineLearningModelResourceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
