/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeviceDefinitionRequest extends GreengrassRequest implements
        ToCopyableBuilder<UpdateDeviceDefinitionRequest.Builder, UpdateDeviceDefinitionRequest> {
    private static final SdkField<String> DEVICE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeviceDefinitionRequest::deviceDefinitionId)).setter(setter(Builder::deviceDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeviceDefinitionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDeviceDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_DEFINITION_ID_FIELD,
            NAME_FIELD));

    private final String deviceDefinitionId;

    private final String name;

    private UpdateDeviceDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.deviceDefinitionId = builder.deviceDefinitionId;
        this.name = builder.name;
    }

    /**
     * The ID of the device definition.
     * 
     * @return The ID of the device definition.
     */
    public String deviceDefinitionId() {
        return deviceDefinitionId;
    }

    /**
     * The name of the definition.
     * 
     * @return The name of the definition.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceDefinitionRequest)) {
            return false;
        }
        UpdateDeviceDefinitionRequest other = (UpdateDeviceDefinitionRequest) obj;
        return Objects.equals(deviceDefinitionId(), other.deviceDefinitionId()) && Objects.equals(name(), other.name());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDeviceDefinitionRequest").add("DeviceDefinitionId", deviceDefinitionId())
                .add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceDefinitionId":
            return Optional.ofNullable(clazz.cast(deviceDefinitionId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateDeviceDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDeviceDefinitionRequest> {
        /**
         * The ID of the device definition.
         * 
         * @param deviceDefinitionId
         *        The ID of the device definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDefinitionId(String deviceDefinitionId);

        /**
         * The name of the definition.
         * 
         * @param name
         *        The name of the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String deviceDefinitionId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceDefinitionRequest model) {
            super(model);
            deviceDefinitionId(model.deviceDefinitionId);
            name(model.name);
        }

        public final String getDeviceDefinitionId() {
            return deviceDefinitionId;
        }

        @Override
        public final Builder deviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
            return this;
        }

        public final void setDeviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceDefinitionRequest build() {
            return new UpdateDeviceDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
