/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupResponse;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountResponse;
import software.amazon.awssdk.services.greengrass.model.BadRequestException;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleRequest;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleResponse;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountRequest;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GreengrassException;
import software.amazon.awssdk.services.greengrass.model.InternalServerErrorException;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsResponse;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.transform.AssociateRoleToGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.AssociateServiceRoleToAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateConnectorDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateCoreDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeviceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateFunctionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateLoggerDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateResourceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSoftwareUpdateJobRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSubscriptionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DisassociateRoleFromGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DisassociateServiceRoleFromAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetAssociatedRoleRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetBulkDeploymentStatusRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectivityInfoRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectorDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetCoreDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeploymentStatusRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeviceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetFunctionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupCertificateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetLoggerDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetResourceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetServiceRoleForAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetSubscriptionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListBulkDeploymentDetailedReportsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListBulkDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListConnectorDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListConnectorDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListCoreDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListCoreDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeviceDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeviceDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListFunctionDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListFunctionDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupCertificateAuthoritiesRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListLoggerDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListLoggerDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListResourceDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListResourceDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListSubscriptionDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListSubscriptionDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ResetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.StartBulkDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.StopBulkDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateConnectivityInfoRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateGroupCertificateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link GreengrassAsyncClient}.
 *
 * @see GreengrassAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGreengrassAsyncClient implements GreengrassAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultGreengrassAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGreengrassAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's
     * permissions should allow Greengrass core Lambda functions to perform actions against the cloud.
     *
     * @param associateRoleToGroupRequest
     * @return A Java Future containing the result of the AssociateRoleToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.AssociateRoleToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateRoleToGroupResponse> associateRoleToGroup(
            AssociateRoleToGroupRequest associateRoleToGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateRoleToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateRoleToGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<AssociateRoleToGroupRequest, AssociateRoleToGroupResponse>()
                    .withMarshaller(new AssociateRoleToGroupRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(associateRoleToGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS
     * IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in
     * the policy ''AWSGreengrassResourceAccessRolePolicy''.
     *
     * @param associateServiceRoleToAccountRequest
     * @return A Java Future containing the result of the AssociateServiceRoleToAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.AssociateServiceRoleToAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateServiceRoleToAccountResponse> associateServiceRoleToAccount(
            AssociateServiceRoleToAccountRequest associateServiceRoleToAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateServiceRoleToAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateServiceRoleToAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateServiceRoleToAccountRequest, AssociateServiceRoleToAccountResponse>()
                            .withMarshaller(new AssociateServiceRoleToAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateServiceRoleToAccountRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a connector definition. You may provide the initial version of the connector definition now or use
     * ''CreateConnectorDefinitionVersion'' at a later time.
     *
     * @param createConnectorDefinitionRequest
     * @return A Java Future containing the result of the CreateConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConnectorDefinitionResponse> createConnectorDefinition(
            CreateConnectorDefinitionRequest createConnectorDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConnectorDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConnectorDefinitionRequest, CreateConnectorDefinitionResponse>()
                            .withMarshaller(new CreateConnectorDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createConnectorDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a connector definition which has already been defined.
     *
     * @param createConnectorDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateConnectorDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateConnectorDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConnectorDefinitionVersionResponse> createConnectorDefinitionVersion(
            CreateConnectorDefinitionVersionRequest createConnectorDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConnectorDefinitionVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateConnectorDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConnectorDefinitionVersionRequest, CreateConnectorDefinitionVersionResponse>()
                            .withMarshaller(new CreateConnectorDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createConnectorDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a core definition. You may provide the initial version of the core definition now or use
     * ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.
     *
     * @param createCoreDefinitionRequest
     *        Information needed to create a core definition.
     * @return A Java Future containing the result of the CreateCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCoreDefinitionResponse> createCoreDefinition(
            CreateCoreDefinitionRequest createCoreDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCoreDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<CreateCoreDefinitionRequest, CreateCoreDefinitionResponse>()
                    .withMarshaller(new CreateCoreDefinitionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createCoreDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly
     * one Greengrass core.
     *
     * @param createCoreDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateCoreDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateCoreDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCoreDefinitionVersionResponse> createCoreDefinitionVersion(
            CreateCoreDefinitionVersionRequest createCoreDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCoreDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCoreDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCoreDefinitionVersionRequest, CreateCoreDefinitionVersionResponse>()
                            .withMarshaller(new CreateCoreDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createCoreDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token''
     * token and the request parameters.
     *
     * @param createDeploymentRequest
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                    .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDeploymentRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a device definition. You may provide the initial version of the device definition now or use
     * ''CreateDeviceDefinitionVersion'' at a later time.
     *
     * @param createDeviceDefinitionRequest
     * @return A Java Future containing the result of the CreateDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeviceDefinitionResponse> createDeviceDefinition(
            CreateDeviceDefinitionRequest createDeviceDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeviceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDeviceDefinitionRequest, CreateDeviceDefinitionResponse>()
                            .withMarshaller(new CreateDeviceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDeviceDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a device definition that has already been defined.
     *
     * @param createDeviceDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateDeviceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeviceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeviceDefinitionVersionResponse> createDeviceDefinitionVersion(
            CreateDeviceDefinitionVersionRequest createDeviceDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeviceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeviceDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDeviceDefinitionVersionRequest, CreateDeviceDefinitionVersionResponse>()
                            .withMarshaller(new CreateDeviceDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDeviceDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be
     * used in a group. You can create an initial version of the definition by providing a list of Lambda functions and
     * their configurations now, or use ''CreateFunctionDefinitionVersion'' later.
     *
     * @param createFunctionDefinitionRequest
     * @return A Java Future containing the result of the CreateFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFunctionDefinitionResponse> createFunctionDefinition(
            CreateFunctionDefinitionRequest createFunctionDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFunctionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFunctionDefinitionRequest, CreateFunctionDefinitionResponse>()
                            .withMarshaller(new CreateFunctionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createFunctionDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a Lambda function definition that has already been defined.
     *
     * @param createFunctionDefinitionVersionRequest
     *        Information needed to create a function definition version.
     * @return A Java Future containing the result of the CreateFunctionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateFunctionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFunctionDefinitionVersionResponse> createFunctionDefinitionVersion(
            CreateFunctionDefinitionVersionRequest createFunctionDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFunctionDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFunctionDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFunctionDefinitionVersionRequest, CreateFunctionDefinitionVersionResponse>()
                            .withMarshaller(new CreateFunctionDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createFunctionDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time.
     * Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a
     * library or command-line application to create and deploy Greengrass groups.
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                    .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.
     *
     * @param createGroupCertificateAuthorityRequest
     * @return A Java Future containing the result of the CreateGroupCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroupCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupCertificateAuthorityResponse> createGroupCertificateAuthority(
            CreateGroupCertificateAuthorityRequest createGroupCertificateAuthorityRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupCertificateAuthorityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGroupCertificateAuthorityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateGroupCertificateAuthorityRequest, CreateGroupCertificateAuthorityResponse>()
                            .withMarshaller(new CreateGroupCertificateAuthorityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createGroupCertificateAuthorityRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a group which has already been defined.
     *
     * @param createGroupVersionRequest
     * @return A Java Future containing the result of the CreateGroupVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroupVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupVersionResponse> createGroupVersion(CreateGroupVersionRequest createGroupVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGroupVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<CreateGroupVersionRequest, CreateGroupVersionResponse>()
                    .withMarshaller(new CreateGroupVersionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createGroupVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a logger definition. You may provide the initial version of the logger definition now or use
     * ''CreateLoggerDefinitionVersion'' at a later time.
     *
     * @param createLoggerDefinitionRequest
     * @return A Java Future containing the result of the CreateLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoggerDefinitionResponse> createLoggerDefinition(
            CreateLoggerDefinitionRequest createLoggerDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLoggerDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLoggerDefinitionRequest, CreateLoggerDefinitionResponse>()
                            .withMarshaller(new CreateLoggerDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLoggerDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a logger definition that has already been defined.
     *
     * @param createLoggerDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateLoggerDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateLoggerDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoggerDefinitionVersionResponse> createLoggerDefinitionVersion(
            CreateLoggerDefinitionVersionRequest createLoggerDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLoggerDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLoggerDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLoggerDefinitionVersionRequest, CreateLoggerDefinitionVersionResponse>()
                            .withMarshaller(new CreateLoggerDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLoggerDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial
     * version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
     *
     * @param createResourceDefinitionRequest
     * @return A Java Future containing the result of the CreateResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceDefinitionResponse> createResourceDefinition(
            CreateResourceDefinitionRequest createResourceDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResourceDefinitionRequest, CreateResourceDefinitionResponse>()
                            .withMarshaller(new CreateResourceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createResourceDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a resource definition that has already been defined.
     *
     * @param createResourceDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateResourceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateResourceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceDefinitionVersionResponse> createResourceDefinitionVersion(
            CreateResourceDefinitionVersionRequest createResourceDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResourceDefinitionVersionRequest, CreateResourceDefinitionVersionResponse>()
                            .withMarshaller(new CreateResourceDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createResourceDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the
     * OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional
     * commands to manage a Greengrass core software update job.
     *
     * @param createSoftwareUpdateJobRequest
     * @return A Java Future containing the result of the CreateSoftwareUpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSoftwareUpdateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSoftwareUpdateJobResponse> createSoftwareUpdateJob(
            CreateSoftwareUpdateJobRequest createSoftwareUpdateJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSoftwareUpdateJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSoftwareUpdateJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateSoftwareUpdateJobRequest, CreateSoftwareUpdateJobResponse>()
                            .withMarshaller(new CreateSoftwareUpdateJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSoftwareUpdateJobRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a subscription definition. You may provide the initial version of the subscription definition now or use
     * ''CreateSubscriptionDefinitionVersion'' at a later time.
     *
     * @param createSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the CreateSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSubscriptionDefinitionResponse> createSubscriptionDefinition(
            CreateSubscriptionDefinitionRequest createSubscriptionDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSubscriptionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateSubscriptionDefinitionRequest, CreateSubscriptionDefinitionResponse>()
                            .withMarshaller(new CreateSubscriptionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSubscriptionDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a subscription definition which has already been defined.
     *
     * @param createSubscriptionDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateSubscriptionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSubscriptionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSubscriptionDefinitionVersionResponse> createSubscriptionDefinitionVersion(
            CreateSubscriptionDefinitionVersionRequest createSubscriptionDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSubscriptionDefinitionVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateSubscriptionDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateSubscriptionDefinitionVersionRequest, CreateSubscriptionDefinitionVersionResponse>()
                            .withMarshaller(new CreateSubscriptionDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSubscriptionDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a connector definition.
     *
     * @param deleteConnectorDefinitionRequest
     * @return A Java Future containing the result of the DeleteConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConnectorDefinitionResponse> deleteConnectorDefinition(
            DeleteConnectorDefinitionRequest deleteConnectorDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConnectorDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectorDefinitionRequest, DeleteConnectorDefinitionResponse>()
                            .withMarshaller(new DeleteConnectorDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteConnectorDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a core definition.
     *
     * @param deleteCoreDefinitionRequest
     * @return A Java Future containing the result of the DeleteCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCoreDefinitionResponse> deleteCoreDefinition(
            DeleteCoreDefinitionRequest deleteCoreDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCoreDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<DeleteCoreDefinitionRequest, DeleteCoreDefinitionResponse>()
                    .withMarshaller(new DeleteCoreDefinitionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteCoreDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a device definition.
     *
     * @param deleteDeviceDefinitionRequest
     * @return A Java Future containing the result of the DeleteDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeviceDefinitionResponse> deleteDeviceDefinition(
            DeleteDeviceDefinitionRequest deleteDeviceDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeviceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDeviceDefinitionRequest, DeleteDeviceDefinitionResponse>()
                            .withMarshaller(new DeleteDeviceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDeviceDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a Lambda function definition.
     *
     * @param deleteFunctionDefinitionRequest
     * @return A Java Future containing the result of the DeleteFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFunctionDefinitionResponse> deleteFunctionDefinition(
            DeleteFunctionDefinitionRequest deleteFunctionDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFunctionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFunctionDefinitionRequest, DeleteFunctionDefinitionResponse>()
                            .withMarshaller(new DeleteFunctionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFunctionDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a group.
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                    .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a logger definition.
     *
     * @param deleteLoggerDefinitionRequest
     * @return A Java Future containing the result of the DeleteLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoggerDefinitionResponse> deleteLoggerDefinition(
            DeleteLoggerDefinitionRequest deleteLoggerDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLoggerDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLoggerDefinitionRequest, DeleteLoggerDefinitionResponse>()
                            .withMarshaller(new DeleteLoggerDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLoggerDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a resource definition.
     *
     * @param deleteResourceDefinitionRequest
     * @return A Java Future containing the result of the DeleteResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceDefinitionResponse> deleteResourceDefinition(
            DeleteResourceDefinitionRequest deleteResourceDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceDefinitionRequest, DeleteResourceDefinitionResponse>()
                            .withMarshaller(new DeleteResourceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteResourceDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a subscription definition.
     *
     * @param deleteSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the DeleteSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSubscriptionDefinitionResponse> deleteSubscriptionDefinition(
            DeleteSubscriptionDefinitionRequest deleteSubscriptionDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSubscriptionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSubscriptionDefinitionRequest, DeleteSubscriptionDefinitionResponse>()
                            .withMarshaller(new DeleteSubscriptionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSubscriptionDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Disassociates the role from a group.
     *
     * @param disassociateRoleFromGroupRequest
     * @return A Java Future containing the result of the DisassociateRoleFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateRoleFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateRoleFromGroupResponse> disassociateRoleFromGroup(
            DisassociateRoleFromGroupRequest disassociateRoleFromGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateRoleFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateRoleFromGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateRoleFromGroupRequest, DisassociateRoleFromGroupResponse>()
                            .withMarshaller(new DisassociateRoleFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateRoleFromGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.
     *
     * @param disassociateServiceRoleFromAccountRequest
     * @return A Java Future containing the result of the DisassociateServiceRoleFromAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateServiceRoleFromAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateServiceRoleFromAccountResponse> disassociateServiceRoleFromAccount(
            DisassociateServiceRoleFromAccountRequest disassociateServiceRoleFromAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateServiceRoleFromAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateServiceRoleFromAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateServiceRoleFromAccountRequest, DisassociateServiceRoleFromAccountResponse>()
                            .withMarshaller(new DisassociateServiceRoleFromAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateServiceRoleFromAccountRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the role associated with a particular group.
     *
     * @param getAssociatedRoleRequest
     * @return A Java Future containing the result of the GetAssociatedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetAssociatedRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssociatedRoleResponse> getAssociatedRole(GetAssociatedRoleRequest getAssociatedRoleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssociatedRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAssociatedRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetAssociatedRoleRequest, GetAssociatedRoleResponse>()
                    .withMarshaller(new GetAssociatedRoleRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAssociatedRoleRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the status of a bulk deployment.
     *
     * @param getBulkDeploymentStatusRequest
     * @return A Java Future containing the result of the GetBulkDeploymentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetBulkDeploymentStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBulkDeploymentStatusResponse> getBulkDeploymentStatus(
            GetBulkDeploymentStatusRequest getBulkDeploymentStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBulkDeploymentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBulkDeploymentStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetBulkDeploymentStatusRequest, GetBulkDeploymentStatusResponse>()
                            .withMarshaller(new GetBulkDeploymentStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getBulkDeploymentStatusRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the connectivity information for a core.
     *
     * @param getConnectivityInfoRequest
     * @return A Java Future containing the result of the GetConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectivityInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConnectivityInfoResponse> getConnectivityInfo(
            GetConnectivityInfoRequest getConnectivityInfoRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConnectivityInfoResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConnectivityInfoResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetConnectivityInfoRequest, GetConnectivityInfoResponse>()
                    .withMarshaller(new GetConnectivityInfoRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getConnectivityInfoRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a connector definition.
     *
     * @param getConnectorDefinitionRequest
     * @return A Java Future containing the result of the GetConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConnectorDefinitionResponse> getConnectorDefinition(
            GetConnectorDefinitionRequest getConnectorDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConnectorDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetConnectorDefinitionRequest, GetConnectorDefinitionResponse>()
                            .withMarshaller(new GetConnectorDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getConnectorDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a connector definition version, including the connectors that the version contains.
     * Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud
     * services.
     *
     * @param getConnectorDefinitionVersionRequest
     * @return A Java Future containing the result of the GetConnectorDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectorDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConnectorDefinitionVersionResponse> getConnectorDefinitionVersion(
            GetConnectorDefinitionVersionRequest getConnectorDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConnectorDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConnectorDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetConnectorDefinitionVersionRequest, GetConnectorDefinitionVersionResponse>()
                            .withMarshaller(new GetConnectorDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getConnectorDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionRequest
     * @return A Java Future containing the result of the GetCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCoreDefinitionResponse> getCoreDefinition(GetCoreDefinitionRequest getCoreDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCoreDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetCoreDefinitionRequest, GetCoreDefinitionResponse>()
                    .withMarshaller(new GetCoreDefinitionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getCoreDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionVersionRequest
     * @return A Java Future containing the result of the GetCoreDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetCoreDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCoreDefinitionVersionResponse> getCoreDefinitionVersion(
            GetCoreDefinitionVersionRequest getCoreDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCoreDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCoreDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetCoreDefinitionVersionRequest, GetCoreDefinitionVersionResponse>()
                            .withMarshaller(new GetCoreDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getCoreDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the status of a deployment.
     *
     * @param getDeploymentStatusRequest
     * @return A Java Future containing the result of the GetDeploymentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeploymentStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentStatusResponse> getDeploymentStatus(
            GetDeploymentStatusRequest getDeploymentStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentStatusRequest, GetDeploymentStatusResponse>()
                    .withMarshaller(new GetDeploymentStatusRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getDeploymentStatusRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a device definition.
     *
     * @param getDeviceDefinitionRequest
     * @return A Java Future containing the result of the GetDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceDefinitionResponse> getDeviceDefinition(
            GetDeviceDefinitionRequest getDeviceDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeviceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetDeviceDefinitionRequest, GetDeviceDefinitionResponse>()
                    .withMarshaller(new GetDeviceDefinitionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getDeviceDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a device definition version.
     *
     * @param getDeviceDefinitionVersionRequest
     * @return A Java Future containing the result of the GetDeviceDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeviceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceDefinitionVersionResponse> getDeviceDefinitionVersion(
            GetDeviceDefinitionVersionRequest getDeviceDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeviceDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetDeviceDefinitionVersionRequest, GetDeviceDefinitionVersionResponse>()
                            .withMarshaller(new GetDeviceDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getDeviceDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a Lambda function definition, including its creation time and latest version.
     *
     * @param getFunctionDefinitionRequest
     * @return A Java Future containing the result of the GetFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFunctionDefinitionResponse> getFunctionDefinition(
            GetFunctionDefinitionRequest getFunctionDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFunctionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetFunctionDefinitionRequest, GetFunctionDefinitionResponse>()
                    .withMarshaller(new GetFunctionDefinitionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getFunctionDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a Lambda function definition version, including which Lambda functions are included
     * in the version and their configurations.
     *
     * @param getFunctionDefinitionVersionRequest
     * @return A Java Future containing the result of the GetFunctionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetFunctionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFunctionDefinitionVersionResponse> getFunctionDefinitionVersion(
            GetFunctionDefinitionVersionRequest getFunctionDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFunctionDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFunctionDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetFunctionDefinitionVersionRequest, GetFunctionDefinitionVersionResponse>()
                            .withMarshaller(new GetFunctionDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getFunctionDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a group.
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>()
                    .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retreives the CA associated with a group. Returns the public key of the CA.
     *
     * @param getGroupCertificateAuthorityRequest
     * @return A Java Future containing the result of the GetGroupCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupCertificateAuthority
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupCertificateAuthorityResponse> getGroupCertificateAuthority(
            GetGroupCertificateAuthorityRequest getGroupCertificateAuthorityRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupCertificateAuthorityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGroupCertificateAuthorityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetGroupCertificateAuthorityRequest, GetGroupCertificateAuthorityResponse>()
                            .withMarshaller(new GetGroupCertificateAuthorityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getGroupCertificateAuthorityRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the current configuration for the CA used by the group.
     *
     * @param getGroupCertificateConfigurationRequest
     * @return A Java Future containing the result of the GetGroupCertificateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupCertificateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupCertificateConfigurationResponse> getGroupCertificateConfiguration(
            GetGroupCertificateConfigurationRequest getGroupCertificateConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupCertificateConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetGroupCertificateConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetGroupCertificateConfigurationRequest, GetGroupCertificateConfigurationResponse>()
                            .withMarshaller(new GetGroupCertificateConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getGroupCertificateConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a group version.
     *
     * @param getGroupVersionRequest
     * @return A Java Future containing the result of the GetGroupVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupVersionResponse> getGroupVersion(GetGroupVersionRequest getGroupVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGroupVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetGroupVersionRequest, GetGroupVersionResponse>()
                    .withMarshaller(new GetGroupVersionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGroupVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a logger definition.
     *
     * @param getLoggerDefinitionRequest
     * @return A Java Future containing the result of the GetLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoggerDefinitionResponse> getLoggerDefinition(
            GetLoggerDefinitionRequest getLoggerDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoggerDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetLoggerDefinitionRequest, GetLoggerDefinitionResponse>()
                    .withMarshaller(new GetLoggerDefinitionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getLoggerDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a logger definition version.
     *
     * @param getLoggerDefinitionVersionRequest
     * @return A Java Future containing the result of the GetLoggerDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetLoggerDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoggerDefinitionVersionResponse> getLoggerDefinitionVersion(
            GetLoggerDefinitionVersionRequest getLoggerDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoggerDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoggerDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetLoggerDefinitionVersionRequest, GetLoggerDefinitionVersionResponse>()
                            .withMarshaller(new GetLoggerDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getLoggerDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a resource definition, including its creation time and latest version.
     *
     * @param getResourceDefinitionRequest
     * @return A Java Future containing the result of the GetResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceDefinitionResponse> getResourceDefinition(
            GetResourceDefinitionRequest getResourceDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetResourceDefinitionRequest, GetResourceDefinitionResponse>()
                    .withMarshaller(new GetResourceDefinitionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getResourceDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a resource definition version, including which resources are included in the version.
     *
     * @param getResourceDefinitionVersionRequest
     * @return A Java Future containing the result of the GetResourceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetResourceDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceDefinitionVersionResponse> getResourceDefinitionVersion(
            GetResourceDefinitionVersionRequest getResourceDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetResourceDefinitionVersionRequest, GetResourceDefinitionVersionResponse>()
                            .withMarshaller(new GetResourceDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getResourceDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the service role that is attached to your account.
     *
     * @param getServiceRoleForAccountRequest
     * @return A Java Future containing the result of the GetServiceRoleForAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetServiceRoleForAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceRoleForAccountResponse> getServiceRoleForAccount(
            GetServiceRoleForAccountRequest getServiceRoleForAccountRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetServiceRoleForAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetServiceRoleForAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetServiceRoleForAccountRequest, GetServiceRoleForAccountResponse>()
                            .withMarshaller(new GetServiceRoleForAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getServiceRoleForAccountRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a subscription definition.
     *
     * @param getSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the GetSubscriptionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSubscriptionDefinitionResponse> getSubscriptionDefinition(
            GetSubscriptionDefinitionRequest getSubscriptionDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSubscriptionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetSubscriptionDefinitionRequest, GetSubscriptionDefinitionResponse>()
                            .withMarshaller(new GetSubscriptionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getSubscriptionDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a subscription definition version.
     *
     * @param getSubscriptionDefinitionVersionRequest
     * @return A Java Future containing the result of the GetSubscriptionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetSubscriptionDefinitionVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSubscriptionDefinitionVersionResponse> getSubscriptionDefinitionVersion(
            GetSubscriptionDefinitionVersionRequest getSubscriptionDefinitionVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSubscriptionDefinitionVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSubscriptionDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetSubscriptionDefinitionVersionRequest, GetSubscriptionDefinitionVersionResponse>()
                            .withMarshaller(new GetSubscriptionDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getSubscriptionDefinitionVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current
     * deployment status.
     *
     * @param listBulkDeploymentDetailedReportsRequest
     * @return A Java Future containing the result of the ListBulkDeploymentDetailedReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeploymentDetailedReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBulkDeploymentDetailedReportsResponse> listBulkDeploymentDetailedReports(
            ListBulkDeploymentDetailedReportsRequest listBulkDeploymentDetailedReportsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBulkDeploymentDetailedReportsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListBulkDeploymentDetailedReportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListBulkDeploymentDetailedReportsRequest, ListBulkDeploymentDetailedReportsResponse>()
                            .withMarshaller(new ListBulkDeploymentDetailedReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listBulkDeploymentDetailedReportsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns a list of bulk deployments.
     *
     * @param listBulkDeploymentsRequest
     * @return A Java Future containing the result of the ListBulkDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBulkDeploymentsResponse> listBulkDeployments(
            ListBulkDeploymentsRequest listBulkDeploymentsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBulkDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBulkDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListBulkDeploymentsRequest, ListBulkDeploymentsResponse>()
                    .withMarshaller(new ListBulkDeploymentsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listBulkDeploymentsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the
     * Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other
     * cloud services.
     *
     * @param listConnectorDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListConnectorDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConnectorDefinitionVersionsResponse> listConnectorDefinitionVersions(
            ListConnectorDefinitionVersionsRequest listConnectorDefinitionVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConnectorDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConnectorDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListConnectorDefinitionVersionsRequest, ListConnectorDefinitionVersionsResponse>()
                            .withMarshaller(new ListConnectorDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listConnectorDefinitionVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of connector definitions.
     *
     * @param listConnectorDefinitionsRequest
     * @return A Java Future containing the result of the ListConnectorDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConnectorDefinitionsResponse> listConnectorDefinitions(
            ListConnectorDefinitionsRequest listConnectorDefinitionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConnectorDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConnectorDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListConnectorDefinitionsRequest, ListConnectorDefinitionsResponse>()
                            .withMarshaller(new ListConnectorDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listConnectorDefinitionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a core definition.
     *
     * @param listCoreDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListCoreDefinitionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCoreDefinitionVersionsResponse> listCoreDefinitionVersions(
            ListCoreDefinitionVersionsRequest listCoreDefinitionVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCoreDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCoreDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListCoreDefinitionVersionsRequest, ListCoreDefinitionVersionsResponse>()
                            .withMarshaller(new ListCoreDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listCoreDefinitionVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of core definitions.
     *
     * @param listCoreDefinitionsRequest
     * @return A Java Future containing the result of the ListCoreDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCoreDefinitionsResponse> listCoreDefinitions(
            ListCoreDefinitionsRequest listCoreDefinitionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCoreDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCoreDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListCoreDefinitionsRequest, ListCoreDefinitionsResponse>()
                    .withMarshaller(new ListCoreDefinitionsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listCoreDefinitionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns a history of deployments for the group.
     *
     * @param listDeploymentsRequest
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListDeploymentsRequest, ListDeploymentsResponse>()
                    .withMarshaller(new ListDeploymentsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDeploymentsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a device definition.
     *
     * @param listDeviceDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListDeviceDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeviceDefinitionVersionsResponse> listDeviceDefinitionVersions(
            ListDeviceDefinitionVersionsRequest listDeviceDefinitionVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeviceDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeviceDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListDeviceDefinitionVersionsRequest, ListDeviceDefinitionVersionsResponse>()
                            .withMarshaller(new ListDeviceDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listDeviceDefinitionVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of device definitions.
     *
     * @param listDeviceDefinitionsRequest
     * @return A Java Future containing the result of the ListDeviceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeviceDefinitionsResponse> listDeviceDefinitions(
            ListDeviceDefinitionsRequest listDeviceDefinitionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeviceDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeviceDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListDeviceDefinitionsRequest, ListDeviceDefinitionsResponse>()
                    .withMarshaller(new ListDeviceDefinitionsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listDeviceDefinitionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a Lambda function definition.
     *
     * @param listFunctionDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListFunctionDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFunctionDefinitionVersionsResponse> listFunctionDefinitionVersions(
            ListFunctionDefinitionVersionsRequest listFunctionDefinitionVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFunctionDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFunctionDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListFunctionDefinitionVersionsRequest, ListFunctionDefinitionVersionsResponse>()
                            .withMarshaller(new ListFunctionDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listFunctionDefinitionVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of Lambda function definitions.
     *
     * @param listFunctionDefinitionsRequest
     * @return A Java Future containing the result of the ListFunctionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFunctionDefinitionsResponse> listFunctionDefinitions(
            ListFunctionDefinitionsRequest listFunctionDefinitionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFunctionDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFunctionDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListFunctionDefinitionsRequest, ListFunctionDefinitionsResponse>()
                            .withMarshaller(new ListFunctionDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listFunctionDefinitionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the current CAs for a group.
     *
     * @param listGroupCertificateAuthoritiesRequest
     * @return A Java Future containing the result of the ListGroupCertificateAuthorities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroupCertificateAuthorities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupCertificateAuthoritiesResponse> listGroupCertificateAuthorities(
            ListGroupCertificateAuthoritiesRequest listGroupCertificateAuthoritiesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupCertificateAuthoritiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupCertificateAuthoritiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListGroupCertificateAuthoritiesRequest, ListGroupCertificateAuthoritiesResponse>()
                            .withMarshaller(new ListGroupCertificateAuthoritiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listGroupCertificateAuthoritiesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a group.
     *
     * @param listGroupVersionsRequest
     * @return A Java Future containing the result of the ListGroupVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroupVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupVersionsResponse> listGroupVersions(ListGroupVersionsRequest listGroupVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListGroupVersionsRequest, ListGroupVersionsResponse>()
                    .withMarshaller(new ListGroupVersionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listGroupVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of groups.
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>()
                    .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listGroupsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a logger definition.
     *
     * @param listLoggerDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListLoggerDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLoggerDefinitionVersionsResponse> listLoggerDefinitionVersions(
            ListLoggerDefinitionVersionsRequest listLoggerDefinitionVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLoggerDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLoggerDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListLoggerDefinitionVersionsRequest, ListLoggerDefinitionVersionsResponse>()
                            .withMarshaller(new ListLoggerDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listLoggerDefinitionVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of logger definitions.
     *
     * @param listLoggerDefinitionsRequest
     * @return A Java Future containing the result of the ListLoggerDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLoggerDefinitionsResponse> listLoggerDefinitions(
            ListLoggerDefinitionsRequest listLoggerDefinitionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLoggerDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLoggerDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListLoggerDefinitionsRequest, ListLoggerDefinitionsResponse>()
                    .withMarshaller(new ListLoggerDefinitionsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listLoggerDefinitionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a resource definition.
     *
     * @param listResourceDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListResourceDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceDefinitionVersionsResponse> listResourceDefinitionVersions(
            ListResourceDefinitionVersionsRequest listResourceDefinitionVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourceDefinitionVersionsRequest, ListResourceDefinitionVersionsResponse>()
                            .withMarshaller(new ListResourceDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listResourceDefinitionVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of resource definitions.
     *
     * @param listResourceDefinitionsRequest
     * @return A Java Future containing the result of the ListResourceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceDefinitionsResponse> listResourceDefinitions(
            ListResourceDefinitionsRequest listResourceDefinitionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourceDefinitionsRequest, ListResourceDefinitionsResponse>()
                            .withMarshaller(new ListResourceDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listResourceDefinitionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a subscription definition.
     *
     * @param listSubscriptionDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListSubscriptionDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitionVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSubscriptionDefinitionVersionsResponse> listSubscriptionDefinitionVersions(
            ListSubscriptionDefinitionVersionsRequest listSubscriptionDefinitionVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSubscriptionDefinitionVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListSubscriptionDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListSubscriptionDefinitionVersionsRequest, ListSubscriptionDefinitionVersionsResponse>()
                            .withMarshaller(new ListSubscriptionDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSubscriptionDefinitionVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of subscription definitions.
     *
     * @param listSubscriptionDefinitionsRequest
     * @return A Java Future containing the result of the ListSubscriptionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSubscriptionDefinitionsResponse> listSubscriptionDefinitions(
            ListSubscriptionDefinitionsRequest listSubscriptionDefinitionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSubscriptionDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSubscriptionDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListSubscriptionDefinitionsRequest, ListSubscriptionDefinitionsResponse>()
                            .withMarshaller(new ListSubscriptionDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSubscriptionDefinitionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Resets a group's deployments.
     *
     * @param resetDeploymentsRequest
     *        Information needed to reset deployments.
     * @return A Java Future containing the result of the ResetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ResetDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetDeploymentsResponse> resetDeployments(ResetDeploymentsRequest resetDeploymentsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ResetDeploymentsRequest, ResetDeploymentsResponse>()
                    .withMarshaller(new ResetDeploymentsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(resetDeploymentsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group
     * versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We
     * recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These
     * requests are idempotent with respect to the token and the request parameters.
     *
     * @param startBulkDeploymentRequest
     * @return A Java Future containing the result of the StartBulkDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.StartBulkDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartBulkDeploymentResponse> startBulkDeployment(
            StartBulkDeploymentRequest startBulkDeploymentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBulkDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartBulkDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<StartBulkDeploymentRequest, StartBulkDeploymentResponse>()
                    .withMarshaller(new StartBulkDeploymentRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(startBulkDeploymentRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is
     * stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This
     * action doesn't rollback completed deployments or cancel pending deployments.
     *
     * @param stopBulkDeploymentRequest
     * @return A Java Future containing the result of the StopBulkDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.StopBulkDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopBulkDeploymentResponse> stopBulkDeployment(StopBulkDeploymentRequest stopBulkDeploymentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopBulkDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopBulkDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<StopBulkDeploymentRequest, StopBulkDeploymentResponse>()
                    .withMarshaller(new StopBulkDeploymentRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(stopBulkDeploymentRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the connectivity information for the core. Any devices that belong to the group which has this core will
     * receive this information in order to find the location of the core and connect to it.
     *
     * @param updateConnectivityInfoRequest
     *        Connectivity information.
     * @return A Java Future containing the result of the UpdateConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateConnectivityInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConnectivityInfoResponse> updateConnectivityInfo(
            UpdateConnectivityInfoRequest updateConnectivityInfoRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConnectivityInfoResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConnectivityInfoResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectivityInfoRequest, UpdateConnectivityInfoResponse>()
                            .withMarshaller(new UpdateConnectivityInfoRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateConnectivityInfoRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a connector definition.
     *
     * @param updateConnectorDefinitionRequest
     * @return A Java Future containing the result of the UpdateConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateConnectorDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConnectorDefinitionResponse> updateConnectorDefinition(
            UpdateConnectorDefinitionRequest updateConnectorDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConnectorDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectorDefinitionRequest, UpdateConnectorDefinitionResponse>()
                            .withMarshaller(new UpdateConnectorDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateConnectorDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a core definition.
     *
     * @param updateCoreDefinitionRequest
     * @return A Java Future containing the result of the UpdateCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateCoreDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCoreDefinitionResponse> updateCoreDefinition(
            UpdateCoreDefinitionRequest updateCoreDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCoreDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<UpdateCoreDefinitionRequest, UpdateCoreDefinitionResponse>()
                    .withMarshaller(new UpdateCoreDefinitionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateCoreDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a device definition.
     *
     * @param updateDeviceDefinitionRequest
     * @return A Java Future containing the result of the UpdateDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateDeviceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDeviceDefinitionResponse> updateDeviceDefinition(
            UpdateDeviceDefinitionRequest updateDeviceDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDeviceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDeviceDefinitionRequest, UpdateDeviceDefinitionResponse>()
                            .withMarshaller(new UpdateDeviceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateDeviceDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a Lambda function definition.
     *
     * @param updateFunctionDefinitionRequest
     * @return A Java Future containing the result of the UpdateFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateFunctionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFunctionDefinitionResponse> updateFunctionDefinition(
            UpdateFunctionDefinitionRequest updateFunctionDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFunctionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFunctionDefinitionRequest, UpdateFunctionDefinitionResponse>()
                            .withMarshaller(new UpdateFunctionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateFunctionDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a group.
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                    .withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the Certificate expiry time for a group.
     *
     * @param updateGroupCertificateConfigurationRequest
     * @return A Java Future containing the result of the UpdateGroupCertificateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateGroupCertificateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupCertificateConfigurationResponse> updateGroupCertificateConfiguration(
            UpdateGroupCertificateConfigurationRequest updateGroupCertificateConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGroupCertificateConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateGroupCertificateConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateGroupCertificateConfigurationRequest, UpdateGroupCertificateConfigurationResponse>()
                            .withMarshaller(new UpdateGroupCertificateConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateGroupCertificateConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a logger definition.
     *
     * @param updateLoggerDefinitionRequest
     * @return A Java Future containing the result of the UpdateLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateLoggerDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLoggerDefinitionResponse> updateLoggerDefinition(
            UpdateLoggerDefinitionRequest updateLoggerDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLoggerDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateLoggerDefinitionRequest, UpdateLoggerDefinitionResponse>()
                            .withMarshaller(new UpdateLoggerDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateLoggerDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a resource definition.
     *
     * @param updateResourceDefinitionRequest
     * @return A Java Future containing the result of the UpdateResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateResourceDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceDefinitionResponse> updateResourceDefinition(
            UpdateResourceDefinitionRequest updateResourceDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceDefinitionRequest, UpdateResourceDefinitionResponse>()
                            .withMarshaller(new UpdateResourceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateResourceDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a subscription definition.
     *
     * @param updateSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the UpdateSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateSubscriptionDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSubscriptionDefinitionResponse> updateSubscriptionDefinition(
            UpdateSubscriptionDefinitionRequest updateSubscriptionDefinitionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSubscriptionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateSubscriptionDefinitionRequest, UpdateSubscriptionDefinitionResponse>()
                            .withMarshaller(new UpdateSubscriptionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateSubscriptionDefinitionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(GreengrassException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
